/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.dynamic;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.jms.JMSAdminFactory;
import kd.bos.mq.jms.JMSInfo;
import kd.bos.mq.jms.JMSSessionFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.dynamic.AbstractDynamicQueueManager;

public class DynamicJMSQueueManager
extends AbstractDynamicQueueManager {
    @Override
    public boolean deleteQueue(String queueName) {
        try {
            String realName = QueueManager.getRealQueueName(this.region, queueName);
            JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(this.region);
            JMSAdminFactory.getJMSAdminImpl(jmsInfo.getType()).deleteQueue(jmsInfo, realName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.mqException, "deleteQueue:" + queueName, (Throwable)e);
        }
        return true;
    }

    @Override
    public boolean deleteQueueByRealName(String realQueueName) {
        try {
            JMSInfo jmsInfo = JMSSessionFactory.getJmsInfoByRegion(this.region);
            JMSAdminFactory.getJMSAdminImpl(jmsInfo.getType()).deleteQueue(jmsInfo, realQueueName);
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.mqException, "deleteQueue:" + realQueueName, (Throwable)e);
        }
        return true;
    }
}

