/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionHandler;
import kd.bos.mq.support.partition.ZKQueueManager;
import kd.bos.util.StringUtils;

public class AppIdPartition
implements PartitionHandler {
    @Override
    public String getPartitionQueueName(String queueName, String appId) {
        String queueNameWithAppId = queueName + (StringUtils.isNotEmpty((String)appId) ? "." + appId : "");
        return queueNameWithAppId;
    }

    @Override
    public void prePublish(String region, String queueName, String appId) {
        String originQueueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, originQueueRealName);
        String queueNameWithAppId = queueName + "." + appId;
        String queueRealNameNew = QueueManager.getRealQueueName(region, queueNameWithAppId);
        if (!QueueManager.queueHasDefine(queueRealNameNew)) {
            QueueDef defNew = QueueManager.redefineQueueDef(def, appId, queueNameWithAppId);
            QueueManager._$defineQueue(queueRealNameNew, defNew);
        }
        ZKQueueManager.saveMqQueueMeta(region, queueName, appId, queueRealNameNew);
        QueueManager.broadcastConsumerIfNeed(region, def, queueRealNameNew, appId);
    }
}

