/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.framework.zoowhisper.NodeChangeListener;
import kd.bos.framework.zoowhisper.ZooEventifyCenter;
import kd.bos.framework.zoowhisper.ZooEventifyCenterFactory;
import kd.bos.instance.Instance;
import kd.bos.mq.support.partition.BroadcastConsumer;
import kd.bos.mq.support.partition.BroadcastResType;
import kd.bos.mq.support.partition.ZKQueueManager;
import kd.bos.util.CoreConstants;
import kd.bos.util.StringUtils;

public class BroadcastConsumerWrapper
implements BroadcastConsumer {
    private static Set<String> validBroadcastQueue = new HashSet<String>();
    private static Map<String, AtomicInteger> mqCount = new HashMap<String, AtomicInteger>();
    private static final int FREQUENCY = Integer.parseInt(System.getProperty("mq.queue.partition.broadcast.down.frequency", "10"));
    private final BroadcastConsumer broadcastConsumer;
    private static final AtomicBoolean isInitServiceInfoListener = new AtomicBoolean(false);
    private static Map<String, String> appId2appNameMap = new HashMap<String, String>();
    private static Map<String, List<ServiceInfo>> appName2serviceInfoListMap = new HashMap<String, List<ServiceInfo>>();

    public BroadcastConsumerWrapper(BroadcastConsumer broadcastConsumer) {
        this.broadcastConsumer = broadcastConsumer;
        this.initServiceListener();
    }

    public static List<ServiceInfo> getServiceInfoListByAppId(String appId) {
        String appName = appId2appNameMap.get(appId);
        if (StringUtils.isEmpty((String)appName)) {
            return null;
        }
        return appName2serviceInfoListMap.get(appId2appNameMap.get(appId));
    }

    public static List<ServiceInfo> getAllServiceInfoList() {
        Collection<List<ServiceInfo>> listCollection = appName2serviceInfoListMap.values();
        ArrayList<ServiceInfo> allServiceInfoList = new ArrayList<ServiceInfo>(listCollection.size() * 10);
        listCollection.stream().forEach(allServiceInfoList::addAll);
        return allServiceInfoList;
    }

    private void initServiceListener() {
        if (isInitServiceInfoListener.compareAndSet(false, true)) {
            ZooEventifyCenter messageCenter = ZooEventifyCenterFactory.getMessageCenter();
            messageCenter.addWatch("configUrl", CoreConstants.MONITORROOTPATH, new NodeChangeListener(){

                public void onChange(String key, String value) {
                    BroadcastConsumerWrapper.this.updateServiceInfo();
                }
            });
            this.updateServiceInfo();
        }
    }

    private void updateServiceInfo() {
        List<JSONObject> serviceInfoJsonObjectList = ZKQueueManager.allNodes();
        HashMap<String, List<ServiceInfo>> newAppName2serviceInfoListMap = new HashMap<String, List<ServiceInfo>>(serviceInfoJsonObjectList.size());
        HashMap<String, String> newAppId2appNameMap = new HashMap<String, String>(serviceInfoJsonObjectList.size());
        HashSet<String> processedAppNameSet = new HashSet<String>(serviceInfoJsonObjectList.size());
        for (JSONObject tempJSONObj : serviceInfoJsonObjectList) {
            String tempAppName = tempJSONObj.getString("appName");
            String tempIp = tempJSONObj.getString("ip");
            String tempMonitorPort = tempJSONObj.getString("monitorPort");
            ServiceInfo serviceInfo = new ServiceInfo(tempAppName, tempIp, tempMonitorPort);
            List serviceInfoList = newAppName2serviceInfoListMap.computeIfAbsent(tempAppName, k -> new ArrayList());
            serviceInfoList.add(serviceInfo);
            if (!processedAppNameSet.contains(tempAppName) && Instance.isAppSplit() && tempJSONObj.get((Object)"appIds") != null) {
                JSONArray appIdsJsonArray = tempJSONObj.getJSONArray("appIds");
                for (Object tempObj : appIdsJsonArray) {
                    newAppId2appNameMap.putIfAbsent(tempObj.toString(), tempAppName);
                }
            }
            processedAppNameSet.add(tempAppName);
        }
        appName2serviceInfoListMap = newAppName2serviceInfoListMap;
        appId2appNameMap = newAppId2appNameMap;
        validBroadcastQueue.clear();
        mqCount.clear();
    }

    @Override
    public String getName() {
        return "wrapper";
    }

    @Override
    public BroadcastResType broadRegisterConsumer(String region, String queueName, String queueRealName, String appId) {
        BroadcastResType broadcastResType;
        if ("mq".equals(this.broadcastConsumer.getName())) {
            AtomicInteger count = mqCount.get(queueRealName);
            if (count == null) {
                mqCount.put(queueRealName, new AtomicInteger(1));
            } else {
                count.incrementAndGet();
            }
        }
        if ((broadcastResType = this.broadcastConsumer.broadRegisterConsumer(region, queueName, queueRealName, appId)) == BroadcastResType.ALL) {
            validBroadcastQueue.add(queueRealName);
        }
        return broadcastResType;
    }

    public static boolean needBroadcastSync(String queueRealName) {
        AtomicInteger count = mqCount.get(queueRealName);
        if (count != null && count.get() % FREQUENCY == 0) {
            if (count.get() > 99999) {
                mqCount.remove(queueRealName);
            }
            count.incrementAndGet();
            return true;
        }
        return false;
    }

    public static boolean validBroadcast(String queueRealName) {
        return validBroadcastQueue.contains(queueRealName);
    }

    public static class ServiceInfo {
        private String appName;
        private String ip;
        private String monitorPort;

        public ServiceInfo(String appName, String ip, String monitorPort) {
            this.appName = appName;
            this.ip = ip;
            this.monitorPort = monitorPort;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getIp() {
            return this.ip;
        }

        public String getMonitorPort() {
            return this.monitorPort;
        }

        public String toString() {
            return "ServiceInfo{appName='" + this.appName + '\'' + ", ip='" + this.ip + '\'' + ", monitorPort='" + this.monitorPort + '\'' + '}';
        }
    }
}

