/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.init.MQInit;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.partition.PartitionMessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;

public class MqFactoryWrapper
extends MQFactory {
    private final MQFactory mqFactory;

    public MqFactoryWrapper(MQFactory mqFactory) {
        if (mqFactory == null) {
            throw new IllegalArgumentException("mqFactory == null");
        }
        this.mqFactory = mqFactory;
    }

    @Override
    public MessagePublisher createSimplePublisher(String region, String queueName) {
        return this.mqFactory.createSimplePublisher(region, queueName);
    }

    @Override
    public MessagePublisher $createPublisherWithAppid(String region, QueueDef queue, String appid) {
        return this.mqFactory.$createPublisherWithAppid(region, queue, appid);
    }

    @Override
    public MessagePublisher createPartitionPublisher(String region, String queueName, PartitionStrategy partitionStrategy) {
        if (region == null) {
            throw new KDException(BosErrorCode.mqConfiguration, new Object[]{"region cann`t been null: " + region + "/" + queueName});
        }
        MQInit.waitForMQFinishInit(region);
        String queueRealName = QueueManager.getRealQueueName(region, queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName(region, queueRealName);
        if (def == null) {
            throw new KDException(BosErrorCode.mqConfiguration, new Object[]{"queue not configured for " + region + "/" + queueName});
        }
        return new PartitionMessagePublisher(this.mqFactory, region, queueName, partitionStrategy);
    }

    @Override
    public MessagePublisher $createPublisherWithRealQueueName(String region, String realQueueName) {
        return this.mqFactory.$createPublisherWithRealQueueName(region, realQueueName);
    }
}

