/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import java.util.HashMap;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionHandlerFactory;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.util.StringUtils;

public class PartitionMessagePublisher
implements MessagePublisher {
    private static final Log logger = LogFactory.getLog(PartitionMessagePublisher.class);
    private final MQFactory mqFactory;
    private String queueName;
    private String region;
    private PartitionStrategy partitionStrategy;
    private HashMap<String, MessagePublisher> publishers = new HashMap();

    public PartitionMessagePublisher(MQFactory mqFactory, String region, String queueName, PartitionStrategy partitionStrategy) {
        this.mqFactory = mqFactory;
        this.region = region;
        this.queueName = queueName;
        this.partitionStrategy = partitionStrategy;
    }

    private MessagePublisher getRealPublisher(String region, String queueName, String partitionKey) {
        String partitionQueueName = PartitionHandlerFactory.get(this.partitionStrategy).getPartitionQueueName(queueName, partitionKey);
        String publisherKey = region + "." + partitionQueueName;
        return this.publishers.computeIfAbsent(publisherKey, k -> this.mqFactory.createSimplePublisher(region, partitionQueueName));
    }

    @Override
    public void publish(byte[] message) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
    }

    @Override
    public void publish(String message) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
    }

    @Override
    public void publish(Object message) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
    }

    @Override
    public void publish(Object message, String partitionKey) {
        if (!StringUtils.isNotEmpty((String)partitionKey)) {
            throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
        }
        PartitionHandlerFactory.get(this.partitionStrategy).prePublish(this.region, this.queueName, partitionKey);
        this.getRealPublisher(this.region, this.queueName, partitionKey).publish(message);
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"partitionPublisher do not support publishInDbTranscation"});
    }

    @Override
    public void publishInDbTranscation(Object message) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"partitionPublisher do not support publishInDbTranscation"});
    }

    @Override
    public void publishDelayInDbTranscation(Object message, int seconds) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"partitionPublisher do not support publishDelayInDbTranscation"});
    }

    @Override
    public void publishInDbTranscation(String routKey, Object message, String partitionKey) {
        if (!StringUtils.isNotEmpty((String)partitionKey)) {
            throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
        }
        PartitionHandlerFactory.get(this.partitionStrategy).prePublish(this.region, this.queueName, partitionKey);
        this.getRealPublisher(this.region, this.queueName, partitionKey).publishInDbTranscation(routKey, message);
    }

    @Override
    public void publishDelay(Object message, int seconds) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
    }

    @Override
    public void publishDelay(Object message, int seconds, String partitionKey) {
        if (!StringUtils.isNotEmpty((String)partitionKey)) {
            throw new KDException(BosErrorCode.partitionMqException, new Object[]{"Partition key required."});
        }
        PartitionHandlerFactory.get(this.partitionStrategy).prePublish(this.region, this.queueName, partitionKey);
        this.getRealPublisher(this.region, this.queueName, partitionKey).publishDelay(message, seconds);
    }

    @Override
    public void $$publishConfirm(byte[] message) {
        throw new KDException(BosErrorCode.partitionMqException, new Object[]{"partitionPublisher do not support _publishConfirm "});
    }

    @Override
    public void close() {
        Exception exception = null;
        for (MessagePublisher publisher : this.publishers.values()) {
            try {
                publisher.close();
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            throw new KDException(BosErrorCode.partitionMqException, "close error ", exception);
        }
    }
}

