/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.mq.support.partition;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.framework.instance.ClusterInstances;
import kd.bos.instance.Instance;
import kd.bos.mq.support.partition.QueueMetaManager;
import kd.bos.util.CoreConstants;
import kd.bos.util.NetAddressUtils;
import kd.bos.zk.ZKFactory;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.jline.utils.Log;

public class ZKQueueManager {
    private static CuratorFramework monitorZkClient;
    public static final String SPLIT_KEY = "@#";
    private static Set<String> metaCache;
    public static final Set<String> registryConsumerFailCache;
    private static Set<String> savedQueueMetaCache;

    private ZKQueueManager() {
    }

    public static List<JSONObject> allNodes() {
        String monitorRootPath = CoreConstants.MONITORROOTPATH;
        try {
            Map nodesMap = ClusterInstances.getAllOriginNodesString();
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(nodesMap.size());
            nodesMap.forEach((k, v) -> {
                JSONObject nodeInfo = JSON.parseObject((String)v);
                jsonObjectList.add(nodeInfo);
            });
            return jsonObjectList;
        }
        catch (Exception var7) {
            throw new KDException(BosErrorCode.mqException, "getAllNodeInfo fail, node:" + monitorRootPath + ", cause: " + var7.getMessage(), (Throwable)var7);
        }
    }

    public static boolean existMqConsumer(String ip, String realQueueName) {
        ZKQueueManager.initZKClient();
        try {
            Stat exists = (Stat)monitorZkClient.checkExists().forPath(ZKQueueManager.getMqConsumerNodePath(ip, realQueueName));
            if (exists == null) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.zkMqMeta, "checkExists node fail:", (Throwable)e);
        }
        return true;
    }

    public static boolean existMqConsumer(String realQueueName) {
        ZKQueueManager.initZKClient();
        try {
            List consumers = (List)monitorZkClient.getChildren().forPath(ZKQueueManager.getMqConsumerRootPath());
            for (String consumer : consumers) {
                if (!consumer.endsWith(realQueueName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            Log.warn((Object[])new Object[]{"existMqConsumer {} fail", realQueueName, e});
        }
        return false;
    }

    public static boolean existMqConsumer(String realQueueName, boolean selfIp) {
        if (selfIp) {
            String ip = NetAddressUtils.getLocalIpAddress();
            return ZKQueueManager.existMqConsumer(ip, realQueueName);
        }
        return ZKQueueManager.existMqConsumer(realQueueName);
    }

    public static void registDynamicMqConsumer(boolean isPartition, String realQueueName) {
        if (isPartition) {
            ZKQueueManager.initZKClient();
            try {
                String ip = NetAddressUtils.getLocalIpAddress();
                String nodePath = ZKQueueManager.getMqConsumerNodePath(ip, realQueueName);
                Stat stat = (Stat)monitorZkClient.checkExists().forPath(nodePath);
                if (stat == null) {
                    ((ACLBackgroundPathAndBytesable)monitorZkClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(nodePath, Instance.getInstanceId().getBytes());
                }
            }
            catch (Exception e) {
                registryConsumerFailCache.add(realQueueName);
                throw new KDException(BosErrorCode.zkMqMeta, "registDynamicMqConsumer create node fail:", (Throwable)e);
            }
            registryConsumerFailCache.remove(realQueueName);
        }
    }

    public static void saveMqQueueMeta(String region, String queueName, String appId, String queueRealNameNew) {
        try {
            String node = region + SPLIT_KEY + queueName + SPLIT_KEY + appId;
            if (!metaCache.contains(node)) {
                QueueMetaManager.persistenceQueueMeta(node);
                metaCache.add(node);
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.zkMqMeta, "saveMqQueueMeta fail:", (Throwable)e);
        }
    }

    public static List<String> loadDynamicMqMeta() {
        ArrayList<String> childes = new ArrayList<String>();
        try {
            Object rs = QueueMetaManager.getQueueMeta("");
            if (rs instanceof List) {
                List queueMetas = (List)rs;
                for (Object queueMeta : queueMetas) {
                    childes.add((String)queueMeta);
                }
            }
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.zkMqMeta, "loadDynamicMqMeta fail:", (Throwable)e);
        }
        return childes;
    }

    public static boolean existQueueMeta(String region, String queueName, String appId) {
        String node = region + SPLIT_KEY + queueName + SPLIT_KEY + appId;
        return ZKQueueManager.existQueueMeta(node);
    }

    public static boolean existQueueMeta(String node) {
        if (!savedQueueMetaCache.contains(node)) {
            List<String> childes = ZKQueueManager.loadDynamicMqMeta();
            for (String child : childes) {
                if (!node.equals(child)) continue;
                savedQueueMetaCache.add(node);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static String getMqConsumerNodePath(String ip, String readQueueName) {
        String mqConsumerRootPath = ZKQueueManager.getMqConsumerRootPath();
        return mqConsumerRootPath + "/" + ip + "#" + readQueueName;
    }

    private static String getMqConsumerRootPath() {
        String hosts = System.getProperty("configUrl");
        return ZKFactory.getZkRootPath((String)hosts) + Instance.getClusterName() + "/runtime/mqtx/consumers";
    }

    private static void initZKClient() {
        if (monitorZkClient == null) {
            String monitorZkAddress = System.getProperty("configUrl");
            monitorZkClient = ZKFactory.getZKClient((String)monitorZkAddress);
        }
    }

    static {
        metaCache = new HashSet<String>();
        registryConsumerFailCache = new HashSet<String>();
        savedQueueMetaCache = new HashSet<String>();
    }
}

