/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.config;

import java.util.ArrayList;
import java.util.List;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.service.DtxBranchDispatchService;
import kd.bos.kdtx.common.service.DtxTxDispatchService;

public class MServiceRegisterConfig {
    private String interfaceName;
    private String clazz;
    private String serviceTimeout;
    private String serviceRetries;
    private List<MethodConfig> consumerRefMethods;
    private String appId;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceTimeout() {
        return this.serviceTimeout;
    }

    public void setServiceTimeout(String serviceTimeout) {
        this.serviceTimeout = serviceTimeout;
    }

    public String getServiceRetries() {
        return this.serviceRetries;
    }

    public void setServiceRetries(String serviceRetries) {
        this.serviceRetries = serviceRetries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.interfaceName != null) {
            sb.append("interface=").append(this.interfaceName).append("\n");
            if (this.clazz != null) {
                sb.append("class=").append(this.clazz).append("\n");
            }
            if (this.serviceTimeout != null) {
                sb.append("timeout=").append(this.serviceTimeout).append("\n");
            }
            if (this.serviceRetries != null) {
                sb.append("retries=").append(this.serviceRetries).append("\n");
            }
            if (this.appId != null) {
                sb.append("appIds").append("=").append(this.appId).append("\n");
            }
            if (this.consumerRefMethods != null && !this.consumerRefMethods.isEmpty()) {
                sb.append("methods=[");
                for (MethodConfig methodConfig : this.consumerRefMethods) {
                    String methodName = methodConfig.getMethodName();
                    if (methodName == null) continue;
                    sb.append("name=").append(methodName).append("\\n");
                    long methodTimeout = methodConfig.getTimeout();
                    long methodRetries = methodConfig.getRetries();
                    if (methodTimeout != 0L) {
                        sb.append("timeout=").append(methodTimeout).append("\\n");
                    }
                    if (methodRetries != 0L) {
                        sb.append("retries=").append(methodRetries).append("\\n");
                    }
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append("]");
            }
        }
        return sb.toString();
    }

    private MServiceRegisterConfig(String interfaceName, List<MethodConfig> methodConfigs) {
        this.interfaceName = interfaceName;
        this.consumerRefMethods = methodConfigs;
    }

    private MServiceRegisterConfig(String interfaceName, String clazz) {
        this.interfaceName = interfaceName;
        this.clazz = clazz;
    }

    public static MServiceRegisterConfig getMServiceServiceConfig(String interfaceName, String clazzName) {
        return new MServiceRegisterConfig(interfaceName, clazzName);
    }

    public static MServiceRegisterConfig getTCCTxDispatchServiceConsumerConfig() {
        ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>(4);
        MethodConfig txBeginMethodConfig = new MethodConfig("begin", DtxConfig.getTxBeginTimeout(), DtxConfig.getTxBeginRetries());
        methodConfigs.add(txBeginMethodConfig);
        MethodConfig txCommitMethodConfig = new MethodConfig("commit", DtxConfig.getTxCommitTimeout(), DtxConfig.getTxCommitRetries());
        methodConfigs.add(txCommitMethodConfig);
        MethodConfig txRollbackMethodConfig = new MethodConfig("rollback", DtxConfig.getTxRollbackTimeout(), DtxConfig.getTxRollbackRetries());
        methodConfigs.add(txRollbackMethodConfig);
        MethodConfig branchRegisterMethodConfig = new MethodConfig("branchRegister", DtxConfig.getBranchRegisterTimeout(), DtxConfig.getBranchRegisterRetries());
        methodConfigs.add(branchRegisterMethodConfig);
        return new MServiceRegisterConfig(DtxTxDispatchService.class.getName(), methodConfigs);
    }

    public static MServiceRegisterConfig getTCCBranchDispatchServiceConsumerConfig() {
        ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>(3);
        MethodConfig branchPrepareMethodConfig = new MethodConfig("prepare", DtxConfig.getBranchPrepareTimeout(), DtxConfig.getBranchPrepareRetries());
        methodConfigs.add(branchPrepareMethodConfig);
        MethodConfig branchCommitMethodConfig = new MethodConfig("commit", DtxConfig.getBranchCommitTimeout(), DtxConfig.getBranchCommitRetries());
        methodConfigs.add(branchCommitMethodConfig);
        MethodConfig branchRollbackMethodConfig = new MethodConfig("rollback", DtxConfig.getBranchRollbackTimeout(), DtxConfig.getBranchRollbackRetries());
        methodConfigs.add(branchRollbackMethodConfig);
        return new MServiceRegisterConfig(DtxBranchDispatchService.class.getName(), methodConfigs);
    }

    public static class MethodConfig {
        private String methodName;
        private long timeout;
        private long retries;

        public MethodConfig(String methodName, long timeout, long retries) {
            this.methodName = methodName;
            this.timeout = timeout;
            this.retries = retries;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public long getRetries() {
            return this.retries;
        }

        public void setRetries(int retries) {
            this.retries = retries;
        }
    }
}

