/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.constant;

import java.util.HashMap;
import java.util.Map;
import kd.bos.kdtx.common.constant.Status;

public enum BranchStatus implements Status
{
    PREPARING(1, "Preparing"),
    COMMITTING(2, "Committing"),
    ROLLBACKING(3, "RollBacking"),
    COMMITTED(4, "Committed"),
    ROLLBACKED(5, "RollBacked"),
    ROLLBACK_FAILED(6, "RollbackFailed"),
    COMMIT_FAILED(7, "CommitFailed"),
    DISCARD(8, "Discard");

    private int code;
    private String name;
    private static final Map<Integer, BranchStatus> MAP;

    private BranchStatus(int code, String name) {
        this.code = code;
        this.name = name;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static BranchStatus get(int code) {
        BranchStatus status = MAP.get(code);
        if (status == null) {
            throw new IllegalArgumentException("Unknown ServiceStatus[" + code + "]");
        }
        return status;
    }

    static {
        MAP = new HashMap<Integer, BranchStatus>(BranchStatus.values().length);
        for (BranchStatus status : BranchStatus.values()) {
            MAP.put(status.code, status);
        }
    }
}

