/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.context;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.entity.TxSceneInfo;
import kd.bos.util.StringUtils;

public class DtxContext {
    private static ThreadLocal<Map<String, Object>> threadLocal = ThreadLocal.withInitial(HashMap::new);
    private static final String TX_CODE = "tx_code";
    private static final String TX_TYPE = "tx_type";
    private static final String BRANCH_CODE = "branch_code";
    private static final String BUSINESS_TYPE = "business_type";
    private static final String BUSINESS_IDS = "business_ids";
    private static final String ASYNC_COMMIT = "asyncCommit";
    private static final String ASYNC_ROLLBACK = "asyncRollback";
    private static final String RUN_MQ_MODEL = "runMqModel";
    private static final String DB_ROUTE = "db_route";

    public static String getBusinessType() {
        return (String)threadLocal.get().get(BUSINESS_TYPE);
    }

    public static List<String> getBusinessIds() {
        return (List)threadLocal.get().get(BUSINESS_IDS);
    }

    public static void setBusinessType(String businessType) {
        threadLocal.get().put(BUSINESS_TYPE, businessType);
    }

    public static void setBusinessIds(List<String> businessIds) {
        threadLocal.get().put(BUSINESS_IDS, businessIds);
    }

    public static String getTxCode() {
        return (String)threadLocal.get().get(TX_CODE);
    }

    public static void setTxCode(String code) {
        threadLocal.get().put(TX_CODE, code);
    }

    public static String getTxType() {
        return (String)threadLocal.get().get(TX_TYPE);
    }

    public static void setTxType(String code) {
        threadLocal.get().put(TX_TYPE, code);
    }

    public static String getBranchCode() {
        return (String)threadLocal.get().get(BRANCH_CODE);
    }

    public static void setBranchCode(String code) {
        threadLocal.get().put(BRANCH_CODE, code);
    }

    public static void setAsyncCommit(boolean asyncCommit) {
        threadLocal.get().put(ASYNC_COMMIT, asyncCommit);
    }

    public static boolean getAsyncCommit() {
        Object value = threadLocal.get().get(ASYNC_COMMIT);
        return value != null ? (Boolean)value : false;
    }

    public static void setAsyncRollback(boolean asyncRollback) {
        threadLocal.get().put(ASYNC_ROLLBACK, asyncRollback);
    }

    public static boolean getAsyncRollback() {
        Object value = threadLocal.get().get(ASYNC_ROLLBACK);
        return value != null ? (Boolean)value : false;
    }

    public static void setRunMqModel(boolean runMqModel) {
        threadLocal.get().put(RUN_MQ_MODEL, runMqModel);
    }

    public static boolean getRunMqModel() {
        Object value = threadLocal.get().get(RUN_MQ_MODEL);
        return value != null ? (Boolean)value : false;
    }

    public static String getDbRoute() {
        return (String)threadLocal.get().get(DB_ROUTE);
    }

    public static void setDbRoute(String dbRoute) {
        threadLocal.get().put(DB_ROUTE, dbRoute);
    }

    public static void remove() {
        threadLocal.remove();
    }

    public static boolean isSetBusinessType() {
        String businessType = DtxContext.getBusinessType();
        if (StringUtils.isNotEmpty((String)businessType)) {
            return true;
        }
        Object[] queryParams = new Object[]{DtxContext.getTxCode()};
        TxSceneInfo txSceneInfo = (TxSceneInfo)DB.query((DBRoute)DBRoute.base, (String)"SELECT fid,fbusiness_type FROM t_cbs_dtx_tx_scenes WHERE fcode = ?", (Object[])queryParams, rs -> {
            TxSceneInfo info = new TxSceneInfo();
            if (rs.next()) {
                info.setId(rs.getString("fid"));
                info.setBusinessType(rs.getString("fbusiness_type"));
            }
            return info;
        });
        return StringUtils.isNotEmpty((String)txSceneInfo.getBusinessType());
    }
}

