/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.exception;

import java.io.Serializable;

public enum DtxErrorCodeConstants implements Serializable
{
    TXCODE_EMPTY("bos.kdtx.txcode.empty", "tx code empty"),
    TXCODE_ERROR("bos.kdtx.txcode.error", "tx code [%s] not found"),
    TXTYPE_EMPTY("bos.kdtx.txtype.empty", "tx type empty"),
    NEST_DTX_ERROR("bos.kdtx.nested.notsupport", "not support nested dtx"),
    XID_EMPTY("bos.kdtx.xid.empty", "xid is empty"),
    XID_NOT_EXISTS("bos.kdtx.xid.notexists", "xid not exists"),
    RETRY_XID_EMPTY("bos.kdtx.xid.retry.empty", "xid should be assigned while retry"),
    BRANCHID_EMPTY("bos.kdtx.branchid.empty", "branchid is empty"),
    LOCAL_TX_EMPTY("bos.kdtx.localtx.empty", "local tx empty,please open a local tx!"),
    DB_ROUTE_EMPTY("bos.kdtx.dbrout.empty", "dbroute empty"),
    DTX_EXIST_ERROR("bos.kdtx.dtcontext.error", "dtxcontext exists error"),
    SESSION_EMPTY("bos.kdtx.session.empty", "current dtxcontext not exists session"),
    CLOUDID_OR_APPID_EMPTY("bos.kdtx.cloudidorappid.empty", "appid or cloudid empty"),
    UNKNOW_ERROR("bos.kdtx.unknow.error", "unknow error"),
    DTX_NEST_LEVEL_TOO_MUCH("bos.kdtx.nest.level.too.much", "kdtx nest level is too much"),
    NOT_SUPPORT_NEST_TCC("TCC-NEST", "tcc nesting is not supported"),
    BRANCH_ID_NOT_MATCH_TRANSACTION("BRANCH-ID-ERROR", "The corresponding transaction cannot be found by the branch id"),
    QUEUE_NOT_CONFIGURED_ERROR("kdtx.mqConfiguration", "scene queue not configured"),
    DTX_NOT_BEGIN("kdtx.notbegin", "register error,you not begin tx"),
    DTX_NOT_REPEAT_BEGIN("kdtx.notrepeatbegin", "the transaction is not committed. can not calling begin"),
    CASCADE_REGISTER_ERROR("bos.kdtx.cascade.register.error", "cascade register error"),
    INVOKE_CASCADE_XID_EMPTY("bos.kdtx.cascade.xid.empty", "invoke cascade xid empty"),
    INVOKE_CASCADE_CLOUDID_EMPTY("bos.kdtx.cascade.cloudid.empty", "invoke cascade cloudid empty"),
    INVOKE_CASCADE_APPID_EMPTY("bos.kdtx.cascade.appid.empty", "invoke cascade appid empty"),
    INVOKE_CASCADE_PARENTBRANCHID_EMPTY("bos.kdtx.cascade.parentbranchid.empty", "invoke cascade parentbranchid empty"),
    INVOKE_CASCADE_SERVICENAME_EMPTY("bos.kdtx.cascade.servicename.empty", "invoke cascade servicename empty"),
    INVOKE_CASCADE_CASCADESEQ_START_ERROR("bos.kdtx.cascade.cascadeseq.start.error", "cascadeseq must start from 1"),
    INVOKE_CASCADE_CASCADESEQ_SAME_ERROR("bos.kdtx.cascade.cascadeseq.same.error", "the current parent branch has the same cascade seq"),
    INVOKE_CASCADE_CASCADESEQ_LESS_ERROR("bos.kdtx.cascade.cascadeseq.less.error", "the cascade seq is Illegal,it must greater than the max seq of the current parent branch"),
    INVOKE_CASCADE_LEVEL_ERROR("bos.kdtx.cascade.level.error", "the cascade level must equal or less than the value of the parameter 'kdtx.branchRegister.cascade.level'"),
    MAX_PARAM_SIZE("bos.kdtx.maxpamrasize.error", "the param's size bigger than the max size");

    private String errorCode;
    private String errorMessage;

    private DtxErrorCodeConstants(String errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static DtxErrorCodeConstants valueOfCode(String errorCode) {
        DtxErrorCodeConstants[] values;
        for (DtxErrorCodeConstants value : values = DtxErrorCodeConstants.values()) {
            if (!value.getErrorCode().equals(errorCode)) continue;
            return value;
        }
        return null;
    }
}

