/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.idemponent.storage;

import java.sql.ResultSet;
import java.util.Date;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.idemponent.pojo.RpcIdempotentProcess;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageService;

public class IdempotentDbStorageImpl
implements IdempotentStorageService {
    private static final Long RENEWAL_INTERVAL = 60000L;

    @Override
    public void save(DBRoute dbRoute, RpcIdempotentProcess rpcIdempotentProcess) {
        try {
            String sql = "insert into t_idem_rpcidempotentprocess(fidempotentkey,fcreatedtime,frenewalinstance,frenewaltime,falivedtime,fexecutestatus) values (?, ?, ?, ?, ?, ?)";
            String idempotentKey = rpcIdempotentProcess.getIdempotentKey();
            Date createdTime = rpcIdempotentProcess.getCreatedTime();
            String renewalInstance = rpcIdempotentProcess.getRenewalInstance();
            Long renewalTime = rpcIdempotentProcess.getRenewalTime();
            Long alivedTime = rpcIdempotentProcess.getAliveTime();
            String executeStatus = rpcIdempotentProcess.getExecuteStatus();
            Object[] param = new Object[]{idempotentKey, createdTime, renewalInstance, renewalTime, alivedTime, executeStatus};
            try (TXHandle tx = TX.notSupported();){
                DB.execute((DBRoute)dbRoute, (String)sql, (Object[])param);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RpcIdempotentProcess get(DBRoute dbRoute, String idempotentKey) {
        String sql = "select fidempotentkey,fexecutestatus,frenewaltime,falivedtime from t_idem_rpcidempotentprocess where fidempotentkey = ?";
        return (RpcIdempotentProcess)DB.query((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{idempotentKey}, (ResultSetHandler)new ResultSetHandler<RpcIdempotentProcess>(){

            public RpcIdempotentProcess handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    RpcIdempotentProcess rpcIdempotentProcess = new RpcIdempotentProcess();
                    rpcIdempotentProcess.setIdempotentKey(resultSet.getString("fidempotentkey"));
                    rpcIdempotentProcess.setExecuteStatus(resultSet.getString("fexecutestatus"));
                    rpcIdempotentProcess.setRenewalTime(resultSet.getLong("frenewaltime"));
                    rpcIdempotentProcess.setAliveTime(resultSet.getLong("falivedtime"));
                    return rpcIdempotentProcess;
                }
                return null;
            }
        });
    }

    @Override
    public void renewal(DBRoute dbRoute, String renewalInstance) {
        String sql = "update t_idem_rpcidempotentprocess SET frenewaltime = frenewaltime + ? WHERE frenewalinstance = ? AND fexecutestatus = '0' AND frenewaltime + falivedtime > ?";
        try (TXHandle h = TX.notSupported();){
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{RENEWAL_INTERVAL, renewalInstance, System.currentTimeMillis()});
        }
    }

    @Override
    public String copySuccessResult(DBRoute dbRoute, String idempotentKey) {
        String sql = "select fresult from t_idem_rpcidempotentprocess where fidempotentkey = ? and fexecutestatus = '1'";
        return (String)DB.query((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{idempotentKey}, resultSet -> {
            if (resultSet.next()) {
                return resultSet.getString("fresult");
            }
            return "";
        });
    }

    @Override
    public void executeCompleted(DBRoute dbRoute, String idempotentKey, String result) {
        String sql = "update t_idem_rpcidempotentprocess set fresult = ?, fexecutestatus = ?, frenewaltime = ? where fidempotentkey = ?";
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{result, "1", System.currentTimeMillis(), idempotentKey});
        }
    }

    @Override
    public void executeException(DBRoute dbRoute, String idempotentKey) {
        String sql = "update t_idem_rpcidempotentprocess set fexecutestatus = ?, frenewaltime = ? where fidempotentkey = ?";
        try (TXHandle h = TX.notSupported();){
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{"2", System.currentTimeMillis(), idempotentKey});
        }
    }

    @Override
    public void cleanHistory(DBRoute dbRoute) {
        String sql = "delete from t_idem_rpcidempotentprocess where frenewaltime + falivedtime < ?";
        try (TXHandle h = TX.notSupported();){
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{System.currentTimeMillis()});
        }
    }

    @Override
    public void deleteIdem(DBRoute dbRoute, String idempotentKey) {
        String sql = "delete from t_idem_rpcidempotentprocess where fidempotentkey = ?";
        try (TXHandle h = TX.notSupported();){
            DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{idempotentKey});
        }
    }
}

