/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.idemponent.task;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.kdtx.common.idemponent.pojo.IdempotentNamespace;
import kd.bos.kdtx.common.idemponent.properties.ConcurrentPolicyEnum;
import kd.bos.kdtx.common.idemponent.properties.IdempotentProperties;
import kd.bos.kdtx.common.idemponent.properties.StorageStrategyEnum;
import kd.bos.kdtx.common.idemponent.service.IdempotentService;
import kd.bos.kdtx.common.idemponent.storage.IdempotentStorageHelper;
import kd.bos.kdtx.common.idemponent.utils.IdempotentNamespacePool;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class IdempotentStorageCleanTask
implements IdempotentService,
Runnable {
    private static final Log logger = LogFactory.getLog(IdempotentStorageCleanTask.class);
    private volatile Map<String, DBRoute> dbRouteMap = new HashMap<String, DBRoute>();
    private static int CLEAN_HISTORY_TIME = 60;

    private IdempotentStorageCleanTask() {
    }

    public static IdempotentStorageCleanTask getInstance() {
        return IdempotentStorageCleanTaskSingle.INSTANCE;
    }

    @Override
    public IdempotentProperties getIdempotentProperties(Object param, Object lastParam) {
        String dbRoute = (String)param;
        IdempotentProperties idempotentProperties = new IdempotentProperties();
        idempotentProperties.setAlivedTime(3600000L);
        String timeKey = this.getTimeKey();
        idempotentProperties.setIdempotentKey("IdempotentStorageCleanTask" + dbRoute + timeKey);
        idempotentProperties.setStorageStrategy(StorageStrategyEnum.REDIS);
        idempotentProperties.setConcurrentPolicy(ConcurrentPolicyEnum.QUICK_RETURN);
        idempotentProperties.setDbRoute(DBRoute.of((String)dbRoute));
        return idempotentProperties;
    }

    private String getTimeKey() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHH");
        return simpleDateFormat.format(date);
    }

    @Override
    public void run() {
        while (true) {
            try {
                TimeUnit.MINUTES.sleep(CLEAN_HISTORY_TIME);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            try {
                this.clean();
                continue;
            }
            catch (Exception e) {
                logger.error("\u5b9a\u65f6\u6e05\u7406\u5e42\u7b49\u8bb0\u5f55\u5f02\u5e38:", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void clean() {
        Map<String, IdempotentNamespace> namespaceMap = IdempotentNamespacePool.getAll();
        for (Map.Entry<String, IdempotentNamespace> namespaceEntry : namespaceMap.entrySet()) {
            String key = namespaceEntry.getKey();
            IdempotentNamespace namespace = namespaceEntry.getValue();
            String[] tenantIdAccountId = key.split("#");
            RequestContext rc = RequestContext.create();
            rc.setTenantId(tenantIdAccountId[0]);
            rc.setAccountId(tenantIdAccountId[1]);
            RequestContext.copyAndSet((RequestContext)rc);
            Set<String> dbRoutes = namespace.getDbRoutes();
            this.cleanHistoryByDBRoute(dbRoutes);
        }
    }

    private void cleanHistoryByDBRoute(Set<String> dbRoutes) {
        RequestContext rc = RequestContext.get();
        for (String dbRouteKey : dbRoutes) {
            DBRoute dbRoute = this.dbRouteMap.get(dbRouteKey);
            if (dbRoute == null) {
                dbRoute = DBRoute.of((String)dbRouteKey);
                this.dbRouteMap.put(dbRouteKey, dbRoute);
            }
            try {
                this.cleanHistory(dbRoute);
            }
            catch (Exception e) {
                logger.error("\u6e05\u7406\u5f02\u5e38,\u79df\u6237:" + rc.getTenantId() + " \u6570\u636e\u4e2d\u5fc3:" + rc.getAccountId(), (Throwable)e);
            }
        }
    }

    private void cleanHistory(DBRoute dbRoute) {
        try {
            IdempotentStorageHelper.cleanHistory(dbRoute);
        }
        catch (Exception e) {
            logger.error("\u6e05\u7406\u5e42\u7b49\u8bb0\u5f55\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
        }
    }

    private static class IdempotentStorageCleanTaskSingle {
        private static final IdempotentStorageCleanTask INSTANCE = new IdempotentStorageCleanTask();

        private IdempotentStorageCleanTaskSingle() {
        }
    }
}

