/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.invoke;

import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.InvokeType;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.dto.BranchInvokerParam;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.NoRetryException;
import kd.bos.kdtx.common.exception.invoke.ServiceLookUpException;
import kd.bos.kdtx.common.invoke.DtxInvoker;
import kd.bos.kdtx.common.invoke.RPCLocalDebug;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.util.JSONUtils;
import kd.bos.util.StringUtils;

public class BranchInvoker
extends DtxInvoker {
    private static DispatchService branchDispatchServiceImpl;

    public BranchInvoker(InvokeType invokerType, long retryTimes) {
        this.assertBranchInvokeType(invokerType);
        this.invokeType = invokerType;
        this.retryTimes = retryTimes;
    }

    @Override
    public Object doInvoke(DtxParas dtxParas) throws Exception {
        this.assertTCCParasNull(dtxParas);
        long retry = this.retryTimes;
        String cloudId = dtxParas.getCloudId();
        String appId = dtxParas.getAppId();
        String resource = dtxParas.getResource();
        BranchInvokerParam branchInvokerParam = BranchInvoker.assembleBranchTransferParam(dtxParas);
        Exception cause = null;
        Object result = null;
        while (true) {
            try {
                DispatchService dtxBranchDispatchService = BranchInvoker.branchServiceLookup(appId);
                String factory = StringUtils.isEmpty((String)cloudId) && StringUtils.isEmpty((String)appId) ? "kd.bos.service.ServiceFactory" : String.format("kd.%s.%s.servicehelper.ServiceFactory", cloudId, appId);
                switch (this.invokeType) {
                    case PREPARE: {
                        result = dtxBranchDispatchService.invoke("kd.bos.kdtx.sdk.service.ServiceFactory", "branchDispatch", "prepare", new Object[]{factory, resource, new Object[]{branchInvokerParam}});
                        break;
                    }
                    case BRANCH_COMMIT: {
                        result = dtxBranchDispatchService.invoke("kd.bos.kdtx.sdk.service.ServiceFactory", "branchDispatch", "commit", new Object[]{factory, resource, new Object[]{branchInvokerParam}});
                        break;
                    }
                    case BRANCH_ROLLBACK: {
                        result = dtxBranchDispatchService.invoke("kd.bos.kdtx.sdk.service.ServiceFactory", "branchDispatch", "rollback", new Object[]{factory, resource, new Object[]{branchInvokerParam}});
                        break;
                    }
                }
                cause = null;
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause() instanceof NoRetryException) {
                    ExceptionLogger.error(BranchInvoker.class, "KdtxMonitorLog branch invoke TCCNoRetryException", e);
                    throw new KdtxException(cause);
                }
                ExceptionLogger.error(BranchInvoker.class, "KdtxMonitorLog invoke " + (Object)((Object)this.invokeType) + " exception -- exception message: " + e.getMessage() + " tccParas" + JSONUtils.toString((Object)dtxParas) + " xid: " + KdtxRequestContext.get().getXid() + " ready to retry..", e);
                cause = e;
                if ((retry = this.retryCountDown(retry)) >= 0L) continue;
            }
            break;
        }
        if (cause != null) {
            ExceptionLogger.error(BranchInvoker.class, "KdtxMonitorLog branch invoke " + (Object)((Object)this.invokeType) + " retry ran out", cause);
            throw new KdtxException(cause);
        }
        return result;
    }

    private static DispatchService branchServiceLookup(String appId) {
        DispatchService service = null;
        if (DtxConfig.canRunMqMode(DtxContext.getRunMqModel())) {
            try {
                if (branchDispatchServiceImpl == null) {
                    branchDispatchServiceImpl = (DispatchService)Class.forName("kd.bos.service.DispatchServiceImpl").newInstance();
                }
                service = RPCLocalDebug.debugProxy(DispatchService.class, branchDispatchServiceImpl);
            }
            catch (Exception e) {
                throw new ServiceLookUpException("TxInvoker lookup DtxBranchDispatchService impl fail:", e);
            }
        } else {
            String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
            service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)serviceAppId);
        }
        return service;
    }

    public static BranchInvokerParam assembleBranchTransferParam(DtxParas dtxParas) {
        BranchInvokerParam branchInvokerParam = new BranchInvokerParam();
        branchInvokerParam.setAttachment(dtxParas.getAttachment());
        branchInvokerParam.setParamType(dtxParas.getParamType());
        branchInvokerParam.setParamStr(dtxParas.getParam());
        branchInvokerParam.setParasBytes(dtxParas.getParasBytes());
        branchInvokerParam.setLastReturn(dtxParas.getLastReturn());
        return branchInvokerParam;
    }

    private void assertBranchInvokeType(InvokeType invokeType) {
        if (!InvokeType.isBranchType(invokeType)) {
            throw new KdtxException("invoke type invalid tccInvokerType: " + (Object)((Object)this.invokeType));
        }
    }

    private void assertTCCParasNull(DtxParas dtxParas) {
        if (dtxParas == null) {
            throw new KdtxException("tccParas can not be null !");
        }
    }
}

