/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.invoke;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.KdtxRequestContext;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.config.DtxConfig;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.constant.InvokeType;
import kd.bos.kdtx.common.context.DtxContext;
import kd.bos.kdtx.common.dto.TxInvokerAttachment;
import kd.bos.kdtx.common.entity.CallbackInfo;
import kd.bos.kdtx.common.entity.TxBusinessInfo;
import kd.bos.kdtx.common.exception.BranchRegisterException;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.kdtx.common.exception.KdtxException;
import kd.bos.kdtx.common.exception.TxBeginException;
import kd.bos.kdtx.common.exception.TxCommitFailException;
import kd.bos.kdtx.common.exception.TxRollbackFailException;
import kd.bos.kdtx.common.exception.invoke.ServiceLookUpException;
import kd.bos.kdtx.common.invoke.DtxInvoker;
import kd.bos.kdtx.common.invoke.RPCLocalDebug;
import kd.bos.kdtx.common.param.BranchActionParam;
import kd.bos.kdtx.common.service.DtxTxDispatchService;
import kd.bos.kdtx.common.util.JsonUtils;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.util.JSONUtils;

public class TxInvoker
extends DtxInvoker {
    private static DtxTxDispatchService dtxTxDispatchServiceImpl;
    private static boolean clientRegistered;
    public static final Map<String, CallbackInfo> callbackCache;

    public TxInvoker(InvokeType invokeType, long retryTimes) {
        this.assertTxInvokeType(invokeType);
        this.invokeType = invokeType;
        this.retryTimes = retryTimes;
    }

    @Override
    public Object doInvoke(DtxParas dtxParas) throws Exception {
        this.assertTCCParasNull(dtxParas);
        long retry = this.retryTimes;
        Exception cause = null;
        while (true) {
            try {
                DtxTxDispatchService dtxTxDispatchService = TxInvoker.serviceLookup(AppInfo.APP_ID.getName());
                BranchActionParam param = new BranchActionParam();
                switch (this.invokeType) {
                    case TX_BEGIN: {
                        TxBusinessInfo info = new TxBusinessInfo(DtxContext.getBusinessIds(), DtxContext.getBusinessType());
                        String dbRoute = DtxContext.getDbRoute() == null ? "" : DtxContext.getDbRoute();
                        dtxTxDispatchService.begin(DtxContext.getTxCode(), DtxContext.getTxType(), info, DtxContext.getRunMqModel(), dbRoute);
                        break;
                    }
                    case SET_BUSINESS_INFO: {
                        TxBusinessInfo info = new TxBusinessInfo(DtxContext.getBusinessIds(), DtxContext.getBusinessType());
                        dtxTxDispatchService.setBusinessInfo(info);
                        break;
                    }
                    case BRANCH_REGISTER: {
                        param.setResource(dtxParas.getResource());
                        param.setTxCode(dtxParas.getSceneCode());
                        param.setBranchCode(dtxParas.getBranchCode());
                        param.setSeq(dtxParas.getSeq());
                        param.setBizId(dtxParas.getBizId());
                        param.setXid(dtxParas.getXid());
                        param.setParasBytes(dtxParas.getParasBytes());
                        dtxParas.setParasBytes(null);
                        param.setParas(JsonUtils.getParasStr(dtxParas));
                        dtxTxDispatchService.branchRegister(param);
                        break;
                    }
                    case CASCADE_BRANCH_REGISTER: {
                        param.setResource(dtxParas.getResource());
                        param.setParas(JsonUtils.getParasStr(dtxParas));
                        param.setTxCode(dtxParas.getSceneCode());
                        param.setBranchCode(dtxParas.getBranchCode());
                        param.setSeq(dtxParas.getSeq());
                        param.setBizId(dtxParas.getBizId());
                        param.setXid(dtxParas.getXid());
                        param.setParentBranchId(dtxParas.getParentBranchId());
                        param.setCascadeSeq(dtxParas.getCascadeSeq());
                        param.setParasBytes(dtxParas.getParasBytes());
                        dtxTxDispatchService.registerCascadeBranch(param);
                        break;
                    }
                    case BRANCH_REPORT: {
                        try {
                            param.setBranchPrepareRet(dtxParas.getPrepareRet());
                            param.setBranchPrepareException(dtxParas.getPrepareException());
                            dtxTxDispatchService.branchReport(param);
                        }
                        catch (Exception e) {
                            ExceptionLogger.warn(TxInvoker.class, "KdtxMonitorLog -- branch report fail! branchId:  " + KdtxRequestContext.get().getXid() + " param: " + JSONUtils.toString((Object)param));
                        }
                        break;
                    }
                    case TX_COMMIT: {
                        dtxTxDispatchService.commit(DtxContext.getAsyncCommit(), this.assembleAttachment());
                        break;
                    }
                    case TX_ROLLBACK: {
                        dtxTxDispatchService.rollback(DtxContext.getAsyncRollback(), this.assembleAttachment());
                        break;
                    }
                }
                cause = null;
            }
            catch (Exception e) {
                ExceptionLogger.error(TxInvoker.class, "KdtxMonitorLog invoke " + (Object)((Object)this.invokeType) + " exception -- exception message: " + e.getMessage() + " tccParas" + JSONUtils.toString((Object)dtxParas) + " xid: " + KdtxRequestContext.get().getXid() + " ready to retry..", e);
                if (e instanceof ServiceLookUpException) {
                    throw e;
                }
                if (e instanceof TxCommitFailException || e instanceof TxRollbackFailException || e.getCause() instanceof TxCommitFailException || e.getCause() instanceof TxRollbackFailException) {
                    return null;
                }
                if (e.getCause() instanceof TxBeginException || e instanceof TxBeginException) {
                    throw e;
                }
                if (e.getCause() instanceof BranchRegisterException) {
                    ExceptionLogger.error(TxInvoker.class, "KdtxMonitorLog tx Branch Register Exception.", e);
                    throw new KdtxException(e);
                }
                cause = e;
                if ((retry = this.retryCountDown(retry)) >= 0L) continue;
            }
            break;
        }
        if (cause != null) {
            throw new KdtxException(cause);
        }
        return null;
    }

    private static DtxTxDispatchService serviceLookup(String appId) {
        DtxTxDispatchService service = null;
        if (DtxConfig.canRunMqMode(DtxContext.getRunMqModel())) {
            try {
                if (dtxTxDispatchServiceImpl == null) {
                    dtxTxDispatchServiceImpl = (DtxTxDispatchService)Class.forName("kd.bos.kdtx.server.service.impl.TxDispatchServiceImpl").newInstance();
                }
                service = RPCLocalDebug.debugProxy(DtxTxDispatchService.class, dtxTxDispatchServiceImpl);
            }
            catch (Exception e) {
                throw new ServiceLookUpException("TxInvoker lookup DtxTxDispatchService impl fail:", e);
            }
        } else {
            String serviceAppId = ServiceLookup.getServiceAppId((String)appId);
            service = (DtxTxDispatchService)ServiceLookup.lookup(DtxTxDispatchService.class, (String)serviceAppId);
        }
        return service;
    }

    private void assertTxInvokeType(InvokeType invokeType) {
        if (!InvokeType.isTxType(invokeType)) {
            throw new KdtxException("invoke type invalid tccInvokeType: " + (Object)((Object)this.invokeType));
        }
    }

    private void assertTCCParasNull(DtxParas dtxParas) {
        if (InvokeType.BRANCH_REGISTER == this.invokeType && dtxParas == null) {
            throw new KdtxException("tccParas can not be null when register a branch!");
        }
    }

    private TxInvokerAttachment assembleAttachment() {
        TxInvokerAttachment txInvokerAttachment = new TxInvokerAttachment();
        txInvokerAttachment.setCallbackInfo(callbackCache.remove(KdtxRequestContext.get().getXid()));
        return txInvokerAttachment;
    }

    static {
        callbackCache = new HashMap<String, CallbackInfo>();
    }
}

