/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.localtx;

import java.sql.ResultSet;
import java.util.HashSet;
import java.util.TreeSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.kdtx.common.DtxParas;
import kd.bos.kdtx.common.constant.DtxType;
import kd.bos.kdtx.common.constant.LocalTxLogStatus;
import kd.bos.kdtx.common.localtx.LocalTxLog;

public class LocalTxDbHelper {
    public static TreeSet<LocalTxLog> getLocalTxLogList(DBRoute dbRoute, String xid, Long seq) {
        TreeSet ret = null;
        try (TXHandle h = TX.requiresNew();){
            String sql = "SELECT TOP 1000, 0 fid,fxid,fseq,fcloud_id,fapp_id,fresource,fpara_type,fparas,fcode,fbizid, fparas_bytes, fstatus FROM t_dtx_local_tx_log WHERE fxid = ? " + (seq == null ? "" : "and fseq=" + seq) + " ORDER BY fseq ASC";
            Object[] params = new Object[]{xid};
            ret = (TreeSet)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rs -> {
                TreeSet<LocalTxLog> localTxLogSet = new TreeSet<LocalTxLog>();
                while (rs.next()) {
                    LocalTxLog localTxLog = new LocalTxLog();
                    localTxLog.setFid(rs.getLong(1));
                    localTxLog.setXid(rs.getString(2));
                    localTxLog.setSeq(rs.getLong(3));
                    localTxLog.setCloudId(rs.getString(4));
                    localTxLog.setAppId(rs.getString(5));
                    localTxLog.setResource(rs.getString(6));
                    localTxLog.setParaType(rs.getString(7));
                    localTxLog.setParas(rs.getString(8));
                    localTxLog.setCode(rs.getString(9));
                    localTxLog.setBizId(rs.getString(10));
                    localTxLog.setParaBytes(rs.getBytes(11));
                    localTxLog.setStatus(rs.getInt(12));
                    localTxLogSet.add(localTxLog);
                }
                return localTxLogSet;
            });
        }
        return ret;
    }

    public static long localTxLogCount(DBRoute dbRoute, String xid) {
        String sql = "SELECT count(fid) FROM t_dtx_local_tx_log WHERE fxid = ? ";
        Object[] params = new Object[]{xid};
        long count = 0L;
        try (TXHandle h = TX.requiresNew();){
            count = (Long)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rs -> {
                if (rs.next()) {
                    return rs.getLong(1);
                }
                return 0L;
            });
        }
        return count;
    }

    public static void insert(DBRoute dbRoute, String xid, DtxParas dtxParas) {
        String seqSql = "SELECT CASE WHEN (COUNT(1) = 0) THEN 0 ELSE MAX(fseq) + 1 END FROM t_dtx_local_tx_log WHERE fxid = ?";
        Object[] seqParams = new Object[]{xid};
        long newSeq = (Long)DB.query((DBRoute)dbRoute, (String)seqSql, (Object[])seqParams, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        String sql = "INSERT INTO t_dtx_local_tx_log(fid,fxid,fseq,fcloud_id,fapp_id,fresource,fpara_type,fparas,fcode,fbizid, fcreate_time , fparas_bytes,fstatus) VALUES (?,?,?,?,?,?,?,?,?,?,now() ,?,?)";
        Object[] params = new Object[]{ID.genLongId(), xid, newSeq, dtxParas.getCloudId(), dtxParas.getAppId(), dtxParas.getResource(), dtxParas.getParamType(), dtxParas.getParam(), dtxParas.getBranchCode(), dtxParas.getBizId(), dtxParas.getParasBytes(), LocalTxLogStatus.UNPUBLISHED.getCode()};
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])params);
        if (newSeq == 0L) {
            LocalTxDbHelper.saveRouteKey(xid, dbRoute.getRouteKey());
        }
    }

    private static void saveRouteKey(String xid, String routekey) {
        try (TXHandle txHandle = TX.requiresNew();){
            String sql = "update t_cbs_dtx_transaction set froutekey=? where fxid=?";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{routekey, xid});
        }
    }

    public static void updateLocalBranchStatus(DBRoute dbRoute, String xid, long seq, LocalTxLogStatus status, LocalTxLogStatus oldStatus) {
        String sql = "UPDATE t_dtx_local_tx_log SET fstatus=? WHERE fxid=? and fseq=? and fstatus=?";
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{status.getCode(), xid, seq, oldStatus.getCode()});
    }

    public static void received(DBRoute dbRoute, String xid, long seq) {
        String sql = "UPDATE t_dtx_local_tx_log SET fstatus=? WHERE fxid=? and fseq=? and fstatus in (0,1)";
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{LocalTxLogStatus.RECEIVED.getCode(), xid, seq});
    }

    public static boolean isReceived(DBRoute dbRoute, String xid, long seq) {
        String sql = "select 1 from t_dtx_local_tx_log WHERE fxid=? and fseq=? and fstatus=?";
        return (Boolean)DB.query((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{xid, seq, LocalTxLogStatus.RECEIVED.getCode()}, ResultSet::next);
    }

    private static boolean isAllReceived(DBRoute dbRoute, String xid) {
        String sql = "select count(*) from t_dtx_local_tx_log where fxid=? and fstatus in (0,1)";
        return (Boolean)DB.query((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{xid}, rs -> {
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            return count == 0;
        });
    }

    public static void allReceived(DBRoute dbRoute, String xid) {
        if (dbRoute == null || LocalTxDbHelper.isAllReceived(dbRoute, xid)) {
            String sql = "UPDATE t_cbs_dtx_transaction SET fsecondstatus=? ,fupdate_time=NOW() WHERE fxid=? ";
            DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{LocalTxLogStatus.RECEIVED.getCode(), xid});
        }
    }

    public static HashSet<DtxParas> getDtxParas(DBRoute dbRoute, String xid, String scenesCode) {
        HashSet ret = null;
        try (TXHandle tx = TX.requiresNew();){
            String sql = "SELECT TOP 1000, 0 fresource, fcode, fseq, fbizid, fparas_bytes, fcloud_id, fapp_id, fpara_type, fparas FROM t_dtx_local_tx_log WHERE fxid = ? ORDER BY fseq ASC";
            Object[] params = new Object[]{xid};
            HashSet hashSet = ret = (HashSet)DB.query((DBRoute)dbRoute, (String)sql, (Object[])params, rs -> {
                HashSet<DtxParas> dtxParaSet = new HashSet<DtxParas>();
                while (rs.next()) {
                    DtxParas dtxParas = new DtxParas();
                    dtxParas.setResource(rs.getString(1));
                    dtxParas.setSceneCode(scenesCode);
                    dtxParas.setBranchCode(rs.getString(2));
                    dtxParas.setSeq(rs.getLong(3));
                    dtxParas.setBizId(rs.getString(4));
                    dtxParas.setXid(xid);
                    dtxParas.setParasBytes(rs.getBytes(5));
                    dtxParas.setCloudId(rs.getString(6));
                    dtxParas.setAppId(rs.getString(7));
                    dtxParas.setParamType(rs.getString(8));
                    dtxParas.setParam(rs.getString(9));
                    dtxParas.setTxType(Integer.toString(DtxType.EC.getCode()));
                    dtxParaSet.add(dtxParas);
                }
                return dtxParaSet;
            });
            return hashSet;
        }
    }
}

