/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.mq;

import java.util.HashSet;
import java.util.Set;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.util.StringUtils;

public class PublishManager {
    private static final String SEQ = "_";

    public static MessagePublisher getPublisher(String scene) {
        Set<String> scenesLoadBalance = PublishManager.getloadBalanceScenes();
        String queueName = scenesLoadBalance.contains(scene) ? PublishManager.getBalanceQueueName(scene) : "kdtxDefaultQueue";
        return MQFactory.get().createPartitionPublisher("kdtx", queueName, PartitionStrategy.APP_ID);
    }

    public static Set<String> getloadBalanceScenes() {
        HashSet<String> set = new HashSet<String>();
        String scenesLoadBalance = System.getProperty("kdtx.mq.balance.scenes", "");
        if (StringUtils.isNotEmpty((String)scenesLoadBalance)) {
            String[] split;
            for (String scene : split = scenesLoadBalance.split(",")) {
                if (!StringUtils.isNotEmpty((String)scene)) continue;
                set.add(scene);
            }
        }
        return set;
    }

    public static String getBalanceQueueName(String scene) {
        return "kdtxDefaultQueue_" + scene;
    }
}

