/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kdtx.common.util;

import java.util.Arrays;
import java.util.List;
import kd.bos.instance.Instance;
import kd.bos.kdtx.common.constant.AppInfo;
import kd.bos.kdtx.common.exception.ExceptionLogger;
import kd.bos.util.WebPortUtil;

public class AppUtils {
    private static final String DEPLOY_ALONE = "kdtx.server.independent.deploy";
    private static final String WEB_CONFIG_NAME = "web";
    private static final String QING_CONFIG_NAME = "mservice-qing";

    public static boolean isTCCServer() {
        boolean flag = false;
        Object[] appIds = Instance.getAppIds();
        boolean deployAlone = Boolean.parseBoolean(System.getProperty(DEPLOY_ALONE, "false"));
        if (Instance.isAppSplit()) {
            if (appIds != null && appIds.length > 0) {
                List<String> list = Arrays.asList(appIds);
                flag = deployAlone && list.contains(AppInfo.APP_ID.getName()) || !deployAlone && list.contains("bos");
            }
        } else {
            flag = !AppUtils.isAloneWebNode() && !AppUtils.isQingNode();
        }
        ExceptionLogger.info(AppUtils.class, "KdtxMonitorLog DTX-REGISTER: split=" + Instance.isAppSplit() + ",deployAlone=" + deployAlone + ";appIds=" + Arrays.toString(appIds) + "; " + (flag ? "start" : "do not") + " register kdtx-server ");
        return flag;
    }

    private static boolean isAloneWebNode() {
        return !Instance.isWebMserviceInOne() && WebPortUtil.isWebNode();
    }

    private static boolean isQingNode() {
        List<String> appIdList;
        List<String> configNameList;
        String[] configAppName = Instance.getConfigAppName();
        if (configAppName != null && configAppName.length > 0 && (configNameList = Arrays.asList(configAppName)).contains(QING_CONFIG_NAME)) {
            return true;
        }
        String[] appIds = Instance.getAppIds();
        return appIds != null && appIds.length > 0 && (appIdList = Arrays.asList(appIds)).contains("qing");
    }
}

