/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.client;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.core.SSEServiceInfo;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.service.rx.SSESubscriber;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;

public class SSEClient {
    private final PoolingHttpClientConnectionManager connManager;
    private final URI baseUri;
    private final Map<String, String> defaultCookies;

    public SSEClient(URI baseUri) {
        this(baseUri, new HashMap<String, String>());
    }

    public SSEClient(URI baseUri, Map<String, String> defaultCookies) {
        this(baseUri, defaultCookies, SSEConfig.current().getSSEClientMaxTotal(), SSEConfig.current().getSSEClientDefaultMaxPerRoute());
    }

    public SSEClient(URI baseUri, Map<String, String> defaultCookies, int maxTotal, int maxPerRouter) {
        this.baseUri = baseUri;
        this.connManager = new PoolingHttpClientConnectionManager();
        this.connManager.setMaxTotal(maxTotal);
        this.connManager.setDefaultMaxPerRoute(maxPerRouter);
        this.defaultCookies = defaultCookies;
    }

    public void post(SSEServiceInfo svcInfo, String json, SSESubscriber<? super String> sub) {
        block44: {
            BasicCookieStore cookieStore = new BasicCookieStore();
            for (Map.Entry<String, String> entry : this.defaultCookies.entrySet()) {
                BasicClientCookie cookie = new BasicClientCookie(entry.getKey(), entry.getValue());
                cookie.setDomain(this.baseUri.getHost());
                cookie.setPath("/");
                cookieStore.addCookie((Cookie)cookie);
            }
            try (CloseableHttpClient client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connManager).setDefaultCookieStore((CookieStore)cookieStore).build();){
                String segment = svcInfo.getAppId() + "/" + svcInfo.getServiceClass();
                HttpPost request = new HttpPost(this.baseUri.resolve(segment));
                if (this.defaultCookies.size() > 0) {
                    StringBuilder cookieHeader = new StringBuilder();
                    for (Map.Entry<String, String> cookie : this.defaultCookies.entrySet()) {
                        if (cookieHeader.length() > 0) {
                            cookieHeader.append("; ");
                        }
                        cookieHeader.append(cookie.getKey()).append("=").append(cookie.getValue());
                    }
                    request.setHeader("Cookie", cookieHeader.toString());
                }
                RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
                request.setConfig(requestConfig);
                HttpUtils.setRequestHeaders((HttpUriRequest)request);
                StringEntity postEntity = new StringEntity(json);
                request.setEntity((HttpEntity)postEntity);
                try (CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                    int stateCode = response.getStatusLine().getStatusCode();
                    if (stateCode == 200) {
                        HttpEntity entity = response.getEntity();
                        if (entity == null) break block44;
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                sub.onNext(line);
                            }
                            break block44;
                        }
                    }
                    sub.onError(new RuntimeException("reponse status :" + stateCode));
                }
            }
            catch (Exception e) {
                sub.onError(e);
            }
        }
        sub.onComplete();
    }

    public void post(String serviceName, String json, SSESubscriber<? super String> sub) {
        SSEServiceInfo svcInfo = new SSEServiceInfo("gai", serviceName);
        this.post(svcInfo, json, sub);
    }
}

