/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.exception.KDException;
import kd.bos.httpsse.core.KIterator;
import kd.bos.httpsse.core.KIteratorResult;

public class BlockingIterator<T>
implements KIterator<T> {
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final AtomicBoolean finished = new AtomicBoolean(false);
    private final Queue<T> items = new ConcurrentLinkedQueue<T>();
    private final int defaultTimeout;
    private final boolean throwExWhenTimeout;

    public BlockingIterator() {
        this(-1);
    }

    public BlockingIterator(int defaultTimeoutMS) {
        this(defaultTimeoutMS, false);
    }

    public BlockingIterator(int defaultTimeoutMS, boolean throwExWhenTimeout) {
        this.defaultTimeout = defaultTimeoutMS;
        this.throwExWhenTimeout = throwExWhenTimeout;
    }

    @Override
    public KIteratorResult<T> tryGetNext() {
        this.takeLock.lock();
        Object item = null;
        boolean hasValue = false;
        try {
            while (this.items.size() == 0 && !this.finished.get()) {
                if (this.defaultTimeout <= 0) {
                    this.notEmpty.await();
                    continue;
                }
                if (this.notEmpty.await(this.defaultTimeout, TimeUnit.MILLISECONDS)) continue;
                if (this.throwExWhenTimeout) {
                    throw new KDException("KIterator timeout: " + this.defaultTimeout + "ms");
                }
                KIteratorResult<Object> kIteratorResult = KIteratorResult.of(false, null);
                return kIteratorResult;
            }
            if (this.items.size() > 0) {
                hasValue = true;
                item = this.items.poll();
            }
            if (this.items.size() > 1) {
                this.notEmpty.signal();
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.takeLock.unlock();
        }
        return KIteratorResult.of(hasValue, item);
    }

    public void put(T item) {
        if (item == null) {
            throw new IllegalArgumentException("item is null");
        }
        if (this.finished.get()) {
            throw new RuntimeException("can't put element when finished");
        }
        this.takeLock.lock();
        try {
            this.items.offer(item);
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public void finish() {
        if (this.finished.get()) {
            return;
        }
        this.takeLock.lock();
        try {
            this.finished.set(true);
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }
}

