/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.server.impl.NormalServletHandler;
import kd.bos.httpsse.server.impl.RxServletHandler;
import kd.bos.httpsse.service.ClassRepo;
import kd.bos.httpsse.service.SSEService;
import kd.bos.httpsse.service.rx.SSEPublisher;

public interface ServletHandler {
    public static ServletHandler getImpl() {
        String svrMode = SSEConfig.current().getSSEServerMode();
        if (svrMode.equalsIgnoreCase("rx")) {
            return new RxServletHandler();
        }
        if (svrMode.equalsIgnoreCase("normal")) {
            return new NormalServletHandler();
        }
        throw new RuntimeException("not support server mode:" + svrMode);
    }

    public static ServletHandler getImpl(String serviceName) {
        if (ClassRepo.isImplementedBy(serviceName, SSEPublisher.class)) {
            return new RxServletHandler();
        }
        if (ClassRepo.isImplementedBy(serviceName, SSEService.class)) {
            return new NormalServletHandler();
        }
        throw new RuntimeException("not support sse service :" + serviceName);
    }

    public void callSSEService(String var1, String var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException;
}

