/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server.impl;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.core.KIterator;
import kd.bos.httpsse.core.KIteratorResult;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.server.ServletHandler;
import kd.bos.httpsse.service.ServiceExecutor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class NormalServletHandler
implements ServletHandler {
    private final Log log = LogFactory.getLog(NormalServletHandler.class);

    @Override
    public void callSSEService(String serviceName, String json, HttpServletRequest request, HttpServletResponse response) {
        if (SSEConfig.current().getSSEServerAsync()) {
            this.callSSEService_async(serviceName, json, request, response);
        } else {
            this.callSSEService_sync(serviceName, json, response);
        }
    }

    private void callSSEService_async(String serviceName, String json, HttpServletRequest request, HttpServletResponse response) {
        new Thread(() -> {
            AsyncContext ctx = request.startAsync();
            HttpUtils.setResponseHeaders(response, SSEConfig.current().getSSEServerResponseOtherHeaders());
            ServletResponse resp = ctx.getResponse();
            try {
                NormalServletHandler.callService_internal(serviceName, json, resp);
            }
            catch (IOException ex) {
                this.log.error((Throwable)ex);
                response.setStatus(500);
            }
            finally {
                ctx.complete();
            }
        }).start();
    }

    private void callSSEService_sync(String serviceName, String json, HttpServletResponse response) {
        try {
            if (!serviceName.matches("^[a-zA-Z_$][a-zA-Z\\d_.$]*$")) {
                throw new IllegalArgumentException("serviceName is illegal");
            }
            HttpUtils.setResponseHeaders(response, SSEConfig.current().getSSEServerResponseOtherHeaders());
            NormalServletHandler.callService_internal(serviceName, json, (ServletResponse)response);
        }
        catch (IOException ex) {
            this.log.error((Throwable)ex);
            response.setStatus(500);
        }
    }

    private static void callService_internal(String serviceName, String json, ServletResponse resp) throws IOException {
        KIteratorResult<String> result;
        KIterator<String> outputs = ServiceExecutor.execute(serviceName, json);
        while ((result = outputs.tryGetNext()).hasValue()) {
            String msg = result.getItem();
            String msgFormat = SSEConfig.current().getEventMessageFormat();
            HttpUtils.outputOnce(resp.getOutputStream(), msg, msgFormat);
        }
    }
}

