/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.server.impl;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.httpsse.server.ServletHandler;
import kd.bos.httpsse.service.rx.AsyncHttpSubscriber;
import kd.bos.httpsse.service.rx.PublisherRepo;
import kd.bos.httpsse.service.rx.SSEProducer;
import kd.bos.httpsse.service.rx.SSEPublisher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RxServletHandler
implements ServletHandler {
    private final Log log = LogFactory.getLog(RxServletHandler.class);

    @Override
    public void callSSEService(String publisherName, String json, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpUtils.setResponseHeaders(response, SSEConfig.current().getSSEServerResponseOtherHeaders());
        AsyncContext ctx = request.startAsync();
        try {
            ctx.setTimeout((long)SSEConfig.current().getAsyncContextTimeout());
            AsyncHttpSubscriber sub = new AsyncHttpSubscriber(ctx);
            SSEPublisher<String> pub = PublisherRepo.current().getOrCreate(publisherName);
            new SSEProducer<String>(sub, pub).on(json);
        }
        catch (Throwable th) {
            this.log.error(th);
            response.setStatus(500);
            HttpUtils.outputOnce(ctx.getResponse().getOutputStream(), th.getMessage(), "%s");
            ctx.complete();
        }
    }
}

