/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.httpsse.service.rx;

import java.util.concurrent.ExecutorService;
import kd.bos.httpsse.core.SSEConfig;
import kd.bos.httpsse.service.rx.PublisherAdapter;
import kd.bos.httpsse.service.rx.SSEPublisher;
import kd.bos.httpsse.service.rx.SSESubscriber;
import kd.bos.threads.ThreadPools;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public class SSEProducer<T>
implements AutoCloseable {
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"SSEProducer_ExecutorService", (int)SSEConfig.current().getSSERxProducerCoreThreads(), (int)SSEConfig.current().getSSERxProducerMaxThreads());
    private final SSEPublisher<T> pub;
    private final SSESubscriber<T> sub;
    private Disposable disposable;

    public SSEProducer(SSESubscriber<T> sub, SSEPublisher<T> pub) {
        this.sub = sub;
        this.pub = pub;
    }

    public void on(String args) {
        this.disposable = Flux.from(new PublisherAdapter<T>(args, this.pub)).subscribeOn(Schedulers.fromExecutorService((ExecutorService)executorService)).subscribe(this.sub::onNext, this.sub::onError, this.sub::onComplete);
    }

    @Override
    public void close() {
        this.disposable.dispose();
    }
}

