/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import java.lang.reflect.Type;
import kd.sdk.annotation.SdkScriptWrapper;
import kd.sdk.kingscript.global.GlobalObject;

public final class KingScriptDebugVarUtil {
    private static final int max_description = 100;
    public static final int SHOW_COLLECTION_ITEM_MAX_SIZE = 20;

    public static boolean hideVariable(String name) {
        return GlobalObject.getGlobalMembers().contains(name);
    }

    public static boolean hideMember(DebugValue dv) {
        Object value = dv.get();
        if (value instanceof ExportResolution) {
            return true;
        }
        return KingScriptDebugVarUtil.hideMember(dv.getName());
    }

    public static boolean hideMember(String name) {
        return name.startsWith("__") || name.startsWith("set__") || name.startsWith("get__");
    }

    public static String shortDescription(String description) {
        if (description == null || description.length() < 100) {
            return description;
        }
        return description.substring(0, 100) + "...";
    }

    public static String getShortType(Type type) {
        if (type instanceof Class) {
            return KingScriptDebugVarUtil.getSdkScriptWrapperScriptName((Class)type, false);
        }
        String name = type.getTypeName();
        int p = name.lastIndexOf(46);
        if (p != -1) {
            name = name.substring(p + 1);
        }
        return name;
    }

    public static String getSdkScriptWrapperScriptName(Class<?> cls, boolean withPackage) {
        if (cls.isArray()) {
            try {
                Class<?> cl = cls;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                String name = KingScriptDebugVarUtil.getClassName(cl, withPackage);
                StringBuilder sb = new StringBuilder();
                sb.append(name);
                for (int i = 0; i < dimensions; ++i) {
                    sb.append("[]");
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return KingScriptDebugVarUtil.getClassName(cls, withPackage);
    }

    private static String getClassName(Class<?> cls, boolean withPackage) {
        Package pk;
        String name = null;
        SdkScriptWrapper wrapper = cls.getAnnotation(SdkScriptWrapper.class);
        if (wrapper != null && (name = wrapper.scriptName()) != null && !name.isEmpty() && withPackage && (pk = cls.getPackage()) != null) {
            name = pk.getName() + '.' + name;
        }
        if (name == null || name.isEmpty()) {
            name = withPackage ? cls.getName() : cls.getSimpleName();
        }
        return name;
    }
}

