/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import kd.sdk.kingscript.monitor.cost.probe.Probe;
import kd.sdk.kingscript.monitor.cost.probe.ProbeContext;
import kd.sdk.kingscript.monitor.cost.probe.ProbeLoop;

public final class DefaultLoopNode
extends LoopNode {
    @Node.Child
    private RepeatingNode repeatNode;

    public DefaultLoopNode(RepeatingNode repeatNode) {
        this.repeatNode = repeatNode;
    }

    public RepeatingNode getRepeatingNode() {
        return this.repeatNode;
    }

    public Object execute0(VirtualFrame frame) {
        Object status;
        while (this.repeatNode.shouldContinue(status = this.repeatNode.executeRepeatingWithValue(frame))) {
            TruffleSafepoint.poll((Node)this);
        }
        return status;
    }

    public Object execute(VirtualFrame frame) {
        Object status;
        if (ProbeContext.get() == null) {
            return this.execute0(frame);
        }
        KingScriptChanges.fixed("loop\u63a2\u9488");
        try (ProbeLoop loop = Probe.loop();){
            while (this.repeatNode.shouldContinue(status = this.repeatNode.executeRepeatingWithValue(frame))) {
                TruffleSafepoint.poll((Node)this);
                loop.checkLoopAccess();
            }
        }
        return status;
    }
}

