/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleException;
import kd.sdk.kingscript.exception.InternalExceptionCat;

public abstract class InteropException
extends Exception {
    private static final long serialVersionUID = -5173354806966156285L;

    InteropException(String message, Throwable cause) {
        super(message, cause);
        this.cat(message, cause);
    }

    InteropException(String message) {
        super(message);
        this.cat(message, null);
    }

    private final void cat(String message, Throwable cause) {
        if (message != null || cause != null) {
            KingScriptChanges.fixed("\u83b7\u53d6\u771f\u6b63\u7684\u5f02\u5e38");
            InternalExceptionCat.cat(message, cause);
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public final synchronized Throwable getCause() {
        return super.getCause();
    }

    @Override
    @Deprecated
    @CompilerDirectives.TruffleBoundary
    public final synchronized Throwable initCause(Throwable cause) {
        return super.initCause(cause);
    }

    @Override
    public final Throwable fillInStackTrace() {
        return this;
    }

    private static void validateTruffleException(Throwable t) {
        if (CompilerDirectives.inCompiledCode()) {
            return;
        }
        if (t == null) {
            return;
        }
        if (!(t instanceof TruffleException)) {
            throw new IllegalArgumentException("Cause exception must implement TruffleException but was " + t.getClass() + ".");
        }
    }
}

