/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.host.HostAccessor;
import com.oracle.truffle.host.HostContext;
import java.lang.invoke.MethodHandle;
import kd.sdk.kingscript.engine.inherit.InheritUtil;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.types.Types;
import org.graalvm.polyglot.Value;

abstract class GuestToHostRootNode
extends RootNode {
    protected static final int ARGUMENT_OFFSET = 2;
    private final String boundaryName;

    protected GuestToHostRootNode(Class<?> targetType, String methodName) {
        super(null);
        this.boundaryName = targetType.getName() + "." + methodName;
    }

    protected boolean isInstrumentable() {
        return false;
    }

    public boolean isCloningAllowed() {
        return false;
    }

    public final String getName() {
        return this.boundaryName;
    }

    public Object execute(VirtualFrame frame) {
        int argIndex = 3;
        Object[] arguments = frame.getArguments();
        if (argIndex < arguments.length) {
            boolean maybeCallExtendConstructor;
            KingScriptChanges.fixed("\u89e3\u5c01");
            if (!arguments[argIndex].getClass().isArray()) {
                throw new ScriptException("unknownIdentifier: " + arguments[argIndex]);
            }
            Object[] args = (Object[])arguments[argIndex];
            boolean bl = maybeCallExtendConstructor = arguments[1] == null;
            if (maybeCallExtendConstructor) {
                for (int i = 0; i < args.length; ++i) {
                    MethodHandle methodHandle;
                    Object arg = args[i];
                    if (i != args.length - 1 || !(arg instanceof Value) || !InheritUtil.isCallExtendConstructor(methodHandle = (MethodHandle)arguments[2])) {
                        args[i] = Types.js2java(arg);
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < args.length; ++i) {
                    args[i] = Types.js2java(args[i]);
                }
            }
        }
        try {
            return this.executeImpl(arguments[1], arguments);
        }
        catch (InteropException e) {
            throw GuestToHostRootNode.silenceException(RuntimeException.class, e);
        }
        catch (Throwable e) {
            throw ((HostContext)arguments[0]).hostToGuestException(e);
        }
    }

    static <E extends Throwable> RuntimeException silenceException(Class<E> type, Throwable ex) throws E {
        throw ex;
    }

    protected abstract Object executeImpl(Object var1, Object[] var2) throws InteropException;

    static Object guestToHostCall(Node node, CallTarget target, Object ... arguments) {
        Node encapsulatingNode = node.isAdoptable() ? node : EncapsulatingNodeReference.getCurrent().get();
        return HostAccessor.RUNTIME.callInlined(encapsulatingNode, target, arguments);
    }
}

