/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.host.HostAccessor;
import com.oracle.truffle.host.HostAdapterFactory;
import com.oracle.truffle.host.HostClassCache;
import com.oracle.truffle.host.HostContext;
import com.oracle.truffle.host.HostFieldDesc;
import com.oracle.truffle.host.HostInteropReflect;
import com.oracle.truffle.host.HostMethodDesc;
import java.lang.ref.Reference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import kd.sdk.annotation.SdkInternal;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

final class HostClassDesc {
    private final Class<?> type;
    private final Reference<HostClassCache> cache;
    private volatile Members members;
    private volatile JNIMembers jniMembers;
    private volatile MethodsBySignature methodsBySignature;
    private volatile HostAdapterFactory.AdapterResult adapter;
    private final boolean allowsImplementation;
    private final boolean allowedTargetType;

    @CompilerDirectives.TruffleBoundary
    static HostClassDesc forClass(HostContext context, Class<?> clazz) {
        return context.getHostClassCache().forClass(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    static HostClassDesc forClass(HostClassCache cache, Class<?> clazz) {
        return cache.forClass(clazz);
    }

    HostClassDesc(Reference<HostClassCache> cacheRef, Class<?> type) {
        this.type = type;
        this.cache = cacheRef;
        this.allowsImplementation = HostInteropReflect.isExtensibleType(type) && this.getCache().allowsImplementation(type);
        this.allowedTargetType = this.allowsImplementation && HostInteropReflect.isAbstractType(type) && HostClassDesc.hasDefaultConstructor(type);
    }

    public boolean isAllowsImplementation() {
        return this.allowsImplementation;
    }

    public boolean isAllowedTargetType() {
        return this.allowedTargetType;
    }

    public Class<?> getType() {
        return this.type;
    }

    private static boolean hasDefaultConstructor(Class<?> type) {
        assert (!type.isPrimitive());
        if (type.isInterface()) {
            return true;
        }
        for (Constructor<?> ctor : type.getConstructors()) {
            if (ctor.getParameterCount() != 0) continue;
            return true;
        }
        return false;
    }

    static boolean isObjectMethodOverride(Method m) {
        return m.getParameterCount() == 0 && (m.getName().equals("hashCode") || m.getName().equals("toString")) || m.getParameterCount() == 1 && m.getName().equals("equals") && m.getParameterTypes()[0] == Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Members getMembers() {
        Members m = this.members;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m = this.members;
                if (m == null) {
                    HostClassCache localCache = this.getCache();
                    this.members = m = new Members(localCache, this.type);
                }
            }
        }
        return m;
    }

    private HostClassCache getCache() {
        HostClassCache localCache = this.cache.get();
        assert (localCache != null) : "cache was collected but should no longer be accessible";
        return localCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JNIMembers getJNIMembers() {
        JNIMembers m = this.jniMembers;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m = this.jniMembers;
                if (m == null) {
                    this.jniMembers = m = new JNIMembers(this.getMembers());
                }
            }
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodsBySignature getMethodsBySignature() {
        MethodsBySignature m = this.methodsBySignature;
        if (m == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            HostClassDesc hostClassDesc = this;
            synchronized (hostClassDesc) {
                m = this.methodsBySignature;
                if (m == null) {
                    this.methodsBySignature = m = new MethodsBySignature(this.getMembers());
                }
            }
        }
        return m;
    }

    private HostMethodDesc lookupMethod(String name) {
        return this.getMembers().methods.get(name);
    }

    private HostMethodDesc lookupStaticMethod(String name) {
        return this.getMembers().staticMethods.get(name);
    }

    public HostMethodDesc lookupMethod(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticMethod(name) : this.lookupMethod(name);
    }

    HostMethodDesc lookupMethodBySignature(String nameAndSignature, boolean onlyStatic) {
        MethodsBySignature m = this.getMethodsBySignature();
        return onlyStatic ? (HostMethodDesc)m.staticMethods.get((Object)nameAndSignature) : (HostMethodDesc)m.methods.get((Object)nameAndSignature);
    }

    public HostMethodDesc lookupMethodByJNIName(String jniName, boolean onlyStatic) {
        JNIMembers m = this.getJNIMembers();
        return onlyStatic ? (HostMethodDesc)m.staticMethods.get((Object)jniName) : (HostMethodDesc)m.methods.get((Object)jniName);
    }

    public Collection<String> getMethodNames(boolean onlyStatic, boolean includeInternal) {
        Map<String, HostMethodDesc> methods;
        Map<String, HostMethodDesc> map = methods = onlyStatic ? this.getMembers().staticMethods : this.getMembers().methods;
        if (includeInternal || onlyStatic) {
            return Collections.unmodifiableCollection(methods.keySet());
        }
        ArrayList<String> methodNames = new ArrayList<String>(methods.size());
        for (Map.Entry<String, HostMethodDesc> entry : methods.entrySet()) {
            if (entry.getValue().isInternal()) continue;
            methodNames.add(entry.getKey());
        }
        return methodNames;
    }

    public HostMethodDesc lookupConstructor() {
        return this.getMembers().constructor;
    }

    private HostFieldDesc lookupField(String name) {
        return this.getMembers().fields.get(name);
    }

    private HostFieldDesc lookupStaticField(String name) {
        return this.getMembers().staticFields.get(name);
    }

    public HostFieldDesc lookupField(String name, boolean onlyStatic) {
        return onlyStatic ? this.lookupStaticField(name) : this.lookupField(name);
    }

    public Collection<String> getFieldNames(boolean onlyStatic) {
        return Collections.unmodifiableCollection((onlyStatic ? this.getMembers().staticFields : this.getMembers().fields).keySet());
    }

    public HostMethodDesc getFunctionalMethod() {
        return this.getMembers().functionalMethod;
    }

    public HostAdapterFactory.AdapterResult getAdapter(HostContext hostContext) {
        HostAdapterFactory.AdapterResult result = this.adapter;
        if (result == null) {
            result = this.getOrSetAdapter(hostContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostAdapterFactory.AdapterResult getOrSetAdapter(HostContext hostContext) {
        CompilerAsserts.neverPartOfCompilation();
        HostClassDesc hostClassDesc = this;
        synchronized (hostClassDesc) {
            HostAdapterFactory.AdapterResult result = this.adapter;
            if (result == null) {
                this.adapter = result = HostAdapterFactory.makeAdapterClassFor(this.getCache(), this.type, (ClassLoader)hostContext.getClassloader());
            }
            return result;
        }
    }

    public String toString() {
        return "JavaClass[" + this.type.getCanonicalName() + "]";
    }

    private static final class MethodsBySignature {
        final UnmodifiableEconomicMap<String, HostMethodDesc> methods;
        final UnmodifiableEconomicMap<String, HostMethodDesc> staticMethods;

        MethodsBySignature(Members members) {
            this.methods = MethodsBySignature.collectMethodsBySignature(members.methods);
            this.staticMethods = MethodsBySignature.collectMethodsBySignature(members.staticMethods);
        }

        private static UnmodifiableEconomicMap<String, HostMethodDesc> collectMethodsBySignature(Map<String, HostMethodDesc> methods) {
            EconomicMap methodMap = EconomicMap.create();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc.SingleMethod m : method.getOverloads()) {
                    assert (m.isMethod());
                    methodMap.put((Object)HostInteropReflect.toNameAndSignature((Method)((Method)m.getReflectionMethod())), (Object)m);
                }
            }
            return methodMap;
        }
    }

    private static final class JNIMembers {
        final UnmodifiableEconomicMap<String, HostMethodDesc> methods;
        final UnmodifiableEconomicMap<String, HostMethodDesc> staticMethods;

        JNIMembers(Members members) {
            this.methods = JNIMembers.collectJNINamedMethods(members.methods);
            this.staticMethods = JNIMembers.collectJNINamedMethods(members.staticMethods);
        }

        private static UnmodifiableEconomicMap<String, HostMethodDesc> collectJNINamedMethods(Map<String, HostMethodDesc> methods) {
            EconomicMap jniMethods = EconomicMap.create();
            for (HostMethodDesc method : methods.values()) {
                if (method.isConstructor()) continue;
                for (HostMethodDesc.SingleMethod m : method.getOverloads()) {
                    assert (m.isMethod());
                    jniMethods.put((Object)HostInteropReflect.jniName((Method)((Method)m.getReflectionMethod())), (Object)m);
                }
            }
            return jniMethods;
        }
    }

    private static class Members {
        final Map<String, HostMethodDesc> methods;
        final Map<String, HostMethodDesc> staticMethods;
        final HostMethodDesc constructor;
        final Map<String, HostFieldDesc> fields;
        final Map<String, HostFieldDesc> staticFields;
        final HostMethodDesc functionalMethod;
        private static final BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc> MERGE = new BiFunction<HostMethodDesc, HostMethodDesc, HostMethodDesc>(){

            @Override
            public HostMethodDesc apply(HostMethodDesc m1, HostMethodDesc m2) {
                return Members.merge(m1, m2);
            }
        };

        Members(HostClassCache hostAccess, Class<?> type) {
            String functionalInterfaceMethodName;
            LinkedHashMap<String, HostMethodDesc> methodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostMethodDesc> staticMethodMap = new LinkedHashMap<String, HostMethodDesc>();
            LinkedHashMap<String, HostFieldDesc> fieldMap = new LinkedHashMap<String, HostFieldDesc>();
            LinkedHashMap<String, HostFieldDesc> staticFieldMap = new LinkedHashMap<String, HostFieldDesc>();
            HostMethodDesc functionalInterfaceMethod = null;
            Members.collectPublicMethods(hostAccess, type, methodMap, staticMethodMap);
            Members.collectPublicFields(hostAccess, type, fieldMap, staticFieldMap);
            HostMethodDesc ctor = Members.collectPublicConstructors(hostAccess, type);
            if (!Modifier.isInterface(type.getModifiers()) && !Modifier.isAbstract(type.getModifiers()) && (functionalInterfaceMethodName = Members.findFunctionalInterfaceMethodName(type)) != null) {
                functionalInterfaceMethod = (HostMethodDesc)methodMap.get(functionalInterfaceMethodName);
            }
            this.methods = methodMap;
            this.staticMethods = staticMethodMap;
            this.constructor = ctor;
            this.fields = fieldMap;
            this.staticFields = staticFieldMap;
            this.functionalMethod = functionalInterfaceMethod;
        }

        private static boolean isClassAccessible(Class<?> declaringClass, HostClassCache hostAccess) {
            return Modifier.isPublic(declaringClass.getModifiers()) && HostAccessor.JDKSERVICES.verifyModuleVisibility(hostAccess.getUnnamedModule(), declaringClass);
        }

        private static HostMethodDesc collectPublicConstructors(HostClassCache hostAccess, Class<?> type) {
            HostMethodDesc.SingleMethod ctor = null;
            if (Members.isClassAccessible(type, hostAccess)) {
                for (Constructor<?> c : type.getConstructors()) {
                    KingScriptChanges.fixed("mask sdk internal constructor");
                    if (!hostAccess.allowsAccess(c) || c.getAnnotation(SdkInternal.class) != null) continue;
                    boolean scoped = hostAccess.methodScoped(c);
                    HostMethodDesc.SingleMethod overload = HostMethodDesc.SingleMethod.unreflect(c, scoped);
                    ctor = ctor == null ? overload : Members.merge(ctor, overload);
                }
            }
            return ctor;
        }

        private static void collectPublicMethods(HostClassCache hostAccess, Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            Members.collectPublicMethods(hostAccess, type, methodMap, staticMethodMap, new HashSet<Object>(), type);
        }

        private static void collectPublicMethods(HostClassCache hostAccess, Class<?> type, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap, Set<Object> visited, Class<?> startType) {
            boolean isPublicType = Members.isClassAccessible(type, hostAccess) && !Proxy.isProxyClass(type);
            boolean allMethodsPublic = true;
            ArrayList<GenericDeclaration> bridgeMethods = null;
            if (isPublicType) {
                for (GenericDeclaration genericDeclaration : type.getMethods()) {
                    KingScriptChanges.fixed("\u5ffd\u7565\u6536\u96c6\u975eSDK\u65b9\u6cd5");
                    if (((Method)genericDeclaration).getAnnotation(SdkInternal.class) != null) continue;
                    Class<?> declaringClass = ((Method)genericDeclaration).getDeclaringClass();
                    if (Modifier.isStatic(((Method)genericDeclaration).getModifiers()) && declaringClass != startType && Modifier.isInterface(declaringClass.getModifiers())) continue;
                    if (!Members.isClassAccessible(declaringClass, hostAccess)) {
                        allMethodsPublic = false;
                        continue;
                    }
                    if (((Method)genericDeclaration).isBridge()) {
                        allMethodsPublic = false;
                        if (bridgeMethods == null) {
                            bridgeMethods = new ArrayList<GenericDeclaration>();
                        }
                        bridgeMethods.add(genericDeclaration);
                        continue;
                    }
                    if (!visited.add(Members.methodInfo((Method)genericDeclaration))) continue;
                    Members.putMethod(hostAccess, (Method)genericDeclaration, methodMap, staticMethodMap);
                }
                if (hostAccess.isArrayAccess() && type.isArray()) {
                    HostMethodDesc.SingleMethod.SyntheticArrayCloneMethod arrayCloneMethod = HostMethodDesc.SingleMethod.SyntheticArrayCloneMethod.SINGLETON;
                    methodMap.put(((HostMethodDesc.SingleMethod)arrayCloneMethod).getName(), arrayCloneMethod);
                }
            }
            if (!isPublicType || !allMethodsPublic) {
                if (type.getSuperclass() != null) {
                    Members.collectPublicMethods(hostAccess, type.getSuperclass(), methodMap, staticMethodMap, visited, startType);
                }
                for (Class<?> clazz : type.getInterfaces()) {
                    if (!visited.add(clazz)) continue;
                    Members.collectPublicMethods(hostAccess, clazz, methodMap, staticMethodMap, visited, startType);
                }
            }
            if (bridgeMethods != null && !bridgeMethods.isEmpty()) {
                for (Method method : bridgeMethods) {
                    if (!visited.add(Members.methodInfo(method))) continue;
                    Members.putMethod(hostAccess, method, methodMap, staticMethodMap);
                }
            }
        }

        private static Object methodInfo(Method m) {
            class MethodInfo {
                private final boolean isStatic;
                private final String name;
                private final Class<?>[] parameterTypes;
                final /* synthetic */ Method val$m;

                MethodInfo(Method method) {
                    this.val$m = method;
                    this.isStatic = Modifier.isStatic(this.val$m.getModifiers());
                    this.name = this.val$m.getName();
                    this.parameterTypes = this.val$m.getParameterTypes();
                }

                public boolean equals(Object obj) {
                    if (obj instanceof MethodInfo) {
                        MethodInfo other = (MethodInfo)obj;
                        return this.isStatic == other.isStatic && this.name.equals(other.name) && Arrays.equals(this.parameterTypes, other.parameterTypes);
                    }
                    return false;
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.isStatic ? 1 : 0);
                    result = 31 * result + this.name.hashCode();
                    result = 31 * result + Arrays.hashCode(this.parameterTypes);
                    return result;
                }
            }
            return new MethodInfo(m);
        }

        private static void putMethod(HostClassCache hostAccess, Method m, Map<String, HostMethodDesc> methodMap, Map<String, HostMethodDesc> staticMethodMap) {
            if (!hostAccess.allowsAccess(m)) {
                return;
            }
            boolean scoped = hostAccess.methodScoped((Executable)m);
            HostMethodDesc.SingleMethod method = HostMethodDesc.SingleMethod.unreflect(m, scoped);
            Map<String, HostMethodDesc> map = Modifier.isStatic(m.getModifiers()) ? staticMethodMap : methodMap;
            map.merge(m.getName(), method, MERGE);
        }

        static HostMethodDesc merge(HostMethodDesc existing, HostMethodDesc other) {
            assert (other instanceof HostMethodDesc.SingleMethod);
            if (existing instanceof HostMethodDesc.SingleMethod) {
                return new HostMethodDesc.OverloadedMethod(new HostMethodDesc.SingleMethod[]{(HostMethodDesc.SingleMethod)existing, (HostMethodDesc.SingleMethod)other});
            }
            HostMethodDesc.SingleMethod[] oldOverloads = ((HostMethodDesc.OverloadedMethod)existing).getOverloads();
            HostMethodDesc.SingleMethod[] newOverloads = Arrays.copyOf(oldOverloads, oldOverloads.length + 1);
            newOverloads[oldOverloads.length] = (HostMethodDesc.SingleMethod)other;
            return new HostMethodDesc.OverloadedMethod(newOverloads);
        }

        private static void collectPublicFields(HostClassCache hostAccess, Class<?> type, Map<String, HostFieldDesc> fieldMap, Map<String, HostFieldDesc> staticFieldMap) {
            if (Members.isClassAccessible(type, hostAccess)) {
                boolean inheritedPublicInstanceFields = false;
                boolean inheritedPublicInaccessibleFields = false;
                for (Field f : type.getFields()) {
                    if (!Modifier.isStatic(f.getModifiers())) {
                        if (f.getDeclaringClass() == type) {
                            assert (!fieldMap.containsKey(f.getName()));
                            if (!hostAccess.allowsAccess(f)) continue;
                            fieldMap.put(f.getName(), HostFieldDesc.unreflect((Field)f));
                            continue;
                        }
                        if (Members.isClassAccessible(f.getDeclaringClass(), hostAccess)) {
                            inheritedPublicInstanceFields = true;
                            continue;
                        }
                        inheritedPublicInaccessibleFields = true;
                        continue;
                    }
                    if (f.getDeclaringClass() != type || !hostAccess.allowsAccess(f)) continue;
                    staticFieldMap.put(f.getName(), HostFieldDesc.unreflect((Field)f));
                }
                if (inheritedPublicInstanceFields) {
                    Members.collectPublicInstanceFields(hostAccess, type, fieldMap, inheritedPublicInaccessibleFields);
                }
                if (hostAccess.isArrayAccess() && type.isArray()) {
                    HostFieldDesc.SyntheticArrayLengthField arrayLengthField = HostFieldDesc.SyntheticArrayLengthField.SINGLETON;
                    fieldMap.put(arrayLengthField.getName(), (HostFieldDesc)arrayLengthField);
                }
            } else if (!Modifier.isInterface(type.getModifiers())) {
                Members.collectPublicInstanceFields(hostAccess, type, fieldMap, true);
            }
        }

        private static void collectPublicInstanceFields(HostClassCache hostAccess, Class<?> type, Map<String, HostFieldDesc> fieldMap, boolean mayHaveInaccessibleFields) {
            HashSet<String> fieldNames = new HashSet<String>();
            for (Class<?> superclass = type; superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                boolean inheritedPublicInstanceFields = false;
                for (Field f : superclass.getFields()) {
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    if (f.getDeclaringClass() != superclass) {
                        if (!Modifier.isPublic(f.getDeclaringClass().getModifiers())) continue;
                        inheritedPublicInstanceFields = true;
                        continue;
                    }
                    if (mayHaveInaccessibleFields && !fieldNames.add(f.getName())) continue;
                    if (Members.isClassAccessible(f.getDeclaringClass(), hostAccess)) {
                        if (!hostAccess.allowsAccess(f)) continue;
                        fieldMap.putIfAbsent(f.getName(), HostFieldDesc.unreflect((Field)f));
                        continue;
                    }
                    assert (mayHaveInaccessibleFields);
                }
                if (!inheritedPublicInstanceFields) break;
            }
        }

        private static String findFunctionalInterfaceMethodName(Class<?> clazz) {
            for (Class<?> iface : clazz.getInterfaces()) {
                if (!Modifier.isPublic(iface.getModifiers()) || !iface.isAnnotationPresent(FunctionalInterface.class)) continue;
                for (Method m : iface.getMethods()) {
                    if (!Modifier.isAbstract(m.getModifiers()) || HostClassDesc.isObjectMethodOverride(m)) continue;
                    return m.getName();
                }
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null && superclass != Object.class) {
                return Members.findFunctionalInterfaceMethodName(superclass);
            }
            return null;
        }
    }
}

