/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.TimeZoneFormat;
import com.ibm.icu.text.TimeZoneNames;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.GregorianCalendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.builtins.ArrayIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.AtomicsBuiltins;
import com.oracle.truffle.js.builtins.ConsoleBuiltins;
import com.oracle.truffle.js.builtins.ConstructorBuiltins;
import com.oracle.truffle.js.builtins.DebugBuiltins;
import com.oracle.truffle.js.builtins.GlobalBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.JavaBuiltins;
import com.oracle.truffle.js.builtins.MLEBuiltins;
import com.oracle.truffle.js.builtins.MapIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.ObjectFunctionBuiltins;
import com.oracle.truffle.js.builtins.OperatorsBuiltins;
import com.oracle.truffle.js.builtins.PerformanceBuiltins;
import com.oracle.truffle.js.builtins.PolyglotBuiltins;
import com.oracle.truffle.js.builtins.RealmFunctionBuiltins;
import com.oracle.truffle.js.builtins.ReflectBuiltins;
import com.oracle.truffle.js.builtins.RegExpBuiltins;
import com.oracle.truffle.js.builtins.RegExpStringIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.SetIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.StringIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.commonjs.GlobalCommonJSRequireBuiltins;
import com.oracle.truffle.js.builtins.commonjs.NpmCompatibleESModuleLoader;
import com.oracle.truffle.js.builtins.foreign.ForeignIterablePrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSAgent;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSConsoleUtil;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSErrorType;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.array.TypedArrayFactory;
import com.oracle.truffle.js.runtime.builtins.Builtin;
import com.oracle.truffle.js.runtime.builtins.JSAdapter;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSBigInt;
import com.oracle.truffle.js.runtime.builtins.JSBoolean;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.JSError;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSGlobal;
import com.oracle.truffle.js.runtime.builtins.JSMap;
import com.oracle.truffle.js.runtime.builtins.JSMath;
import com.oracle.truffle.js.runtime.builtins.JSNumber;
import com.oracle.truffle.js.runtime.builtins.JSON;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectPrototype;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSPromise;
import com.oracle.truffle.js.runtime.builtins.JSProxy;
import com.oracle.truffle.js.runtime.builtins.JSRegExp;
import com.oracle.truffle.js.runtime.builtins.JSSet;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.builtins.JSSymbol;
import com.oracle.truffle.js.runtime.builtins.JSTest262;
import com.oracle.truffle.js.runtime.builtins.JSTestV8;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakRef;
import com.oracle.truffle.js.runtime.builtins.JSWeakSet;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSDateTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSDisplayNames;
import com.oracle.truffle.js.runtime.builtins.intl.JSIntl;
import com.oracle.truffle.js.runtime.builtins.intl.JSListFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSLocale;
import com.oracle.truffle.js.runtime.builtins.intl.JSNumberFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSPluralRules;
import com.oracle.truffle.js.runtime.builtins.intl.JSRelativeTimeFormat;
import com.oracle.truffle.js.runtime.builtins.intl.JSSegmenter;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssembly;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyGlobal;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemory;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyMemoryGrowCallback;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyModule;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyTable;
import com.oracle.truffle.js.runtime.interop.DynamicScopeWrapper;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.interop.TopScopeObject;
import com.oracle.truffle.js.runtime.java.JavaImporter;
import com.oracle.truffle.js.runtime.java.JavaPackage;
import com.oracle.truffle.js.runtime.objects.Accessor;
import com.oracle.truffle.js.runtime.objects.DefaultESModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import com.oracle.truffle.js.runtime.util.LRUCache;
import com.oracle.truffle.js.runtime.util.PrintWriterWrapper;
import com.oracle.truffle.js.runtime.util.SimpleArrayList;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.LinkOption;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SplittableRandom;
import java.util.WeakHashMap;
import kd.sdk.kingscript.engine.KingScriptEngine;
import org.graalvm.collections.Pair;
import org.graalvm.home.HomeFinder;
import org.graalvm.options.OptionValues;

public class JSRealm {
    public static final String POLYGLOT_CLASS_NAME = "Polyglot";
    public static final String REFLECT_CLASS_NAME = "Reflect";
    public static final String SHARED_ARRAY_BUFFER_CLASS_NAME = "SharedArrayBuffer";
    public static final String ATOMICS_CLASS_NAME = "Atomics";
    public static final String REALM_BUILTIN_CLASS_NAME = "Realm";
    public static final String ARGUMENTS_NAME = "arguments";
    public static final String JAVA_CLASS_NAME = "Java";
    public static final String JAVA_CLASS_NAME_NASHORN_COMPAT = "JavaNashornCompat";
    public static final String PERFORMANCE_CLASS_NAME = "performance";
    public static final String DEBUG_CLASS_NAME = "Debug";
    public static final String CONSOLE_CLASS_NAME = "Console";
    public static final String MLE_CLASS_NAME = "MLE";
    private static final String GRAALVM_VERSION = HomeFinder.getInstance().getVersion();
    private static final TruffleLanguage.ContextReference<JSRealm> REFERENCE = TruffleLanguage.ContextReference.create(JavaScriptLanguage.class);
    private final JSContext context;
    @CompilerDirectives.CompilationFinal
    private DynamicObject globalObject;
    private final DynamicObject objectConstructor;
    private final DynamicObject objectPrototype;
    private final DynamicObject functionConstructor;
    private final DynamicObject functionPrototype;
    private final DynamicObject arrayConstructor;
    private final DynamicObject arrayPrototype;
    private final DynamicObject booleanConstructor;
    private final DynamicObject booleanPrototype;
    private final DynamicObject numberConstructor;
    private final DynamicObject numberPrototype;
    private final DynamicObject bigIntConstructor;
    private final DynamicObject bigIntPrototype;
    private final DynamicObject stringConstructor;
    private final DynamicObject stringPrototype;
    private final DynamicObject regExpConstructor;
    private final DynamicObject regExpPrototype;
    private final DynamicObject collatorConstructor;
    private final DynamicObject collatorPrototype;
    private final DynamicObject numberFormatConstructor;
    private final DynamicObject numberFormatPrototype;
    private final DynamicObject pluralRulesConstructor;
    private final DynamicObject pluralRulesPrototype;
    private final DynamicObject listFormatConstructor;
    private final DynamicObject listFormatPrototype;
    private final DynamicObject dateTimeFormatConstructor;
    private final DynamicObject dateTimeFormatPrototype;
    private final DynamicObject relativeTimeFormatConstructor;
    private final DynamicObject relativeTimeFormatPrototype;
    private final DynamicObject segmenterConstructor;
    private final DynamicObject segmenterPrototype;
    private final DynamicObject displayNamesConstructor;
    private final DynamicObject displayNamesPrototype;
    private final DynamicObject localeConstructor;
    private final DynamicObject localePrototype;
    private final DynamicObject dateConstructor;
    private final DynamicObject datePrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] errorConstructors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] errorPrototypes;
    private final DynamicObject callSiteConstructor;
    private final DynamicObject callSitePrototype;
    private final Shape initialRegExpPrototypeShape;
    private final JSObjectFactory.RealmData objectFactories;
    private final DynamicObject symbolConstructor;
    private final DynamicObject symbolPrototype;
    private final DynamicObject mapConstructor;
    private final DynamicObject mapPrototype;
    private final DynamicObject setConstructor;
    private final DynamicObject setPrototype;
    private final DynamicObject weakRefConstructor;
    private final DynamicObject weakRefPrototype;
    private final DynamicObject weakMapConstructor;
    private final DynamicObject weakMapPrototype;
    private final DynamicObject weakSetConstructor;
    private final DynamicObject weakSetPrototype;
    private final DynamicObject mathObject;
    private DynamicObject realmBuiltinObject;
    private Object evalFunctionObject;
    private final Object applyFunctionObject;
    private final Object callFunctionObject;
    private Object reflectApplyFunctionObject;
    private Object reflectConstructFunctionObject;
    private Object commonJSRequireFunctionObject;
    private Object jsonParseFunctionObject;
    private final DynamicObject arrayBufferConstructor;
    private final DynamicObject arrayBufferPrototype;
    private final DynamicObject sharedArrayBufferConstructor;
    private final DynamicObject sharedArrayBufferPrototype;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] typedArrayConstructors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final DynamicObject[] typedArrayPrototypes;
    private final DynamicObject dataViewConstructor;
    private final DynamicObject dataViewPrototype;
    private final DynamicObject jsAdapterConstructor;
    private final DynamicObject jsAdapterPrototype;
    private final DynamicObject javaImporterConstructor;
    private final DynamicObject javaImporterPrototype;
    private final DynamicObject proxyConstructor;
    private final DynamicObject proxyPrototype;
    private final DynamicObject finalizationRegistryConstructor;
    private final DynamicObject finalizationRegistryPrototype;
    private final DynamicObject iteratorPrototype;
    private final DynamicObject arrayIteratorPrototype;
    private final DynamicObject setIteratorPrototype;
    private final DynamicObject mapIteratorPrototype;
    private final DynamicObject segmentsPrototype;
    private final DynamicObject segmentIteratorPrototype;
    private final DynamicObject stringIteratorPrototype;
    private final DynamicObject regExpStringIteratorPrototype;
    private final DynamicObject enumerateIteratorPrototype;
    private final DynamicObject forInIteratorPrototype;
    private final DynamicObject generatorFunctionConstructor;
    private final DynamicObject generatorFunctionPrototype;
    private final DynamicObject generatorObjectPrototype;
    private final DynamicObject asyncFunctionConstructor;
    private final DynamicObject asyncFunctionPrototype;
    private final DynamicObject asyncIteratorPrototype;
    private final DynamicObject asyncFromSyncIteratorPrototype;
    private final DynamicObject asyncGeneratorObjectPrototype;
    private final DynamicObject asyncGeneratorFunctionConstructor;
    private final DynamicObject asyncGeneratorFunctionPrototype;
    private final DynamicObject throwerFunction;
    private final Accessor throwerAccessor;
    private final DynamicObject promiseConstructor;
    private final DynamicObject promisePrototype;
    private DynamicObject promiseAllFunctionObject;
    private final DynamicObject ordinaryHasInstanceFunction;
    @CompilerDirectives.CompilationFinal
    private DynamicObject javaPackageToPrimitiveFunction;
    private final DynamicObject arrayProtoValuesIterator;
    @CompilerDirectives.CompilationFinal
    private DynamicObject typedArrayConstructor;
    @CompilerDirectives.CompilationFinal
    private DynamicObject typedArrayPrototype;
    private DynamicObject preinitIntlObject;
    private DynamicObject preinitConsoleBuiltinObject;
    private DynamicObject preinitPerformanceObject;
    private volatile Map<Object, DynamicObject> templateRegistry;
    private final DynamicObject globalScope;
    private final DynamicObject scriptEngineImportScope;
    @CompilerDirectives.CompilationFinal
    private TopScopeObject topScope;
    private TruffleLanguage.Env truffleLanguageEnv;
    private boolean preparingStackTrace;
    private Object embedderData;
    private Object staticRegexResult;
    private String staticRegexResultInputString = "";
    private Object staticRegexResultCompiledRegex;
    private boolean staticRegexResultInvalidated;
    private long staticRegexResultFromIndex;
    private String staticRegexResultOriginalInputString;
    private final Object wasmTableAlloc;
    private final Object wasmTableGrow;
    private final Object wasmTableRead;
    private final Object wasmTableWrite;
    private final Object wasmTableLength;
    private final Object wasmFuncType;
    private final Object wasmMemAlloc;
    private final Object wasmMemGrow;
    private final Object wasmMemAsByteBuffer;
    private final Object wasmGlobalAlloc;
    private final Object wasmGlobalRead;
    private final Object wasmGlobalWrite;
    private final Object wasmModuleDecode;
    private final Object wasmModuleInstantiate;
    private final Object wasmModuleValidate;
    private final Object wasmModuleExports;
    private final Object wasmModuleImports;
    private final Object wasmCustomSections;
    private final Object wasmInstanceExport;
    private final Object wasmEmbedderDataGet;
    private final Object wasmEmbedderDataSet;
    private final DynamicObject webAssemblyObject;
    private final DynamicObject webAssemblyGlobalConstructor;
    private final DynamicObject webAssemblyGlobalPrototype;
    private final DynamicObject webAssemblyInstanceConstructor;
    private final DynamicObject webAssemblyInstancePrototype;
    private final DynamicObject webAssemblyMemoryConstructor;
    private final DynamicObject webAssemblyMemoryPrototype;
    private final DynamicObject webAssemblyModuleConstructor;
    private final DynamicObject webAssemblyModulePrototype;
    private final DynamicObject webAssemblyTableConstructor;
    private final DynamicObject webAssemblyTablePrototype;
    private final JSWebAssemblyMemoryGrowCallback webAssemblyMemoryGrowCallback;
    private final DynamicObject foreignIterablePrototype;
    private ZoneId localTimeZoneId;
    private TimeZone localTimeZone;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormat;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormatBeforeYear0;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormatAfterYear9999;
    @CompilerDirectives.CompilationFinal
    private DateFormat jsDateFormatISO;
    private DateFormat jsShortDateFormat;
    private DateFormat jsShortDateLocalFormat;
    private DateFormat jsShortTimeFormat;
    private DateFormat jsShortTimeLocalFormat;
    private DateFormat jsDateToStringFormat;
    public static final long NANOSECONDS_PER_MILLISECOND = 1000000L;
    private SplittableRandom random;
    private long nanoToZeroTimeOffset;
    private long nanoToCurrentTimeOffset;
    private long lastFuzzyTime = Long.MIN_VALUE;
    private OutputStream outputStream;
    private OutputStream errorStream;
    private PrintWriterWrapper outputWriter;
    private PrintWriterWrapper errorWriter;
    private final JSConsoleUtil consoleUtil;
    private JSModuleLoader moduleLoader;
    private long lastAsyncEvaluationOrder;
    @CompilerDirectives.CompilationFinal
    private JSAgent agent;
    private List<JSRealm> realmList;
    private final JSRealm parentRealm;
    private JSRealm currentRealm;
    private JSRealm v8RealmCurrent = this;
    Object v8RealmShared = Undefined.instance;
    private JavaScriptBaseNode callNode;
    private final Map<TruffleFile, DynamicObject> commonJSRequireCache;
    private final SimpleArrayList<Object> joinStack = new SimpleArrayList();
    private Map<Source, Object> compiledRegexCache;
    private Object customEsmPathMappingCallback;
    private KingScriptEngine engine;
    private static final String REALM_SHARED_NAME = "shared";
    private static final PropertyProxy REALM_SHARED_PROXY = new RealmSharedPropertyProxy();

    protected JSRealm(JSContext context, TruffleLanguage.Env env) {
        this(context, env, null);
    }

    protected JSRealm(JSContext context, TruffleLanguage.Env env, JSRealm parentRealm) {
        boolean es12;
        boolean es9;
        boolean es8;
        boolean es6;
        this.context = context;
        this.truffleLanguageEnv = env;
        this.parentRealm = parentRealm;
        if (parentRealm == null) {
            this.currentRealm = this;
        } else {
            this.currentRealm = null;
            this.agent = parentRealm.agent;
            if (context.getContextOptions().isV8RealmBuiltin()) {
                JSRealm topLevelRealm = parentRealm;
                while (topLevelRealm.parentRealm != null) {
                    topLevelRealm = topLevelRealm.parentRealm;
                }
                topLevelRealm.addToRealmList(this);
            }
        }
        this.objectPrototype = JSObjectPrototype.create((JSContext)context);
        this.functionPrototype = JSFunction.createFunctionPrototype((JSRealm)this, (DynamicObject)this.objectPrototype);
        this.objectFactories = context.newObjectFactoryRealmData();
        this.throwerFunction = this.createThrowerFunction();
        this.throwerAccessor = new Accessor(this.throwerFunction, this.throwerFunction);
        if (context.isOptionAnnexB()) {
            JSRealm.putProtoAccessorProperty(this);
        }
        this.globalObject = JSGlobal.create((JSRealm)this, (DynamicObject)this.objectPrototype);
        this.globalScope = JSGlobal.createGlobalScope((JSContext)context);
        this.scriptEngineImportScope = context.getContextOptions().isScriptEngineGlobalScopeImport() ? JSOrdinary.createWithNullPrototypeInit((JSContext)context) : null;
        this.topScope = this.createTopScope();
        this.objectConstructor = JSRealm.createObjectConstructor(this, this.objectPrototype);
        JSObjectUtil.putDataProperty((JSContext)context, (DynamicObject)this.objectPrototype, (Object)"constructor", (Object)this.objectConstructor, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)this.objectPrototype, (JSBuiltinsContainer)JSObjectPrototype.BUILTINS);
        this.functionConstructor = JSFunction.createFunctionConstructor((JSRealm)this);
        JSFunction.fillFunctionPrototype((JSRealm)this);
        this.applyFunctionObject = JSDynamicObject.getOrNull((DynamicObject)this.getFunctionPrototype(), (Object)"apply");
        this.callFunctionObject = JSDynamicObject.getOrNull((DynamicObject)this.getFunctionPrototype(), (Object)"call");
        JSConstructor ctor = JSArray.createConstructor((JSRealm)this);
        this.arrayConstructor = ctor.getFunctionObject();
        this.arrayPrototype = ctor.getPrototype();
        ctor = JSBoolean.createConstructor((JSRealm)this);
        this.booleanConstructor = ctor.getFunctionObject();
        this.booleanPrototype = ctor.getPrototype();
        ctor = JSNumber.createConstructor((JSRealm)this);
        this.numberConstructor = ctor.getFunctionObject();
        this.numberPrototype = ctor.getPrototype();
        ctor = JSString.createConstructor((JSRealm)this);
        this.stringConstructor = ctor.getFunctionObject();
        this.stringPrototype = ctor.getPrototype();
        ctor = JSRegExp.createConstructor((JSRealm)this);
        this.regExpConstructor = ctor.getFunctionObject();
        this.regExpPrototype = ctor.getPrototype();
        ctor = JSDate.createConstructor((JSRealm)this);
        this.dateConstructor = ctor.getFunctionObject();
        this.datePrototype = ctor.getPrototype();
        this.initialRegExpPrototypeShape = this.regExpPrototype.getShape();
        boolean bl = es6 = context.getContextOptions().getEcmaScriptVersion() >= 6;
        if (es6) {
            ctor = JSSymbol.createConstructor((JSRealm)this);
            this.symbolConstructor = ctor.getFunctionObject();
            this.symbolPrototype = ctor.getPrototype();
            ctor = JSMap.createConstructor((JSRealm)this);
            this.mapConstructor = ctor.getFunctionObject();
            this.mapPrototype = ctor.getPrototype();
            ctor = JSSet.createConstructor((JSRealm)this);
            this.setConstructor = ctor.getFunctionObject();
            this.setPrototype = ctor.getPrototype();
            ctor = JSWeakMap.createConstructor((JSRealm)this);
            this.weakMapConstructor = ctor.getFunctionObject();
            this.weakMapPrototype = ctor.getPrototype();
            ctor = JSWeakSet.createConstructor((JSRealm)this);
            this.weakSetConstructor = ctor.getFunctionObject();
            this.weakSetPrototype = ctor.getPrototype();
            ctor = JSProxy.createConstructor((JSRealm)this);
            this.proxyConstructor = ctor.getFunctionObject();
            this.proxyPrototype = ctor.getPrototype();
            ctor = JSPromise.createConstructor((JSRealm)this);
            this.promiseConstructor = ctor.getFunctionObject();
            this.promisePrototype = ctor.getPrototype();
        } else {
            this.symbolConstructor = null;
            this.symbolPrototype = null;
            this.mapConstructor = null;
            this.mapPrototype = null;
            this.setConstructor = null;
            this.setPrototype = null;
            this.weakMapConstructor = null;
            this.weakMapPrototype = null;
            this.weakSetConstructor = null;
            this.weakSetPrototype = null;
            this.proxyConstructor = null;
            this.proxyPrototype = null;
            this.promiseConstructor = null;
            this.promisePrototype = null;
        }
        this.errorConstructors = new DynamicObject[JSErrorType.errorTypes().length];
        this.errorPrototypes = new DynamicObject[JSErrorType.errorTypes().length];
        this.initializeErrorConstructors();
        ctor = JSError.createCallSiteConstructor((JSRealm)this);
        this.callSiteConstructor = ctor.getFunctionObject();
        this.callSitePrototype = ctor.getPrototype();
        ctor = JSArrayBuffer.createConstructor((JSRealm)this);
        this.arrayBufferConstructor = ctor.getFunctionObject();
        this.arrayBufferPrototype = ctor.getPrototype();
        this.typedArrayConstructors = new DynamicObject[TypedArray.factories((JSContext)context).length];
        this.typedArrayPrototypes = new DynamicObject[TypedArray.factories((JSContext)context).length];
        this.initializeTypedArrayConstructors();
        ctor = JSDataView.createConstructor((JSRealm)this);
        this.dataViewConstructor = ctor.getFunctionObject();
        this.dataViewPrototype = ctor.getPrototype();
        if (context.getContextOptions().isBigInt()) {
            ctor = JSBigInt.createConstructor((JSRealm)this);
            this.bigIntConstructor = ctor.getFunctionObject();
            this.bigIntPrototype = ctor.getPrototype();
        } else {
            this.bigIntConstructor = null;
            this.bigIntPrototype = null;
        }
        this.iteratorPrototype = this.createIteratorPrototype();
        this.arrayIteratorPrototype = es6 ? this.createArrayIteratorPrototype() : null;
        this.setIteratorPrototype = es6 ? this.createSetIteratorPrototype() : null;
        this.mapIteratorPrototype = es6 ? this.createMapIteratorPrototype() : null;
        this.stringIteratorPrototype = es6 ? this.createStringIteratorPrototype() : null;
        this.regExpStringIteratorPrototype = context.getContextOptions().getEcmaScriptVersion() >= 10 ? this.createRegExpStringIteratorPrototype() : null;
        ctor = JSCollator.createConstructor((JSRealm)this);
        this.collatorConstructor = ctor.getFunctionObject();
        this.collatorPrototype = ctor.getPrototype();
        ctor = JSNumberFormat.createConstructor((JSRealm)this);
        this.numberFormatConstructor = ctor.getFunctionObject();
        this.numberFormatPrototype = ctor.getPrototype();
        ctor = JSDateTimeFormat.createConstructor((JSRealm)this);
        this.dateTimeFormatConstructor = ctor.getFunctionObject();
        this.dateTimeFormatPrototype = ctor.getPrototype();
        ctor = JSPluralRules.createConstructor((JSRealm)this);
        this.pluralRulesConstructor = ctor.getFunctionObject();
        this.pluralRulesPrototype = ctor.getPrototype();
        ctor = JSListFormat.createConstructor((JSRealm)this);
        this.listFormatConstructor = ctor.getFunctionObject();
        this.listFormatPrototype = ctor.getPrototype();
        ctor = JSRelativeTimeFormat.createConstructor((JSRealm)this);
        this.relativeTimeFormatConstructor = ctor.getFunctionObject();
        this.relativeTimeFormatPrototype = ctor.getPrototype();
        ctor = JSSegmenter.createConstructor((JSRealm)this);
        this.segmenterConstructor = ctor.getFunctionObject();
        this.segmenterPrototype = ctor.getPrototype();
        this.segmentsPrototype = JSSegmenter.createSegmentsPrototype((JSRealm)this);
        this.segmentIteratorPrototype = JSSegmenter.createSegmentIteratorPrototype((JSRealm)this);
        ctor = JSDisplayNames.createConstructor((JSRealm)this);
        this.displayNamesConstructor = ctor.getFunctionObject();
        this.displayNamesPrototype = ctor.getPrototype();
        ctor = JSLocale.createConstructor((JSRealm)this);
        this.localeConstructor = ctor.getFunctionObject();
        this.localePrototype = ctor.getPrototype();
        if (es6) {
            ctor = JSFunction.createGeneratorFunctionConstructor((JSRealm)this);
            this.generatorFunctionConstructor = ctor.getFunctionObject();
            this.generatorFunctionPrototype = ctor.getPrototype();
            this.generatorObjectPrototype = (DynamicObject)JSDynamicObject.getOrNull((DynamicObject)this.generatorFunctionPrototype, (Object)"prototype");
        } else {
            this.generatorFunctionConstructor = null;
            this.generatorFunctionPrototype = null;
            this.generatorObjectPrototype = null;
        }
        this.enumerateIteratorPrototype = JSFunction.createEnumerateIteratorPrototype((JSRealm)this);
        this.forInIteratorPrototype = JSFunction.createForInIteratorPrototype((JSRealm)this);
        this.arrayProtoValuesIterator = (DynamicObject)JSDynamicObject.getOrDefault((DynamicObject)this.getArrayPrototype(), (Object)Symbol.SYMBOL_ITERATOR, (Object)Undefined.instance);
        if (context.isOptionSharedArrayBuffer()) {
            ctor = JSSharedArrayBuffer.createConstructor((JSRealm)this);
            this.sharedArrayBufferConstructor = ctor.getFunctionObject();
            this.sharedArrayBufferPrototype = ctor.getPrototype();
        } else {
            this.sharedArrayBufferConstructor = null;
            this.sharedArrayBufferPrototype = null;
        }
        this.mathObject = JSMath.create((JSRealm)this);
        boolean bl2 = es8 = context.getContextOptions().getEcmaScriptVersion() >= 8;
        if (es8) {
            ctor = JSFunction.createAsyncFunctionConstructor((JSRealm)this);
            this.asyncFunctionConstructor = ctor.getFunctionObject();
            this.asyncFunctionPrototype = ctor.getPrototype();
        } else {
            this.asyncFunctionConstructor = null;
            this.asyncFunctionPrototype = null;
        }
        boolean bl3 = es9 = context.getContextOptions().getEcmaScriptVersion() >= 9;
        if (es9) {
            this.asyncIteratorPrototype = JSFunction.createAsyncIteratorPrototype((JSRealm)this);
            this.asyncFromSyncIteratorPrototype = JSFunction.createAsyncFromSyncIteratorPrototype((JSRealm)this);
            ctor = JSFunction.createAsyncGeneratorFunctionConstructor((JSRealm)this);
            this.asyncGeneratorFunctionConstructor = ctor.getFunctionObject();
            this.asyncGeneratorFunctionPrototype = ctor.getPrototype();
            this.asyncGeneratorObjectPrototype = (DynamicObject)JSDynamicObject.getOrNull((DynamicObject)this.asyncGeneratorFunctionPrototype, (Object)"prototype");
        } else {
            this.asyncIteratorPrototype = null;
            this.asyncFromSyncIteratorPrototype = null;
            this.asyncGeneratorFunctionConstructor = null;
            this.asyncGeneratorFunctionPrototype = null;
            this.asyncGeneratorObjectPrototype = null;
        }
        boolean bl4 = es12 = context.getContextOptions().getEcmaScriptVersion() >= 12;
        if (es12) {
            ctor = JSWeakRef.createConstructor((JSRealm)this);
            this.weakRefConstructor = ctor.getFunctionObject();
            this.weakRefPrototype = ctor.getPrototype();
            ctor = JSFinalizationRegistry.createConstructor((JSRealm)this);
            this.finalizationRegistryConstructor = ctor.getFunctionObject();
            this.finalizationRegistryPrototype = ctor.getPrototype();
        } else {
            this.weakRefConstructor = null;
            this.weakRefPrototype = null;
            this.finalizationRegistryConstructor = null;
            this.finalizationRegistryPrototype = null;
        }
        this.ordinaryHasInstanceFunction = JSFunction.createOrdinaryHasInstanceFunction((JSRealm)this);
        boolean nashornCompat = context.isOptionNashornCompatibilityMode();
        if (nashornCompat) {
            ctor = JSAdapter.createConstructor((JSRealm)this);
            this.jsAdapterConstructor = ctor.getFunctionObject();
            this.jsAdapterPrototype = ctor.getPrototype();
            ctor = JavaImporter.createConstructor((JSRealm)this);
            this.javaImporterConstructor = ctor.getFunctionObject();
            this.javaImporterPrototype = ctor.getPrototype();
        } else {
            this.jsAdapterConstructor = null;
            this.jsAdapterPrototype = null;
            this.javaImporterConstructor = null;
            this.javaImporterPrototype = null;
        }
        this.outputStream = System.out;
        this.errorStream = System.err;
        this.outputWriter = new PrintWriterWrapper(this.outputStream, true);
        this.errorWriter = new PrintWriterWrapper(this.errorStream, true);
        this.consoleUtil = new JSConsoleUtil();
        this.commonJSRequireCache = context.getContextOptions().isCommonJSRequire() ? new HashMap<TruffleFile, DynamicObject>() : null;
        if (context.getContextOptions().isWebAssembly()) {
            Object wasmMemSetGrowCallback;
            if (!this.isWasmAvailable()) {
                throw new IllegalStateException("WebAssembly API enabled but wasm language cannot be accessed!");
            }
            LanguageInfo wasmLanguageInfo = (LanguageInfo)this.truffleLanguageEnv.getInternalLanguages().get("wasm");
            this.truffleLanguageEnv.initializeLanguage(wasmLanguageInfo);
            Object wasmObject = this.truffleLanguageEnv.importSymbol("WebAssembly");
            try {
                InteropLibrary wasmInterop = InteropLibrary.getUncached((Object)wasmObject);
                this.wasmTableAlloc = wasmInterop.readMember(wasmObject, "table_alloc");
                this.wasmTableGrow = wasmInterop.readMember(wasmObject, "table_grow");
                this.wasmTableRead = wasmInterop.readMember(wasmObject, "table_read");
                this.wasmTableWrite = wasmInterop.readMember(wasmObject, "table_write");
                this.wasmTableLength = wasmInterop.readMember(wasmObject, "table_size");
                this.wasmFuncType = wasmInterop.readMember(wasmObject, "func_type");
                this.wasmMemAlloc = wasmInterop.readMember(wasmObject, "mem_alloc");
                this.wasmMemGrow = wasmInterop.readMember(wasmObject, "mem_grow");
                this.wasmGlobalAlloc = wasmInterop.readMember(wasmObject, "global_alloc");
                this.wasmGlobalRead = wasmInterop.readMember(wasmObject, "global_read");
                this.wasmGlobalWrite = wasmInterop.readMember(wasmObject, "global_write");
                this.wasmModuleDecode = wasmInterop.readMember(wasmObject, "module_decode");
                this.wasmModuleInstantiate = wasmInterop.readMember(wasmObject, "module_instantiate");
                this.wasmModuleValidate = wasmInterop.readMember(wasmObject, "module_validate");
                this.wasmModuleExports = wasmInterop.readMember(wasmObject, "module_exports");
                this.wasmModuleImports = wasmInterop.readMember(wasmObject, "module_imports");
                this.wasmCustomSections = wasmInterop.readMember(wasmObject, "custom_sections");
                this.wasmInstanceExport = wasmInterop.readMember(wasmObject, "instance_export");
                wasmMemSetGrowCallback = wasmInterop.readMember(wasmObject, "mem_set_grow_callback");
                this.wasmEmbedderDataGet = wasmInterop.readMember(wasmObject, "embedder_data_get");
                this.wasmEmbedderDataSet = wasmInterop.readMember(wasmObject, "embedder_data_set");
                this.wasmMemAsByteBuffer = wasmInterop.readMember(wasmObject, "mem_as_byte_buffer");
            }
            catch (InteropException ex) {
                throw Errors.shouldNotReachHere((Throwable)ex);
            }
            this.webAssemblyObject = JSWebAssembly.create((JSRealm)this);
            ctor = JSWebAssemblyModule.createConstructor((JSRealm)this);
            this.webAssemblyModuleConstructor = ctor.getFunctionObject();
            this.webAssemblyModulePrototype = ctor.getPrototype();
            ctor = JSWebAssemblyInstance.createConstructor((JSRealm)this);
            this.webAssemblyInstanceConstructor = ctor.getFunctionObject();
            this.webAssemblyInstancePrototype = ctor.getPrototype();
            ctor = JSWebAssemblyMemory.createConstructor((JSRealm)this);
            this.webAssemblyMemoryConstructor = ctor.getFunctionObject();
            this.webAssemblyMemoryPrototype = ctor.getPrototype();
            ctor = JSWebAssemblyTable.createConstructor((JSRealm)this);
            this.webAssemblyTableConstructor = ctor.getFunctionObject();
            this.webAssemblyTablePrototype = ctor.getPrototype();
            ctor = JSWebAssemblyGlobal.createConstructor((JSRealm)this);
            this.webAssemblyGlobalConstructor = ctor.getFunctionObject();
            this.webAssemblyGlobalPrototype = ctor.getPrototype();
            this.webAssemblyMemoryGrowCallback = new JSWebAssemblyMemoryGrowCallback(this, wasmMemSetGrowCallback);
        } else {
            this.wasmTableAlloc = null;
            this.wasmTableGrow = null;
            this.wasmTableRead = null;
            this.wasmTableWrite = null;
            this.wasmTableLength = null;
            this.wasmFuncType = null;
            this.wasmMemAlloc = null;
            this.wasmMemGrow = null;
            this.wasmMemAsByteBuffer = null;
            this.wasmGlobalAlloc = null;
            this.wasmGlobalRead = null;
            this.wasmGlobalWrite = null;
            this.wasmModuleDecode = null;
            this.wasmModuleInstantiate = null;
            this.wasmModuleValidate = null;
            this.wasmModuleExports = null;
            this.wasmModuleImports = null;
            this.wasmCustomSections = null;
            this.wasmInstanceExport = null;
            this.wasmEmbedderDataGet = null;
            this.wasmEmbedderDataSet = null;
            this.webAssemblyObject = null;
            this.webAssemblyGlobalConstructor = null;
            this.webAssemblyGlobalPrototype = null;
            this.webAssemblyInstanceConstructor = null;
            this.webAssemblyInstancePrototype = null;
            this.webAssemblyMemoryConstructor = null;
            this.webAssemblyMemoryPrototype = null;
            this.webAssemblyModuleConstructor = null;
            this.webAssemblyModulePrototype = null;
            this.webAssemblyTableConstructor = null;
            this.webAssemblyTablePrototype = null;
            this.webAssemblyMemoryGrowCallback = null;
        }
        this.foreignIterablePrototype = this.createForeignIterablePrototype();
    }

    private void initializeTypedArrayConstructors() {
        JSConstructor taConst = JSArrayBufferView.createTypedArrayConstructor((JSRealm)this);
        this.typedArrayConstructor = taConst.getFunctionObject();
        this.typedArrayPrototype = taConst.getPrototype();
        for (TypedArrayFactory factory : TypedArray.factories((JSContext)this.context)) {
            JSConstructor constructor = JSArrayBufferView.createConstructor((JSRealm)this, (TypedArrayFactory)factory, (JSConstructor)taConst);
            this.typedArrayConstructors[factory.getFactoryIndex()] = constructor.getFunctionObject();
            this.typedArrayPrototypes[factory.getFactoryIndex()] = constructor.getPrototype();
        }
    }

    private void initializeErrorConstructors() {
        for (JSErrorType type : JSErrorType.errorTypes()) {
            JSConstructor errorConstructor = JSError.createErrorConstructor((JSRealm)this, (JSErrorType)type);
            this.errorConstructors[type.ordinal()] = errorConstructor.getFunctionObject();
            this.errorPrototypes[type.ordinal()] = errorConstructor.getPrototype();
        }
    }

    public final JSContext getContext() {
        return this.context;
    }

    public static JSRealm getMain(Node node) {
        return (JSRealm)REFERENCE.get(node);
    }

    public static JSRealm get(Node node) {
        JSRealm mainRealm = (JSRealm)REFERENCE.get(node);
        KingScriptChanges.fixed("fix null");
        if (mainRealm == null) {
            return null;
        }
        if (CompilerDirectives.inCompiledCode()) {
            if (CompilerDirectives.isPartialEvaluationConstant((Object)node) && node != null && JavaScriptLanguage.get(node).getJSContext().isSingleRealm()) {
                assert (mainRealm == mainRealm.currentRealm);
                return mainRealm;
            }
        } else assert (mainRealm.currentRealm == mainRealm || !JavaScriptLanguage.get(node).getJSContext().isSingleRealm());
        return mainRealm.currentRealm;
    }

    private boolean allowEnterLeave(Node node, JSRealm otherRealm) {
        assert (this.isMainRealm() && JSRealm.getMain(node) == this);
        assert (!JavaScriptLanguage.get(node).getJSContext().isSingleRealm() || this.currentRealm == otherRealm);
        return true;
    }

    public JSRealm enterRealm(Node node, JSRealm childRealm) {
        assert (this.allowEnterLeave(node, childRealm));
        JSRealm prev = this.currentRealm;
        this.currentRealm = childRealm;
        return prev;
    }

    public void leaveRealm(Node node, JSRealm prevRealm) {
        assert (this.allowEnterLeave(node, prevRealm));
        this.currentRealm = prevRealm;
    }

    public static void setCurrentRealm(JSRealm currentRealm) {
        KingScriptChanges.fixed("\u5b9e\u73b0\u5c42\u7ea7\u5d4c\u5957(\u5f15\u64ce\u5b9e\u4f8b\u4ea4\u9519\u8c03\u7528\u9700\u8981enter\u3001leave)");
        JSRealm.getMain(null).currentRealm = currentRealm;
    }

    public final DynamicObject lookupFunction(JSBuiltinsContainer container, String methodName) {
        Builtin builtin = (Builtin)Objects.requireNonNull(container.lookupFunctionByName(methodName), methodName);
        JSFunctionData functionData = builtin.createFunctionData(this.context);
        return JSFunction.create((JSRealm)this, (JSFunctionData)functionData);
    }

    public final Accessor lookupAccessor(JSBuiltinsContainer container, Object key) {
        JSFunctionData functionData;
        Pair pair = container.lookupAccessorByKey(key);
        JSBuiltin getterBuiltin = (JSBuiltin)pair.getLeft();
        JSBuiltin setterBulitin = (JSBuiltin)pair.getRight();
        DynamicObject getterFunction = null;
        DynamicObject setterFunction = null;
        if (getterBuiltin != null) {
            functionData = getterBuiltin.createFunctionData(this.context);
            getterFunction = JSFunction.create((JSRealm)this, (JSFunctionData)functionData);
        }
        if (setterBulitin != null) {
            functionData = setterBulitin.createFunctionData(this.context);
            setterFunction = JSFunction.create((JSRealm)this, (JSFunctionData)functionData);
        }
        return new Accessor(getterFunction, setterFunction);
    }

    public static DynamicObject createObjectConstructor(JSRealm realm, DynamicObject objectPrototype) {
        JSContext context = realm.getContext();
        DynamicObject objectConstructor = realm.lookupFunction(ConstructorBuiltins.BUILTINS, "Object");
        JSObjectUtil.putConstructorPrototypeProperty((JSContext)context, (DynamicObject)objectConstructor, (DynamicObject)objectPrototype);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)realm, (DynamicObject)objectConstructor, (JSBuiltinsContainer)ObjectFunctionBuiltins.BUILTINS);
        if (context.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer((JSRealm)realm, (DynamicObject)objectConstructor, (JSBuiltinsContainer)ObjectFunctionBuiltins.BUILTINS_NASHORN_COMPAT);
        }
        return objectConstructor;
    }

    public final DynamicObject getErrorConstructor(JSErrorType type) {
        return this.errorConstructors[type.ordinal()];
    }

    public final DynamicObject getErrorPrototype(JSErrorType type) {
        return this.errorPrototypes[type.ordinal()];
    }

    public final DynamicObject getGlobalObject() {
        return this.globalObject;
    }

    public final void setGlobalObject(DynamicObject global) {
        this.context.getGlobalObjectPristineAssumption().invalidate();
        this.globalObject = global;
        this.topScope = this.createTopScope();
    }

    private TopScopeObject createTopScope() {
        return new TopScopeObject(new Object[]{this.scriptEngineImportScope, new DynamicScopeWrapper(this.globalScope), this.globalObject});
    }

    public final void dispose() {
        this.globalObject = Undefined.instance;
        this.topScope = TopScopeObject.empty();
    }

    public final DynamicObject getObjectConstructor() {
        return this.objectConstructor;
    }

    public final DynamicObject getObjectPrototype() {
        return this.objectPrototype;
    }

    public final DynamicObject getFunctionConstructor() {
        return this.functionConstructor;
    }

    public final DynamicObject getFunctionPrototype() {
        return this.functionPrototype;
    }

    public final DynamicObject getArrayConstructor() {
        return this.arrayConstructor;
    }

    public final DynamicObject getArrayPrototype() {
        return this.arrayPrototype;
    }

    public final DynamicObject getBooleanConstructor() {
        return this.booleanConstructor;
    }

    public final DynamicObject getBooleanPrototype() {
        return this.booleanPrototype;
    }

    public final DynamicObject getNumberConstructor() {
        return this.numberConstructor;
    }

    public final DynamicObject getNumberPrototype() {
        return this.numberPrototype;
    }

    public final DynamicObject getBigIntConstructor() {
        return this.bigIntConstructor;
    }

    public final DynamicObject getBigIntPrototype() {
        return this.bigIntPrototype;
    }

    public final DynamicObject getStringConstructor() {
        return this.stringConstructor;
    }

    public final DynamicObject getStringPrototype() {
        return this.stringPrototype;
    }

    public final DynamicObject getRegExpConstructor() {
        return this.regExpConstructor;
    }

    public final DynamicObject getRegExpPrototype() {
        return this.regExpPrototype;
    }

    public final DynamicObject getCollatorConstructor() {
        return this.collatorConstructor;
    }

    public final DynamicObject getCollatorPrototype() {
        return this.collatorPrototype;
    }

    public final DynamicObject getNumberFormatConstructor() {
        return this.numberFormatConstructor;
    }

    public final DynamicObject getNumberFormatPrototype() {
        return this.numberFormatPrototype;
    }

    public final DynamicObject getPluralRulesConstructor() {
        return this.pluralRulesConstructor;
    }

    public final DynamicObject getPluralRulesPrototype() {
        return this.pluralRulesPrototype;
    }

    public final DynamicObject getListFormatConstructor() {
        return this.listFormatConstructor;
    }

    public final DynamicObject getListFormatPrototype() {
        return this.listFormatPrototype;
    }

    public final DynamicObject getRelativeTimeFormatConstructor() {
        return this.relativeTimeFormatConstructor;
    }

    public final DynamicObject getRelativeTimeFormatPrototype() {
        return this.relativeTimeFormatPrototype;
    }

    public final DynamicObject getDateTimeFormatConstructor() {
        return this.dateTimeFormatConstructor;
    }

    public final DynamicObject getDateTimeFormatPrototype() {
        return this.dateTimeFormatPrototype;
    }

    public final DynamicObject getDateConstructor() {
        return this.dateConstructor;
    }

    public final DynamicObject getDatePrototype() {
        return this.datePrototype;
    }

    public final DynamicObject getSegmenterConstructor() {
        return this.segmenterConstructor;
    }

    public final DynamicObject getSegmenterPrototype() {
        return this.segmenterPrototype;
    }

    public final DynamicObject getDisplayNamesConstructor() {
        return this.displayNamesConstructor;
    }

    public final DynamicObject getDisplayNamesPrototype() {
        return this.displayNamesPrototype;
    }

    public final DynamicObject getLocaleConstructor() {
        return this.localeConstructor;
    }

    public final DynamicObject getLocalePrototype() {
        return this.localePrototype;
    }

    public final DynamicObject getSymbolConstructor() {
        return this.symbolConstructor;
    }

    public final DynamicObject getSymbolPrototype() {
        return this.symbolPrototype;
    }

    public final DynamicObject getMapConstructor() {
        return this.mapConstructor;
    }

    public final DynamicObject getMapPrototype() {
        return this.mapPrototype;
    }

    public final DynamicObject getSetConstructor() {
        return this.setConstructor;
    }

    public final DynamicObject getSetPrototype() {
        return this.setPrototype;
    }

    public final DynamicObject getWeakRefConstructor() {
        return this.weakRefConstructor;
    }

    public final DynamicObject getWeakRefPrototype() {
        return this.weakRefPrototype;
    }

    public final DynamicObject getFinalizationRegistryConstructor() {
        return this.finalizationRegistryConstructor;
    }

    public final DynamicObject getFinalizationRegistryPrototype() {
        return this.finalizationRegistryPrototype;
    }

    public final DynamicObject getWeakMapConstructor() {
        return this.weakMapConstructor;
    }

    public final DynamicObject getWeakMapPrototype() {
        return this.weakMapPrototype;
    }

    public final DynamicObject getWeakSetConstructor() {
        return this.weakSetConstructor;
    }

    public final DynamicObject getWeakSetPrototype() {
        return this.weakSetPrototype;
    }

    public final Shape getInitialRegExpPrototypeShape() {
        return this.initialRegExpPrototypeShape;
    }

    public final DynamicObject getArrayBufferConstructor() {
        return this.arrayBufferConstructor;
    }

    public final DynamicObject getArrayBufferPrototype() {
        return this.arrayBufferPrototype;
    }

    public final DynamicObject getSharedArrayBufferConstructor() {
        assert (this.context.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferConstructor;
    }

    public final DynamicObject getSharedArrayBufferPrototype() {
        assert (this.context.isOptionSharedArrayBuffer());
        return this.sharedArrayBufferPrototype;
    }

    public final DynamicObject getArrayBufferViewConstructor(TypedArrayFactory factory) {
        return this.typedArrayConstructors[factory.getFactoryIndex()];
    }

    public final DynamicObject getArrayBufferViewPrototype(TypedArrayFactory factory) {
        return this.typedArrayPrototypes[factory.getFactoryIndex()];
    }

    public final DynamicObject getDataViewConstructor() {
        return this.dataViewConstructor;
    }

    public final DynamicObject getDataViewPrototype() {
        return this.dataViewPrototype;
    }

    public final DynamicObject getTypedArrayConstructor() {
        return this.typedArrayConstructor;
    }

    public final DynamicObject getTypedArrayPrototype() {
        return this.typedArrayPrototype;
    }

    public final DynamicObject getRealmBuiltinObject() {
        return this.realmBuiltinObject;
    }

    public final DynamicObject getProxyConstructor() {
        return this.proxyConstructor;
    }

    public final DynamicObject getProxyPrototype() {
        return this.proxyPrototype;
    }

    public final DynamicObject getGeneratorFunctionConstructor() {
        return this.generatorFunctionConstructor;
    }

    public final DynamicObject getGeneratorFunctionPrototype() {
        return this.generatorFunctionPrototype;
    }

    public final DynamicObject getAsyncFunctionConstructor() {
        return this.asyncFunctionConstructor;
    }

    public final DynamicObject getAsyncFunctionPrototype() {
        return this.asyncFunctionPrototype;
    }

    public final DynamicObject getAsyncGeneratorFunctionConstructor() {
        return this.asyncGeneratorFunctionConstructor;
    }

    public final DynamicObject getAsyncGeneratorFunctionPrototype() {
        return this.asyncGeneratorFunctionPrototype;
    }

    public final DynamicObject getEnumerateIteratorPrototype() {
        return this.enumerateIteratorPrototype;
    }

    public final DynamicObject getForInIteratorPrototype() {
        return this.forInIteratorPrototype;
    }

    public final DynamicObject getGeneratorObjectPrototype() {
        return this.generatorObjectPrototype;
    }

    public final DynamicObject getAsyncGeneratorObjectPrototype() {
        return this.asyncGeneratorObjectPrototype;
    }

    public final DynamicObject getJavaImporterConstructor() {
        return this.javaImporterConstructor;
    }

    public final DynamicObject getJavaImporterPrototype() {
        return this.javaImporterPrototype;
    }

    public final DynamicObject getJavaPackageToPrimitiveFunction() {
        assert (this.javaPackageToPrimitiveFunction != null);
        return this.javaPackageToPrimitiveFunction;
    }

    public final Map<Object, DynamicObject> getTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.createTemplateRegistry();
        }
        return this.templateRegistry;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void createTemplateRegistry() {
        if (this.templateRegistry == null) {
            this.templateRegistry = new WeakHashMap<Object, DynamicObject>();
        }
    }

    public final Object getEvalFunctionObject() {
        return this.evalFunctionObject;
    }

    public final Object getApplyFunctionObject() {
        return this.applyFunctionObject;
    }

    public final Object getCallFunctionObject() {
        return this.callFunctionObject;
    }

    public final Object getReflectApplyFunctionObject() {
        return this.reflectApplyFunctionObject;
    }

    public final Object getReflectConstructFunctionObject() {
        return this.reflectConstructFunctionObject;
    }

    public final Object getCommonJSRequireFunctionObject() {
        return this.commonJSRequireFunctionObject;
    }

    public final Object getJsonParseFunctionObject() {
        return this.jsonParseFunctionObject;
    }

    public final DynamicObject getPromiseAllFunctionObject() {
        return this.promiseAllFunctionObject;
    }

    private static void putProtoAccessorProperty(JSRealm realm) {
        JSContext context = realm.getContext();
        DynamicObject getProto = JSFunction.create((JSRealm)realm, (JSFunctionData)context.protoGetterFunctionData);
        DynamicObject setProto = JSFunction.create((JSRealm)realm, (JSFunctionData)context.protoSetterFunctionData);
        JSObjectUtil.putBuiltinAccessorProperty((DynamicObject)realm.getObjectPrototype(), (Object)"__proto__", (DynamicObject)getProto, (DynamicObject)setProto);
    }

    public final DynamicObject getThrowerFunction() {
        assert (this.throwerFunction != null);
        return this.throwerFunction;
    }

    public final Accessor getThrowerAccessor() {
        assert (this.throwerAccessor != null);
        return this.throwerAccessor;
    }

    public DynamicObject getIteratorPrototype() {
        return this.iteratorPrototype;
    }

    public DynamicObject getAsyncIteratorPrototype() {
        return this.asyncIteratorPrototype;
    }

    public DynamicObject getAsyncFromSyncIteratorPrototype() {
        return this.asyncFromSyncIteratorPrototype;
    }

    public DynamicObject getArrayIteratorPrototype() {
        return this.arrayIteratorPrototype;
    }

    public DynamicObject getSetIteratorPrototype() {
        return this.setIteratorPrototype;
    }

    public DynamicObject getMapIteratorPrototype() {
        return this.mapIteratorPrototype;
    }

    public DynamicObject getStringIteratorPrototype() {
        return this.stringIteratorPrototype;
    }

    public DynamicObject getRegExpStringIteratorPrototype() {
        return this.regExpStringIteratorPrototype;
    }

    public DynamicObject getSegmentsPrototype() {
        return this.segmentsPrototype;
    }

    public DynamicObject getSegmentIteratorPrototype() {
        return this.segmentIteratorPrototype;
    }

    private DynamicObject createThrowerFunction() {
        CompilerAsserts.neverPartOfCompilation();
        DynamicObject thrower = JSFunction.create((JSRealm)this, (JSFunctionData)this.context.throwerFunctionData);
        JSObject.preventExtensions((DynamicObject)thrower);
        JSObject.setIntegrityLevel((DynamicObject)thrower, (boolean)true);
        return thrower;
    }

    public DynamicObject getPromiseConstructor() {
        return this.promiseConstructor;
    }

    public DynamicObject getPromisePrototype() {
        return this.promisePrototype;
    }

    public final JSObjectFactory.RealmData getObjectFactories() {
        return this.objectFactories;
    }

    public void setupGlobals() {
        CompilerAsserts.neverPartOfCompilation((String)"do not setup globals from compiled code");
        long time = this.context.getContextOptions().isProfileTime() ? System.nanoTime() : 0L;
        DynamicObject global = this.getGlobalObject();
        this.putGlobalProperty("Object", this.getObjectConstructor());
        this.putGlobalProperty("Function", this.getFunctionConstructor());
        this.putGlobalProperty("Array", this.getArrayConstructor());
        this.putGlobalProperty("String", this.getStringConstructor());
        this.putGlobalProperty("Date", this.getDateConstructor());
        this.putGlobalProperty("Number", this.getNumberConstructor());
        this.putGlobalProperty("Boolean", this.getBooleanConstructor());
        this.putGlobalProperty("RegExp", this.getRegExpConstructor());
        this.putGlobalProperty("Math", this.mathObject);
        this.putGlobalProperty("JSON", JSON.create((JSRealm)this));
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)global, (String)"NaN", (Object)Double.NaN);
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)global, (String)"Infinity", (Object)Double.POSITIVE_INFINITY);
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)global, (String)"undefined", (Object)Undefined.instance);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)global, (JSBuiltinsContainer)GlobalBuiltins.GLOBAL_FUNCTIONS);
        this.evalFunctionObject = JSObject.get((DynamicObject)global, (Object)"eval");
        DynamicObject jsonBuiltin = (DynamicObject)JSObject.get((DynamicObject)global, (Object)"JSON");
        this.jsonParseFunctionObject = JSObject.get((DynamicObject)jsonBuiltin, (Object)"parse");
        boolean webassembly = this.context.getContextOptions().isWebAssembly();
        block4: for (JSErrorType jSErrorType : JSErrorType.errorTypes()) {
            switch (jSErrorType) {
                case CompileError: 
                case LinkError: 
                case RuntimeError: {
                    if (!webassembly) continue block4;
                    JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.webAssemblyObject, (Object)jSErrorType.name(), (Object)this.getErrorConstructor(jSErrorType), (int)JSAttributes.getDefaultNotEnumerable());
                    continue block4;
                }
                case AggregateError: {
                    if (this.context.getEcmaScriptVersion() < 12) continue block4;
                    this.putGlobalProperty(jSErrorType.name(), this.getErrorConstructor(jSErrorType));
                    continue block4;
                }
                default: {
                    this.putGlobalProperty(jSErrorType.name(), this.getErrorConstructor(jSErrorType));
                }
            }
        }
        this.putGlobalProperty("ArrayBuffer", this.getArrayBufferConstructor());
        for (JSErrorType jSErrorType : TypedArray.factories((JSContext)this.context)) {
            this.putGlobalProperty(jSErrorType.getName(), this.getArrayBufferViewConstructor((TypedArrayFactory)jSErrorType));
        }
        this.putGlobalProperty("DataView", this.getDataViewConstructor());
        if (this.context.getContextOptions().isBigInt()) {
            this.putGlobalProperty("BigInt", this.getBigIntConstructor());
        }
        if (this.context.isOptionNashornCompatibilityMode()) {
            this.initGlobalNashornExtensions();
            this.removeNashornIncompatibleBuiltins();
        }
        if (this.context.getContextOptions().isScriptEngineGlobalScopeImport()) {
            String builtin = "importScriptEngineGlobalBindings";
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.getScriptEngineImportScope(), (Object)builtin, (Object)this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, builtin), (int)JSAttributes.notConfigurableNotEnumerableNotWritable());
        }
        if (this.context.getContextOptions().isPolyglotBuiltin() && (this.getEnv().isPolyglotEvalAllowed() || this.getEnv().isPolyglotBindingsAccessAllowed())) {
            this.setupPolyglot();
        }
        if (this.context.isOptionDebugBuiltin()) {
            this.putGlobalProperty(this.context.getContextOptions().getDebugPropertyName(), this.createDebugObject());
        }
        if (this.context.isOptionMleBuiltin()) {
            this.putGlobalProperty(MLE_CLASS_NAME, this.createMleObject());
        }
        if (this.context.getContextOptions().isTest262Mode()) {
            this.putGlobalProperty("$262", JSTest262.create((JSRealm)this));
        }
        if (this.context.getContextOptions().isTestV8Mode()) {
            this.putGlobalProperty("TestV8", JSTestV8.create((JSRealm)this));
        }
        if (this.context.getContextOptions().isV8RealmBuiltin()) {
            this.initRealmBuiltinObject();
        }
        if (this.context.getEcmaScriptVersion() >= 6) {
            Object parseInt = JSObject.get((DynamicObject)global, (Object)"parseInt");
            Object parseFloat = JSObject.get((DynamicObject)global, (Object)"parseFloat");
            this.putProperty(this.getNumberConstructor(), "parseInt", parseInt);
            this.putProperty(this.getNumberConstructor(), "parseFloat", parseFloat);
            this.putGlobalProperty("Map", this.getMapConstructor());
            this.putGlobalProperty("Set", this.getSetConstructor());
            this.putGlobalProperty("WeakMap", this.getWeakMapConstructor());
            this.putGlobalProperty("WeakSet", this.getWeakSetConstructor());
            this.putGlobalProperty("Symbol", this.getSymbolConstructor());
            JSRealm.setupPredefinedSymbols(this.getSymbolConstructor());
            DynamicObject reflectObject = this.createReflect();
            this.putGlobalProperty(REFLECT_CLASS_NAME, reflectObject);
            this.reflectApplyFunctionObject = JSObject.get((DynamicObject)reflectObject, (Object)"apply");
            this.reflectConstructFunctionObject = JSObject.get((DynamicObject)reflectObject, (Object)"construct");
            this.putGlobalProperty("Proxy", this.getProxyConstructor());
            this.putGlobalProperty("Promise", this.getPromiseConstructor());
            this.promiseAllFunctionObject = (DynamicObject)JSObject.get((DynamicObject)this.getPromiseConstructor(), (Object)"all");
        }
        if (this.context.isOptionSharedArrayBuffer()) {
            this.putGlobalProperty(SHARED_ARRAY_BUFFER_CLASS_NAME, this.getSharedArrayBufferConstructor());
        }
        if (this.context.isOptionAtomics()) {
            this.putGlobalProperty(ATOMICS_CLASS_NAME, this.createAtomics());
        }
        if (this.context.getEcmaScriptVersion() >= 10) {
            this.putGlobalProperty("globalThis", global);
        }
        if (this.context.getEcmaScriptVersion() >= 12) {
            this.putGlobalProperty("WeakRef", this.getWeakRefConstructor());
            this.putGlobalProperty("FinalizationRegistry", this.getFinalizationRegistryConstructor());
        }
        if (this.context.getContextOptions().isGraalBuiltin()) {
            this.putGraalObject();
        }
        if (webassembly) {
            this.putGlobalProperty("WebAssembly", this.webAssemblyObject);
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.webAssemblyObject, (Object)JSFunction.getName((DynamicObject)this.webAssemblyGlobalConstructor), (Object)this.webAssemblyGlobalConstructor, (int)JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.webAssemblyObject, (Object)JSFunction.getName((DynamicObject)this.webAssemblyInstanceConstructor), (Object)this.webAssemblyInstanceConstructor, (int)JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.webAssemblyObject, (Object)JSFunction.getName((DynamicObject)this.webAssemblyMemoryConstructor), (Object)this.webAssemblyMemoryConstructor, (int)JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.webAssemblyObject, (Object)JSFunction.getName((DynamicObject)this.webAssemblyModuleConstructor), (Object)this.webAssemblyModuleConstructor, (int)JSAttributes.getDefaultNotEnumerable());
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)this.webAssemblyObject, (Object)JSFunction.getName((DynamicObject)this.webAssemblyTableConstructor), (Object)this.webAssemblyTableConstructor, (int)JSAttributes.getDefaultNotEnumerable());
        }
        if (this.context.getContextOptions().isOperatorOverloading()) {
            JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)global, (JSBuiltinsContainer)OperatorsBuiltins.BUILTINS);
        }
        if (this.context.getContextOptions().isProfileTime()) {
            System.out.println("SetupGlobals: " + (System.nanoTime() - time) / 1000000L);
        }
    }

    private void initGlobalNashornExtensions() {
        assert (this.getContext().isOptionNashornCompatibilityMode());
        this.putGlobalProperty("JSAdapter", this.jsAdapterConstructor);
        this.putGlobalProperty("exit", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "exit"));
        this.putGlobalProperty("quit", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "quit"));
        DynamicObject parseToJSON = this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "parseToJSON");
        this.putGlobalProperty("parseToJSON", parseToJSON);
    }

    private void removeNashornIncompatibleBuiltins() {
        assert (this.getContext().isOptionNashornCompatibilityMode());
        JSObject.delete((DynamicObject)this.typedArrayPrototype, (Object)"join");
    }

    private void addPrintGlobals() {
        if (this.context.getContextOptions().isPrint()) {
            this.putGlobalProperty("print", this.lookupFunction(GlobalBuiltins.GLOBAL_PRINT, "print"));
            this.putGlobalProperty("printErr", this.lookupFunction(GlobalBuiltins.GLOBAL_PRINT, "printErr"));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private void addCommonJSGlobals() {
        if (this.getContext().getContextOptions().isCommonJSRequire()) {
            String cwdOption = this.getContext().getContextOptions().getRequireCwd();
            TruffleFile cwdFile = this.getEnv().getPublicTruffleFile(cwdOption);
            try {
                if (cwdOption != null && !cwdFile.exists(new LinkOption[0])) {
                    throw Errors.createError((String)("Invalid CommonJS root folder: " + cwdOption));
                }
            }
            catch (SecurityException se) {
                throw Errors.createError((String)("Access denied to CommonJS root folder: " + cwdOption));
            }
            DynamicObject requireFunction = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, "require");
            DynamicObject resolveFunction = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, "resolve");
            JSObject.set((DynamicObject)requireFunction, (Object)"resolve", (Object)resolveFunction);
            this.putGlobalProperty("require", requireFunction);
            DynamicObject dirnameGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.dirnameGetter.getName());
            JSObject.defineOwnProperty((DynamicObject)this.getGlobalObject(), (Object)"__dirname", (PropertyDescriptor)PropertyDescriptor.createAccessor((DynamicObject)dirnameGetter, (DynamicObject)Undefined.instance, (boolean)false, (boolean)false));
            DynamicObject filenameGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.filenameGetter.getName());
            JSObject.defineOwnProperty((DynamicObject)this.getGlobalObject(), (Object)"__filename", (PropertyDescriptor)PropertyDescriptor.createAccessor((DynamicObject)filenameGetter, (DynamicObject)Undefined.instance, (boolean)false, (boolean)false));
            DynamicObject moduleGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.globalModuleGetter.getName());
            JSObject.defineOwnProperty((DynamicObject)this.getGlobalObject(), (Object)"module", (PropertyDescriptor)PropertyDescriptor.createAccessor((DynamicObject)moduleGetter, (DynamicObject)Undefined.instance, (boolean)false, (boolean)false));
            DynamicObject exportsGetter = this.lookupFunction(GlobalBuiltins.GLOBAL_COMMONJS_REQUIRE_EXTENSIONS, GlobalCommonJSRequireBuiltins.GlobalRequire.globalExportsGetter.getName());
            JSObject.defineOwnProperty((DynamicObject)this.getGlobalObject(), (Object)"exports", (PropertyDescriptor)PropertyDescriptor.createAccessor((DynamicObject)exportsGetter, (DynamicObject)Undefined.instance, (boolean)false, (boolean)false));
            this.commonJSRequireFunctionObject = requireFunction;
            String commonJSRequireGlobals = this.getContext().getContextOptions().getCommonJSRequireGlobals();
            if (commonJSRequireGlobals != null && !commonJSRequireGlobals.isEmpty()) {
                JSFunction.call((Object[])JSArguments.create((Object)this.commonJSRequireFunctionObject, (Object)this.commonJSRequireFunctionObject, (Object[])new Object[]{commonJSRequireGlobals}));
            }
            Map commonJSRequireBuiltins = this.getContext().getContextOptions().getCommonJSRequireBuiltins();
            for (Map.Entry entry : commonJSRequireBuiltins.entrySet()) {
                String builtinModule = (String)entry.getValue();
                if (builtinModule.endsWith(".mjs")) continue;
                Object object = JSFunction.call((Object[])JSArguments.create((Object)this.commonJSRequireFunctionObject, (Object)this.commonJSRequireFunctionObject, (Object[])new Object[]{builtinModule}));
            }
        }
    }

    private void addLoadGlobals() {
        if (this.getContext().getContextOptions().isLoad()) {
            this.putGlobalProperty("load", this.lookupFunction(GlobalBuiltins.GLOBAL_LOAD, "load"));
            this.putGlobalProperty("loadWithNewGlobal", this.lookupFunction(GlobalBuiltins.GLOBAL_LOAD, "loadWithNewGlobal"));
        }
    }

    private void addPerformanceGlobal() {
        if (this.context.getContextOptions().isPerformance()) {
            this.putGlobalProperty(PERFORMANCE_CLASS_NAME, this.preinitPerformanceObject != null ? this.preinitPerformanceObject : this.createPerformanceObject());
        }
    }

    public void addOptionalGlobals() {
        assert (!this.getEnv().isPreInitialization());
        this.addGlobalGlobal();
        this.addShellGlobals();
        this.addScriptingGlobals();
        this.addIntlGlobal();
        this.addLoadGlobals();
        this.addConsoleGlobals();
        this.addPrintGlobals();
        this.addPerformanceGlobal();
        if (this.isJavaInteropEnabled()) {
            this.setupJavaInterop();
        }
        this.addCommonJSGlobals();
    }

    private void addGlobalGlobal() {
        if (this.getContext().getContextOptions().isGlobalProperty()) {
            this.putGlobalProperty("global", this.getGlobalObject());
        }
    }

    private void addShellGlobals() {
        if (this.getContext().getContextOptions().isShell()) {
            GlobalBuiltins.GLOBAL_SHELL.forEachBuiltin(builtin -> {
                JSFunctionData functionData = builtin.createFunctionData(this.getContext());
                this.putGlobalProperty(builtin.getKey(), JSFunction.create((JSRealm)this, (JSFunctionData)functionData), builtin.getAttributeFlags());
            });
        }
    }

    private void addIntlGlobal() {
        if (this.context.isOptionIntl402()) {
            this.putGlobalProperty("Intl", this.preinitIntlObject != null ? this.preinitIntlObject : this.createIntlObject());
        }
    }

    private DynamicObject createIntlObject() {
        DynamicObject intlObject = JSIntl.create((JSRealm)this);
        DynamicObject collatorFn = this.getCollatorConstructor();
        DynamicObject numberFormatFn = this.getNumberFormatConstructor();
        DynamicObject dateTimeFormatFn = this.getDateTimeFormatConstructor();
        DynamicObject pluralRulesFn = this.getPluralRulesConstructor();
        DynamicObject listFormatFn = this.getListFormatConstructor();
        DynamicObject relativeTimeFormatFn = this.getRelativeTimeFormatConstructor();
        DynamicObject segmenterFn = this.getSegmenterConstructor();
        DynamicObject displayNamesFn = this.getDisplayNamesConstructor();
        DynamicObject localeFn = this.getLocaleConstructor();
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)collatorFn), (Object)collatorFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)numberFormatFn), (Object)numberFormatFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)dateTimeFormatFn), (Object)dateTimeFormatFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)pluralRulesFn), (Object)pluralRulesFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)listFormatFn), (Object)listFormatFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)relativeTimeFormatFn), (Object)relativeTimeFormatFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)segmenterFn), (Object)segmenterFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)displayNamesFn), (Object)displayNamesFn, (int)JSAttributes.getDefaultNotEnumerable());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)intlObject, (Object)JSFunction.getName((DynamicObject)localeFn), (Object)localeFn, (int)JSAttributes.getDefaultNotEnumerable());
        return intlObject;
    }

    private void putGraalObject() {
        DynamicObject graalObject = JSOrdinary.createInit((JSRealm)this);
        int flags = JSAttributes.notConfigurableEnumerableNotWritable();
        int esVersion = this.getContext().getContextOptions().getEcmaScriptVersion();
        esVersion = esVersion > 6 ? esVersion + 2009 : esVersion;
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)graalObject, (Object)"language", (Object)"JavaScript", (int)flags);
        assert (GRAALVM_VERSION != null);
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)graalObject, (Object)"versionGraalVM", (Object)GRAALVM_VERSION, (int)flags);
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)graalObject, (Object)"versionECMAScript", (Object)esVersion, (int)flags);
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)graalObject, (Object)"isGraalRuntime", (Object)JSFunction.create((JSRealm)this, (JSFunctionData)JSRealm.isGraalRuntimeFunction(this.context)), (int)flags);
        this.putGlobalProperty("Graal", graalObject);
    }

    private static JSFunctionData isGraalRuntimeFunction(JSContext context) {
        return context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.IsGraalRuntime, c -> JSFunctionData.createCallOnly((JSContext)context, (CallTarget)new JavaScriptRootNode(context.getLanguage(), null, null){

            public Object execute(VirtualFrame frame) {
                return this.isGraalRuntime();
            }

            @CompilerDirectives.TruffleBoundary
            private boolean isGraalRuntime() {
                return Truffle.getRuntime().getName().contains("Graal");
            }
        }.getCallTarget(), (int)0, (String)"isGraalRuntime"));
    }

    private void putGlobalProperty(Object key, Object value) {
        this.putGlobalProperty(key, value, JSAttributes.getDefaultNotEnumerable());
    }

    private void putGlobalProperty(Object key, Object value, int attributes) {
        JSObjectUtil.putDataProperty((JSContext)this.getContext(), (DynamicObject)this.getGlobalObject(), (Object)key, (Object)value, (int)attributes);
    }

    private void putProperty(DynamicObject receiver, Object key, Object value) {
        JSObjectUtil.putDataProperty((JSContext)this.getContext(), (DynamicObject)receiver, (Object)key, (Object)value, (int)JSAttributes.getDefaultNotEnumerable());
    }

    private static void setupPredefinedSymbols(DynamicObject symbolFunction) {
        JSRealm.putSymbolProperty(symbolFunction, "hasInstance", Symbol.SYMBOL_HAS_INSTANCE);
        JSRealm.putSymbolProperty(symbolFunction, "isConcatSpreadable", Symbol.SYMBOL_IS_CONCAT_SPREADABLE);
        JSRealm.putSymbolProperty(symbolFunction, "iterator", Symbol.SYMBOL_ITERATOR);
        JSRealm.putSymbolProperty(symbolFunction, "asyncIterator", Symbol.SYMBOL_ASYNC_ITERATOR);
        JSRealm.putSymbolProperty(symbolFunction, "match", Symbol.SYMBOL_MATCH);
        JSRealm.putSymbolProperty(symbolFunction, "matchAll", Symbol.SYMBOL_MATCH_ALL);
        JSRealm.putSymbolProperty(symbolFunction, "replace", Symbol.SYMBOL_REPLACE);
        JSRealm.putSymbolProperty(symbolFunction, "search", Symbol.SYMBOL_SEARCH);
        JSRealm.putSymbolProperty(symbolFunction, "species", Symbol.SYMBOL_SPECIES);
        JSRealm.putSymbolProperty(symbolFunction, "split", Symbol.SYMBOL_SPLIT);
        JSRealm.putSymbolProperty(symbolFunction, "toStringTag", Symbol.SYMBOL_TO_STRING_TAG);
        JSRealm.putSymbolProperty(symbolFunction, "toPrimitive", Symbol.SYMBOL_TO_PRIMITIVE);
        JSRealm.putSymbolProperty(symbolFunction, "unscopables", Symbol.SYMBOL_UNSCOPABLES);
    }

    private static void putSymbolProperty(DynamicObject symbolFunction, String name, Symbol symbol) {
        DynamicObjectLibrary.getUncached().putConstant(symbolFunction, (Object)name, (Object)symbol, JSAttributes.notConfigurableNotEnumerableNotWritable());
    }

    public boolean isJavaInteropEnabled() {
        return this.getEnv() != null && this.getEnv().isHostLookupAllowed();
    }

    private void setupJavaInterop() {
        assert (this.isJavaInteropEnabled());
        DynamicObject java = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this);
        JSObjectUtil.putToStringTag((DynamicObject)java, (String)JAVA_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)java, (JSBuiltinsContainer)JavaBuiltins.BUILTINS);
        if (this.context.isOptionNashornCompatibilityMode()) {
            JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)java, (JSBuiltinsContainer)JavaBuiltins.BUILTINS_NASHORN_COMPAT);
        }
        this.putGlobalProperty(JAVA_CLASS_NAME, java);
        if (this.getEnv() != null && this.getEnv().isHostLookupAllowed() && ((Boolean)JSContextOptions.JAVA_PACKAGE_GLOBALS.getValue(this.getEnv().getOptions())).booleanValue()) {
            this.javaPackageToPrimitiveFunction = JavaPackage.createToPrimitiveFunction((JSContext)this.context, (JSRealm)this);
            this.putGlobalProperty("Packages", JavaPackage.createInit((JSRealm)this, (String)""));
            this.putGlobalProperty("java", JavaPackage.createInit((JSRealm)this, (String)"java"));
            this.putGlobalProperty("javafx", JavaPackage.createInit((JSRealm)this, (String)"javafx"));
            this.putGlobalProperty("javax", JavaPackage.createInit((JSRealm)this, (String)"javax"));
            this.putGlobalProperty("com", JavaPackage.createInit((JSRealm)this, (String)"com"));
            this.putGlobalProperty("org", JavaPackage.createInit((JSRealm)this, (String)"org"));
            this.putGlobalProperty("edu", JavaPackage.createInit((JSRealm)this, (String)"edu"));
            if (this.context.isOptionNashornCompatibilityMode()) {
                this.putGlobalProperty("JavaImporter", this.getJavaImporterConstructor());
            }
        }
    }

    private void setupPolyglot() {
        DynamicObject polyglotObject = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)polyglotObject, (JSBuiltinsContainer)PolyglotBuiltins.BUILTINS);
        if (this.getContext().isOptionDebugBuiltin()) {
            JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)polyglotObject, (JSBuiltinsContainer)PolyglotBuiltins.INTERNAL_BUILTINS);
        } else if (this.getContext().getContextOptions().isPolyglotEvalFile()) {
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)polyglotObject, (Object)"evalFile", (Object)this.lookupFunction(PolyglotBuiltins.INTERNAL_BUILTINS, "evalFile"), (int)JSAttributes.getDefaultNotEnumerable());
        }
        this.putGlobalProperty(POLYGLOT_CLASS_NAME, polyglotObject);
    }

    private void addConsoleGlobals() {
        if (this.context.getContextOptions().isConsole()) {
            this.putGlobalProperty("console", this.preinitConsoleBuiltinObject != null ? this.preinitConsoleBuiltinObject : this.createConsoleObject());
        }
    }

    private DynamicObject createConsoleObject() {
        DynamicObject console = JSOrdinary.createInit((JSRealm)this);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)console, (JSBuiltinsContainer)ConsoleBuiltins.BUILTINS);
        return console;
    }

    private DynamicObject createPerformanceObject() {
        DynamicObject obj = JSOrdinary.createInit((JSRealm)this);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)obj, (JSBuiltinsContainer)PerformanceBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createIteratorPrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.getObjectPrototype());
        JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)prototype, (Object)Symbol.SYMBOL_ITERATOR, (Object)JSRealm.createIteratorPrototypeSymbolIteratorFunction(this), (int)JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    private static DynamicObject createIteratorPrototypeSymbolIteratorFunction(JSRealm realm) {
        return JSFunction.create((JSRealm)realm, (JSFunctionData)JSFunctionData.createCallOnly((JSContext)realm.getContext(), (CallTarget)realm.getContext().getSpeciesGetterFunctionCallTarget(), (int)0, (String)"[Symbol.iterator]"));
    }

    private DynamicObject createArrayIteratorPrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)prototype, (JSBuiltinsContainer)ArrayIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag((DynamicObject)prototype, (String)"Array Iterator");
        return prototype;
    }

    private DynamicObject createSetIteratorPrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)prototype, (JSBuiltinsContainer)SetIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag((DynamicObject)prototype, (String)"Set Iterator");
        return prototype;
    }

    private DynamicObject createMapIteratorPrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)prototype, (JSBuiltinsContainer)MapIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag((DynamicObject)prototype, (String)"Map Iterator");
        return prototype;
    }

    private DynamicObject createStringIteratorPrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)prototype, (JSBuiltinsContainer)StringIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag((DynamicObject)prototype, (String)"String Iterator");
        return prototype;
    }

    private DynamicObject createRegExpStringIteratorPrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.iteratorPrototype);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)prototype, (JSBuiltinsContainer)RegExpStringIteratorPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag((DynamicObject)prototype, (String)"RegExp String Iterator");
        return prototype;
    }

    private DynamicObject createForeignIterablePrototype() {
        DynamicObject prototype = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)prototype, (JSBuiltinsContainer)ForeignIterablePrototypeBuiltins.BUILTINS);
        return prototype;
    }

    public DynamicObject getArrayProtoValuesIterator() {
        return this.arrayProtoValuesIterator;
    }

    private DynamicObject createReflect() {
        DynamicObject obj = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.getObjectPrototype());
        JSObjectUtil.putToStringTag((DynamicObject)obj, (String)REFLECT_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)obj, (JSBuiltinsContainer)ReflectBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createAtomics() {
        DynamicObject obj = JSObjectUtil.createOrdinaryPrototypeObject((JSRealm)this, (DynamicObject)this.getObjectPrototype());
        JSObjectUtil.putToStringTag((DynamicObject)obj, (String)ATOMICS_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)obj, (JSBuiltinsContainer)AtomicsBuiltins.BUILTINS);
        return obj;
    }

    public final DynamicObject getCallSiteConstructor() {
        return this.callSiteConstructor;
    }

    public final DynamicObject getCallSitePrototype() {
        return this.callSitePrototype;
    }

    public final DynamicObject getGlobalScope() {
        return this.globalScope;
    }

    public DynamicObject getScriptEngineImportScope() {
        return this.scriptEngineImportScope;
    }

    public Object getTopScopeObject() {
        return this.topScope;
    }

    private void addScriptingGlobals() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getContext().getParserOptions().isScripting()) {
            String timezone = this.getLocalTimeZoneId().getId();
            DynamicObject timezoneObj = JSOrdinary.create((JSContext)this.context, (JSRealm)this);
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)timezoneObj, (Object)"ID", (Object)timezone, (int)JSAttributes.configurableEnumerableWritable());
            DynamicObject optionsObj = JSOrdinary.create((JSContext)this.context, (JSRealm)this);
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)optionsObj, (Object)"_timezone", (Object)timezoneObj, (int)JSAttributes.configurableEnumerableWritable());
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)optionsObj, (Object)"_scripting", (Object)true, (int)JSAttributes.configurableEnumerableWritable());
            JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)optionsObj, (Object)"_compile_only", (Object)false, (int)JSAttributes.configurableEnumerableWritable());
            this.putGlobalProperty("$OPTIONS", optionsObj, JSAttributes.configurableNotEnumerableWritable());
            DynamicObject arguments = JSArray.createConstant((JSContext)this.context, (JSRealm)this, (Object[])this.getEnv().getApplicationArguments());
            this.putGlobalProperty("$ARG", arguments, JSAttributes.configurableNotEnumerableWritable());
            DynamicObject envObj = JSOrdinary.create((JSContext)this.context, (JSRealm)this);
            Map sysenv = this.getEnv().getEnvironment();
            for (Map.Entry entry : sysenv.entrySet()) {
                JSObjectUtil.putDataProperty((JSContext)this.context, (DynamicObject)envObj, entry.getKey(), entry.getValue(), (int)JSAttributes.configurableEnumerableWritable());
            }
            this.putGlobalProperty("$ENV", envObj, JSAttributes.configurableNotEnumerableWritable());
            this.putGlobalProperty("$EXEC", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "exec"));
            this.putGlobalProperty("readFully", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "readFully"));
            this.putGlobalProperty("readLine", this.lookupFunction(GlobalBuiltins.GLOBAL_NASHORN_EXTENSIONS, "readLine"));
            this.putGlobalProperty("$EXIT", Undefined.instance);
            this.putGlobalProperty("$OUT", Undefined.instance);
            this.putGlobalProperty("$ERR", Undefined.instance);
        }
    }

    public void setRealmBuiltinObject(DynamicObject realmBuiltinObject) {
        if (this.realmBuiltinObject == null && realmBuiltinObject != null) {
            this.realmBuiltinObject = realmBuiltinObject;
            this.putGlobalProperty(REALM_BUILTIN_CLASS_NAME, realmBuiltinObject);
        }
    }

    public void initRealmBuiltinObject() {
        assert (this.context.getContextOptions().isV8RealmBuiltin());
        this.setRealmBuiltinObject(this.createRealmBuiltinObject());
    }

    private DynamicObject createRealmBuiltinObject() {
        DynamicObject obj = JSOrdinary.createInit((JSRealm)this);
        JSObjectUtil.putToStringTag((DynamicObject)obj, (String)REALM_BUILTIN_CLASS_NAME);
        JSObjectUtil.putProxyProperty((DynamicObject)obj, (Object)REALM_SHARED_NAME, (PropertyProxy)REALM_SHARED_PROXY, (int)JSAttributes.getDefault());
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)obj, (JSBuiltinsContainer)RealmFunctionBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createDebugObject() {
        DynamicObject obj = JSOrdinary.createInit((JSRealm)this);
        JSObjectUtil.putToStringTag((DynamicObject)obj, (String)DEBUG_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)obj, (JSBuiltinsContainer)DebugBuiltins.BUILTINS);
        return obj;
    }

    private DynamicObject createMleObject() {
        DynamicObject obj = JSOrdinary.createInit((JSRealm)this);
        JSObjectUtil.putToStringTag((DynamicObject)obj, (String)MLE_CLASS_NAME);
        JSObjectUtil.putFunctionsFromContainer((JSRealm)this, (DynamicObject)obj, (JSBuiltinsContainer)MLEBuiltins.BUILTINS);
        return obj;
    }

    private void addStaticRegexResultProperties() {
        if (this.context.isOptionRegexpStaticResultInContextInit()) {
            if (this.context.isOptionNashornCompatibilityMode()) {
                this.putRegExpStaticPropertyAccessor(null, "input");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpMultiLine, "multiline");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastMatch, "lastMatch");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastParen, "lastParen");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLeftContext, "leftContext");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpRightContext, "rightContext");
            } else {
                this.putRegExpStaticPropertyAccessor(null, "input");
                this.putRegExpStaticPropertyAccessor(null, "input", "$_");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastMatch, "lastMatch");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastMatch, "lastMatch", "$&");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastParen, "lastParen");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLastParen, "lastParen", "$+");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLeftContext, "leftContext");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpLeftContext, "leftContext", "$`");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpRightContext, "rightContext");
                this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExpRightContext, "rightContext", "$'");
            }
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$1, "$1");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$2, "$2");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$3, "$3");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$4, "$4");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$5, "$5");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$6, "$6");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$7, "$7");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$8, "$8");
            this.putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey.RegExp$9, "$9");
        }
    }

    private void putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey builtinKey, String getterName) {
        this.putRegExpStaticPropertyAccessor(builtinKey, getterName, getterName);
    }

    private void putRegExpStaticPropertyAccessor(JSContext.BuiltinFunctionKey builtinKey, String getterName, String propertyName) {
        JSDynamicObject setter;
        Pair pair = RegExpBuiltins.BUILTINS.lookupAccessorByKey((Object)getterName);
        JSBuiltin getterBuiltin = (JSBuiltin)pair.getLeft();
        DynamicObject getter = JSFunction.create((JSRealm)this, (JSFunctionData)getterBuiltin.createFunctionData(this.context));
        JSBuiltin setterBuiltin = (JSBuiltin)pair.getRight();
        if (setterBuiltin != null) {
            assert (propertyName.equals("input") || propertyName.equals("$_"));
            setter = JSFunction.create((JSRealm)this, (JSFunctionData)setterBuiltin.createFunctionData(this.context));
        } else if (this.context.isOptionV8CompatibilityModeInContextInit()) {
            String setterName = "set " + getterName;
            JSFunctionData setterData = this.context.getOrCreateBuiltinFunctionData(builtinKey, c -> JSFunctionData.createCallOnly((JSContext)c, (CallTarget)this.context.getEmptyFunctionCallTarget(), (int)1, (String)setterName));
            setter = JSFunction.create((JSRealm)this, (JSFunctionData)setterData);
        } else {
            setter = Undefined.instance;
        }
        int propertyAttributes = this.context.isOptionNashornCompatibilityMode() ? JSAttributes.notConfigurableEnumerableWritable() : JSAttributes.configurableNotEnumerableWritable();
        JSObjectUtil.putBuiltinAccessorProperty((DynamicObject)this.regExpConstructor, (Object)propertyName, (DynamicObject)getter, (DynamicObject)setter, (int)propertyAttributes);
    }

    public void setArguments(Object[] arguments) {
        JSObjectUtil.defineDataProperty((JSContext)this.context, (DynamicObject)this.getGlobalObject(), (Object)ARGUMENTS_NAME, (Object)JSArray.createConstant((JSContext)this.context, (JSRealm)this, (Object[])arguments), (int)(this.context.isOptionV8CompatibilityModeInContextInit() ? JSAttributes.getDefault() : JSAttributes.getDefaultNotEnumerable()));
    }

    public final DynamicObject getOrdinaryHasInstanceFunction() {
        return this.ordinaryHasInstanceFunction;
    }

    public final DynamicObject getJSAdapterConstructor() {
        return this.jsAdapterConstructor;
    }

    public final DynamicObject getJSAdapterPrototype() {
        return this.jsAdapterPrototype;
    }

    public final TruffleLanguage.Env getEnv() {
        return this.truffleLanguageEnv;
    }

    public boolean patchContext(TruffleLanguage.Env newEnv) {
        CompilerAsserts.neverPartOfCompilation();
        Objects.requireNonNull(newEnv, "New env cannot be null.");
        this.truffleLanguageEnv = newEnv;
        this.getContext().setAllocationReporter(newEnv);
        this.getContext().getContextOptions().setOptionValues(newEnv.getOptions());
        if (newEnv.out() != this.getOutputStream()) {
            this.setOutputWriter(null, newEnv.out());
        }
        if (newEnv.err() != this.getErrorStream()) {
            this.setErrorWriter(null, newEnv.err());
        }
        this.addOptionalGlobals();
        this.addArgumentsFromEnv(newEnv);
        if (this.localTimeZoneId != null) {
            this.localTimeZoneId = this.getTimeZoneFromEnv();
        }
        this.initTimeOffsetAndRandom();
        this.addStaticRegexResultProperties();
        return true;
    }

    public void initialize() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getEnv().isPreInitialization()) {
            this.preinitializeObjects();
            return;
        }
        if (this.getEnv().out() != this.getOutputStream()) {
            this.setOutputWriter(null, this.getEnv().out());
        }
        if (this.getEnv().err() != this.getErrorStream()) {
            this.setErrorWriter(null, this.getEnv().err());
        }
        this.addOptionalGlobals();
        this.addArgumentsFromEnv(this.getEnv());
        this.initTimeOffsetAndRandom();
        this.addStaticRegexResultProperties();
    }

    private void preinitializeObjects() {
        this.preinitIntlObject = this.createIntlObject();
        this.preinitConsoleBuiltinObject = this.createConsoleObject();
        this.preinitPerformanceObject = this.createPerformanceObject();
    }

    private void addArgumentsFromEnv(TruffleLanguage.Env newEnv) {
        Object[] applicationArguments = newEnv.getApplicationArguments();
        if (this.context.getContextOptions().isGlobalArguments()) {
            this.setArguments(applicationArguments);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public JSRealm createChildRealm() {
        JSRealm childRealm = this.context.createRealm(this.getEnv(), this);
        childRealm.initialize();
        return childRealm;
    }

    public boolean isPreparingStackTrace() {
        return this.preparingStackTrace;
    }

    public void setPreparingStackTrace(boolean preparingStackTrace) {
        this.preparingStackTrace = preparingStackTrace;
    }

    public final TruffleContext getTruffleContext() {
        return this.getEnv().getContext();
    }

    public final Object getEmbedderData() {
        return this.embedderData;
    }

    public final void setEmbedderData(Object embedderData) {
        this.embedderData = embedderData;
    }

    public Object getStaticRegexResult(JSContext ctx, TRegexUtil.TRegexCompiledRegexAccessor compiledRegexAccessor) {
        CompilerAsserts.partialEvaluationConstant((Object)ctx);
        assert (ctx.isOptionRegexpStaticResult());
        if (this.staticRegexResultCompiledRegex != null && ctx.getRegExpStaticResultUnusedAssumption().isValid()) {
            ctx.getRegExpStaticResultUnusedAssumption().invalidate();
            this.staticRegexResult = compiledRegexAccessor.exec(this.staticRegexResultCompiledRegex, this.staticRegexResultOriginalInputString, this.staticRegexResultFromIndex);
        }
        if (this.staticRegexResult == null) {
            this.staticRegexResult = ctx.getTRegexEmptyResult();
        }
        return this.staticRegexResult;
    }

    public void setStaticRegexResult(JSContext ctx, Object compiledRegex, String input, long fromIndex, Object result) {
        CompilerAsserts.partialEvaluationConstant((Object)ctx);
        assert (ctx.isOptionRegexpStaticResult());
        this.staticRegexResultInvalidated = false;
        this.staticRegexResultCompiledRegex = compiledRegex;
        this.staticRegexResultInputString = input;
        this.staticRegexResultOriginalInputString = input;
        if (ctx.getRegExpStaticResultUnusedAssumption().isValid()) {
            this.staticRegexResultFromIndex = fromIndex;
        } else {
            assert (TRegexUtil.InteropReadBooleanMemberNode.getUncached().execute(result, "isMatch"));
            this.staticRegexResult = result;
        }
    }

    public void invalidateStaticRegexResult() {
        this.staticRegexResultInvalidated = true;
    }

    public boolean isRegexResultInvalidated() {
        return this.staticRegexResultInvalidated;
    }

    public Object getStaticRegexResultCompiledRegex() {
        return this.staticRegexResultCompiledRegex;
    }

    public String getStaticRegexResultInputString() {
        return this.staticRegexResultInputString;
    }

    public void setStaticRegexResultInputString(String inputString) {
        this.staticRegexResultInputString = inputString;
    }

    public String getStaticRegexResultOriginalInputString() {
        return this.staticRegexResultOriginalInputString;
    }

    public OptionValues getOptions() {
        return this.getEnv().getOptions();
    }

    public final PrintWriter getOutputWriter() {
        return this.outputWriter;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final PrintWriter getErrorWriter() {
        return this.errorWriter;
    }

    public final OutputStream getErrorStream() {
        return this.errorStream;
    }

    public final void setOutputWriter(Writer writer, OutputStream stream) {
        if (writer instanceof PrintWriterWrapper) {
            this.outputWriter.setFrom((PrintWriterWrapper)writer);
        } else if (stream != null) {
            this.outputWriter.setDelegate(stream);
        } else {
            this.outputWriter.setDelegate(writer);
        }
        this.outputStream = stream;
    }

    public final void setErrorWriter(Writer writer, OutputStream stream) {
        if (writer instanceof PrintWriterWrapper) {
            this.errorWriter.setFrom((PrintWriterWrapper)writer);
        } else if (stream != null) {
            this.errorWriter.setDelegate(stream);
        } else {
            this.errorWriter.setDelegate(writer);
        }
        this.errorStream = stream;
    }

    public long nanoTime() {
        return this.nanoTime(this.nanoToZeroTimeOffset);
    }

    public long nanoTime(long offset) {
        long last;
        long ns = System.nanoTime() + offset;
        long resolution = this.getContext().getTimerResolution();
        if (resolution > 0L) {
            return ns / resolution * resolution;
        }
        long fuzz = this.random.nextLong(1000000L) + 1L;
        if ((ns -= ns % fuzz) > (last = this.lastFuzzyTime)) {
            this.lastFuzzyTime = ns;
            return ns;
        }
        return last;
    }

    public long currentTimeMillis() {
        return this.nanoTime(this.nanoToCurrentTimeOffset) / 1000000L;
    }

    public JSConsoleUtil getConsoleUtil() {
        return this.consoleUtil;
    }

    public JSModuleLoader getModuleLoader() {
        if (this.moduleLoader == null) {
            this.createModuleLoader();
        }
        return this.moduleLoader;
    }

    @CompilerDirectives.TruffleBoundary
    private synchronized void createModuleLoader() {
        if (this.moduleLoader == null) {
            this.moduleLoader = this.context.getContextOptions().isCommonJSRequire() ? NpmCompatibleESModuleLoader.create((JSRealm)this) : DefaultESModuleLoader.create(this);
        }
    }

    public void setKingScriptEngine(KingScriptEngine engine) {
        if (this.engine != engine) {
            KingScriptChanges.fixed("KingScriptEngine\u5b9e\u4f8b\u7ed1\u5b9aJSRealm");
            this.engine = engine;
        }
    }

    public KingScriptEngine getKingScriptEngine() {
        return this.engine == null ? null : (this.engine.isClosed() ? null : this.engine);
    }

    public final JSAgent getAgent() {
        assert (this.agent != null);
        return this.agent;
    }

    public void setAgent(JSAgent newAgent) {
        assert (newAgent != null) : "Cannot set a null agent!";
        CompilerAsserts.neverPartOfCompilation((String)"Assigning agent to context in compiled code");
        this.agent = newAgent;
    }

    public TimeZone getLocalTimeZone() {
        TimeZone timeZone = this.localTimeZone;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (timeZone == null ? 1 : 0) != 0)) {
            timeZone = this.getICUTimeZoneFromEnv();
        }
        return timeZone;
    }

    @CompilerDirectives.TruffleBoundary
    private TimeZone getICUTimeZoneFromEnv() {
        return IntlUtil.getICUTimeZone((ZoneId)this.getLocalTimeZoneId());
    }

    public ZoneId getLocalTimeZoneId() {
        ZoneId id = this.localTimeZoneId;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (id == null ? 1 : 0) != 0)) {
            this.localTimeZoneId = id = this.getTimeZoneFromEnv();
        }
        return id;
    }

    @CompilerDirectives.TruffleBoundary
    private ZoneId getTimeZoneFromEnv() {
        OptionValues options = this.getEnv().getOptions();
        if (JSContextOptions.TIME_ZONE.hasBeenSet(options)) {
            try {
                return ZoneId.of((String)JSContextOptions.TIME_ZONE.getValue(options));
            }
            catch (DateTimeException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
        return this.getEnv().getTimeZone();
    }

    private void initTimeOffsetAndRandom() {
        assert (!this.getEnv().isPreInitialization());
        this.random = new SplittableRandom();
        this.nanoToZeroTimeOffset = -System.nanoTime();
        this.nanoToCurrentTimeOffset = System.currentTimeMillis() * 1000000L + this.nanoToZeroTimeOffset;
        this.lastFuzzyTime = Long.MIN_VALUE;
    }

    public final SplittableRandom getRandom() {
        return this.random;
    }

    public JSRealm getParent() {
        return this.parentRealm;
    }

    public boolean isMainRealm() {
        return this.getParent() == null;
    }

    public JavaScriptBaseNode getCallNode() {
        return this.callNode;
    }

    public void setCallNode(JavaScriptBaseNode callNode) {
        this.callNode = callNode;
    }

    void initRealmList() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        this.realmList = new ArrayList<JSRealm>();
    }

    void addToRealmList(JSRealm newRealm) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        assert (!this.realmList.contains(newRealm));
        this.realmList.add(newRealm);
    }

    public JSRealm getFromRealmList(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        return 0 <= idx && idx < this.realmList.size() ? this.realmList.get(idx) : null;
    }

    public int getIndexFromRealmList(JSRealm rlm) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        return this.realmList.indexOf(rlm);
    }

    public void removeFromRealmList(int idx) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isMainRealm());
        this.realmList.set(idx, null);
    }

    public JSRealm getCurrentV8Realm() {
        assert (this.isMainRealm());
        return this.v8RealmCurrent;
    }

    public void setCurrentV8Realm(JSRealm realm) {
        assert (this.isMainRealm());
        this.v8RealmCurrent = realm;
    }

    public void registerCustomEsmPathMappingCallback(Object callback) {
        assert (this.context.isOptionMleBuiltin());
        assert (JSRuntime.isCallableForeign(callback));
        this.customEsmPathMappingCallback = callback;
    }

    public String getCustomEsmPathMapping(String refPath, String specifier) {
        CompilerAsserts.neverPartOfCompilation();
        if (this.getContext().isOptionMleBuiltin() && this.customEsmPathMappingCallback != null) {
            Object[] args = new Object[]{JSRuntime.toJSNull(refPath), specifier};
            Object custom = JSInteropUtil.call((Object)this.customEsmPathMappingCallback, (Object[])args);
            InteropLibrary interopLibrary = InteropLibrary.getUncached();
            if (interopLibrary.isString(custom)) {
                try {
                    return interopLibrary.asString(custom);
                }
                catch (UnsupportedMessageException e) {
                    throw Errors.shouldNotReachHere((Throwable)e);
                }
            }
            throw Errors.createError((String)("Custom ESM mapping not found for specifier: " + specifier));
        }
        return null;
    }

    public boolean joinStackPush(Object o, BranchProfile growProfile) {
        InteropLibrary interop = o instanceof JSObject ? null : (InteropLibrary)InteropLibrary.getFactory().getUncached(o);
        for (int i = 0; i < this.joinStack.size(); ++i) {
            Object element = this.joinStack.get(i);
            if (!(interop == null ? o == element : interop.isIdentical(o, element, (InteropLibrary)InteropLibrary.getFactory().getUncached(element)))) continue;
            return false;
        }
        this.joinStack.add(o, growProfile);
        return true;
    }

    public void joinStackPop() {
        this.joinStack.pop();
    }

    public final Map<TruffleFile, DynamicObject> getCommonJSRequireCache() {
        assert (this.context.getContextOptions().isCommonJSRequire());
        return this.commonJSRequireCache;
    }

    private boolean isWasmAvailable() {
        return this.truffleLanguageEnv.isPolyglotBindingsAccessAllowed() && this.truffleLanguageEnv.getInternalLanguages().get("wasm") != null;
    }

    public Object getWASMModuleDecode() {
        return this.wasmModuleDecode;
    }

    public Object getWASMModuleInstantiate() {
        return this.wasmModuleInstantiate;
    }

    public Object getWASMModuleValidate() {
        return this.wasmModuleValidate;
    }

    public Object getWASMModuleExports() {
        return this.wasmModuleExports;
    }

    public Object getWASMModuleImports() {
        return this.wasmModuleImports;
    }

    public Object getWASMCustomSections() {
        return this.wasmCustomSections;
    }

    public Object getWASMTableAlloc() {
        return this.wasmTableAlloc;
    }

    public Object getWASMTableGrow() {
        return this.wasmTableGrow;
    }

    public Object getWASMTableRead() {
        return this.wasmTableRead;
    }

    public Object getWASMTableWrite() {
        return this.wasmTableWrite;
    }

    public Object getWASMTableLength() {
        return this.wasmTableLength;
    }

    public Object getWASMFuncType() {
        return this.wasmFuncType;
    }

    public Object getWASMMemAlloc() {
        return this.wasmMemAlloc;
    }

    public Object getWASMMemGrow() {
        return this.wasmMemGrow;
    }

    public Object getWASMGlobalAlloc() {
        return this.wasmGlobalAlloc;
    }

    public Object getWASMGlobalRead() {
        return this.wasmGlobalRead;
    }

    public Object getWASMGlobalWrite() {
        return this.wasmGlobalWrite;
    }

    public Object getWASMInstanceExport() {
        return this.wasmInstanceExport;
    }

    public Object getWASMEmbedderDataGet() {
        return this.wasmEmbedderDataGet;
    }

    public Object getWASMEmbedderDataSet() {
        return this.wasmEmbedderDataSet;
    }

    public Object getWASMMemAsByteBuffer() {
        return this.wasmMemAsByteBuffer;
    }

    public DynamicObject getWebAssemblyModulePrototype() {
        return this.webAssemblyModulePrototype;
    }

    public DynamicObject getWebAssemblyInstancePrototype() {
        return this.webAssemblyInstancePrototype;
    }

    public DynamicObject getWebAssemblyMemoryPrototype() {
        return this.webAssemblyMemoryPrototype;
    }

    public DynamicObject getWebAssemblyTablePrototype() {
        return this.webAssemblyTablePrototype;
    }

    public DynamicObject getWebAssemblyGlobalPrototype() {
        return this.webAssemblyGlobalPrototype;
    }

    public DynamicObject getForeignIterablePrototype() {
        return this.foreignIterablePrototype;
    }

    public JSWebAssemblyMemoryGrowCallback getWebAssemblyMemoryGrowCallback() {
        return this.webAssemblyMemoryGrowCallback;
    }

    public DateFormat getJSDateISOFormat(double time) {
        long milliseconds = (long)time;
        if (milliseconds < -62167219200000L) {
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.jsDateFormatBeforeYear0 == null ? 1 : 0) != 0)) {
                this.enterOncePerContextBranch();
                this.jsDateFormatBeforeYear0 = this.createDateFormat("uuuuuu-MM-dd'T'HH:mm:ss.SSS'Z'", false);
            }
            return this.jsDateFormatBeforeYear0;
        }
        if (milliseconds >= 253402300800000L) {
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.jsDateFormatAfterYear9999 == null ? 1 : 0) != 0)) {
                this.enterOncePerContextBranch();
                this.jsDateFormatAfterYear9999 = this.createDateFormat("+uuuuuu-MM-dd'T'HH:mm:ss.SSS'Z'", false);
            }
            return this.jsDateFormatAfterYear9999;
        }
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (this.jsDateFormat == null ? 1 : 0) != 0)) {
            this.enterOncePerContextBranch();
            this.jsDateFormat = this.createDateFormat("uuuu-MM-dd'T'HH:mm:ss.SSS'Z'", false);
        }
        return this.jsDateFormat;
    }

    public DateFormat getJSDateUTCFormat() {
        DateFormat dateFormat = this.jsDateFormatISO;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.enterOncePerContextBranch();
            this.jsDateFormatISO = dateFormat = this.createDateFormat("EEE, dd MMM uuuu HH:mm:ss 'GMT'", false);
        }
        return dateFormat;
    }

    public DateFormat getJSShortDateFormat() {
        DateFormat dateFormat = this.jsShortDateFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortDateFormat = dateFormat = this.createDateFormat("EEE MMM dd uuuu", true);
        }
        return dateFormat;
    }

    public DateFormat getJSShortDateLocalFormat() {
        DateFormat dateFormat = this.jsShortDateLocalFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortDateLocalFormat = dateFormat = this.createDateFormat("uuuu-MM-dd", true);
        }
        return dateFormat;
    }

    public DateFormat getJSShortTimeFormat() {
        DateFormat dateFormat = this.jsShortTimeFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortTimeFormat = dateFormat = this.createDateFormat(this.appendTimeZoneNameFormat("HH:mm:ss 'GMT'xx"), true);
        }
        return dateFormat;
    }

    public DateFormat getJSShortTimeLocalFormat() {
        DateFormat dateFormat = this.jsShortTimeLocalFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsShortTimeLocalFormat = dateFormat = this.createDateFormat("HH:mm:ss", true);
        }
        return dateFormat;
    }

    public DateFormat getDateToStringFormat() {
        DateFormat dateFormat = this.jsDateToStringFormat;
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (dateFormat == null ? 1 : 0) != 0)) {
            this.jsDateToStringFormat = dateFormat = this.createDateFormat(this.appendTimeZoneNameFormat("EEE MMM dd uuuu HH:mm:ss 'GMT'xx"), true);
        }
        return dateFormat;
    }

    @CompilerDirectives.TruffleBoundary
    private String appendTimeZoneNameFormat(String format) {
        String timeZoneNameFormat = this.getContext().isOptionV8CompatibilityMode() ? "zzzz" : "z";
        return format + " (" + timeZoneNameFormat + ")";
    }

    @CompilerDirectives.TruffleBoundary
    private DateFormat createDateFormat(String pattern, boolean local) {
        Calendar calendar;
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.US);
        format.setTimeZone(local ? this.getLocalTimeZone() : TimeZone.GMT_ZONE);
        if (!pattern.contains("zzzz")) {
            TimeZoneFormat tzFormat = format.getTimeZoneFormat().cloneAsThawed();
            tzFormat.setTimeZoneNames(TimeZoneNames.getTZDBInstance((ULocale)ULocale.US));
            format.setTimeZoneFormat(tzFormat);
        }
        if ((calendar = format.getCalendar()) instanceof GregorianCalendar) {
            ((GregorianCalendar)calendar).setGregorianChange(new Date(Long.MIN_VALUE));
        }
        return format;
    }

    @CompilerDirectives.TruffleBoundary
    public void setLocalTimeZone(String tzId) {
        TimeZone newTimeZone;
        ZoneId newZoneId;
        try {
            if (tzId != null) {
                newZoneId = ZoneId.of(tzId);
                newTimeZone = IntlUtil.getICUTimeZone((String)tzId);
            } else {
                newZoneId = null;
                newTimeZone = null;
            }
        }
        catch (DateTimeException e) {
            return;
        }
        this.localTimeZoneId = newZoneId;
        this.localTimeZone = newTimeZone;
        this.jsDateToStringFormat = null;
        this.jsShortTimeFormat = null;
        this.jsShortTimeLocalFormat = null;
        this.jsShortDateFormat = null;
        this.jsShortDateLocalFormat = null;
    }

    private void enterOncePerContextBranch() {
        if (CompilerDirectives.isPartialEvaluationConstant((Object)this)) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
        }
    }

    public long nextAsyncEvaluationOrder() {
        return ++this.lastAsyncEvaluationOrder;
    }

    @CompilerDirectives.TruffleBoundary
    public void putCachedCompiledRegex(Source regexSource, Object compiledRegex) {
        int regexCacheSize = this.context.getContextOptions().getRegexCacheSize();
        if (regexCacheSize > 0) {
            if (this.compiledRegexCache == null) {
                this.compiledRegexCache = new LRUCache(regexCacheSize);
            }
            this.compiledRegexCache.put(regexSource, compiledRegex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object getCachedCompiledRegex(Source regexSource) {
        int regexCacheSize = this.context.getContextOptions().getRegexCacheSize();
        if (regexCacheSize > 0 && this.compiledRegexCache != null) {
            return this.compiledRegexCache.get(regexSource);
        }
        return null;
    }

    private static class RealmSharedPropertyProxy
    implements PropertyProxy {
        private RealmSharedPropertyProxy() {
        }

        public Object get(DynamicObject store) {
            return RealmSharedPropertyProxy.topLevelRealm().v8RealmShared;
        }

        public boolean set(DynamicObject store, Object value) {
            RealmSharedPropertyProxy.topLevelRealm().v8RealmShared = value;
            return true;
        }

        private static JSRealm topLevelRealm() {
            return JSRealm.getMain(null);
        }
    }
}

