/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.js.parser.ir.Module;
import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.UserScriptException;
import com.oracle.truffle.js.runtime.objects.JSModuleData;
import com.oracle.truffle.js.runtime.objects.JSModuleLoader;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.ScriptOrModule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystemException;
import java.nio.file.LinkOption;
import java.util.Map;
import java.util.Objects;
import kd.sdk.kingscript.engine.GlobalCache;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.lib.LibFileSystem;
import kd.sdk.kingscript.lib.ScriptPathFormat;
import kd.sdk.kingscript.lib.version.VersionedModuleLoader;
import kd.sdk.kingscript.transpiler.TranspilerEvalContext;

public class DefaultESModuleLoader
implements JSModuleLoader {
    private static final int JS_MODULE_TYPE = 1;
    private static final int JSON_MODULE_TYPE = 2;
    private static final DefaultESModuleLoader SHARED = new DefaultESModuleLoader(null);

    public static DefaultESModuleLoader create(JSRealm realm) {
        return SHARED;
    }

    protected DefaultESModuleLoader(JSRealm realm) {
    }

    private JSRealm getRealm() {
        return JSRealm.get(null);
    }

    private LibFileSystem getLibFileSystem() {
        KingScriptChanges.fixed("\u62e6\u622a\u6a21\u5757\u52a0\u8f7d");
        KingScriptEngine engine = this.getRealm().getKingScriptEngine();
        return engine.unwrap(KingScriptEngineImpl.class).getLibFileSystem();
    }

    protected URI asURI(String specifier) {
        assert (specifier != null);
        if (specifier.indexOf(58) == -1) {
            return null;
        }
        try {
            URI uri = new URI(specifier);
            return uri.getScheme() != null ? uri : null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSModuleRecord resolveImportedModule(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        KingScriptChanges.fixed("\u62e6\u622a\u6a21\u5757\u52a0\u8f7d: loadModule");
        LibFileSystem libFileSystem = this.getLibFileSystem();
        libFileSystem.enterResolveImportedModule(referrer, moduleRequest);
        try {
            JSModuleRecord jSModuleRecord = this.resolveImportedModule0(referrer, moduleRequest);
            return jSModuleRecord;
        }
        finally {
            libFileSystem.leaveResolveImportedModule(referrer, moduleRequest);
        }
    }

    public JSModuleRecord resolveImportedModule0(ScriptOrModule referrer, Module.ModuleRequest moduleRequest) {
        JSRealm realm = this.getRealm();
        try {
            TruffleFile moduleFile;
            KingScriptChanges.fixed("fix graaljs bug\uff1a\u6b63\u786e\u5730import\u6a21\u5757");
            String specifier = moduleRequest.getSpecifier();
            if (specifier.startsWith(".")) {
                String refPath = referrer == null ? null : referrer.getSource().getPath();
                TranspilerEvalContext transCtx = TranspilerEvalContext.get();
                if (transCtx != null && KingScriptEngineImpl.isEvalByContent(refPath)) {
                    refPath = transCtx.getScriptPath();
                }
                TruffleFile refFile = realm.getEnv().getPublicTruffleFile(refPath);
                moduleFile = refFile.resolveSibling(specifier).getCanonicalFile(new LinkOption[0]);
            } else {
                moduleFile = realm.getEnv().getPublicTruffleFile(specifier);
            }
            String canonicalPath = ScriptPathFormat.format(moduleFile.getPath());
            return this.loadModuleFromUrl(referrer, moduleRequest, moduleFile, canonicalPath, realm);
        }
        catch (FileSystemException fsex) {
            String fileName = fsex.getFile();
            if (Objects.equals(fsex.getMessage(), fileName)) {
                String message = "Error reading: " + fileName;
                if (realm.getContext().isOptionV8CompatibilityMode()) {
                    throw UserScriptException.create((Object)message);
                }
                throw Errors.createError((String)message);
            }
            throw Errors.createErrorFromException((Throwable)fsex);
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            throw Errors.createErrorFromException((Throwable)e);
        }
    }

    private boolean bareSpecifierDirectLookup(String specifier) {
        JSRealm realm = this.getRealm();
        JSContextOptions options = realm.getContext().getContextOptions();
        if (options.isEsmBareSpecifierRelativeLookup()) {
            return false;
        }
        KingScriptChanges.fixed("\u6b63\u786e\u652f\u6301import .. from '.'");
        if (specifier.equals(".")) {
            return false;
        }
        return !specifier.startsWith("/") && !specifier.startsWith("./") && !specifier.startsWith("../");
    }

    protected JSModuleRecord loadModuleFromUrl(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, TruffleFile moduleFile, String canonicalPath, JSRealm realm) throws IOException {
        return VersionedModuleLoader.resolveImport(canonicalPath, () -> {
            try {
                return this.loadModuleFromUrl0(referrer, moduleRequest, moduleFile, realm);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private JSModuleRecord loadModuleFromUrl0(ScriptOrModule referrer, Module.ModuleRequest moduleRequest, TruffleFile moduleFile, JSRealm realm) throws IOException {
        JSModuleRecord newModule;
        Source source = Source.newBuilder("js", moduleFile).name(moduleRequest.getSpecifier()).mimeType("application/javascript+module").build();
        Map assertions = moduleRequest.getAssertions();
        int moduleType = this.getModuleType(moduleFile.detectMimeType(), realm);
        String assertedType = (String)assertions.get(JSContext.getTypeImportAssertion());
        if (!DefaultESModuleLoader.doesModuleTypeMatchAssertionType(assertedType, moduleType)) {
            throw Errors.createTypeError((String)"Invalid module type was asserted");
        }
        if (DefaultESModuleLoader.isModuleType(moduleType, 2)) {
            newModule = realm.getContext().getEvaluator().parseJSONModule(realm, source);
        } else {
            JSModuleData parsedModule = realm.getContext().getEvaluator().envParseModule(realm, source);
            newModule = new JSModuleRecord(parsedModule, (JSModuleLoader)this);
        }
        if (referrer instanceof JSModuleRecord) {
            ((JSModuleRecord)referrer).getModuleData().rememberImportedModuleSource(moduleRequest.getSpecifier(), source);
        }
        return newModule;
    }

    private static boolean doesModuleTypeMatchAssertionType(String assertedType, int moduleType) {
        if (assertedType == null) {
            return true;
        }
        if (assertedType.equals("json")) {
            return DefaultESModuleLoader.isModuleType(moduleType, 2);
        }
        return false;
    }

    private int getModuleType(String mimeType, JSRealm realm) {
        if ("application/json".equals(mimeType) && realm.getContext().getContextOptions().isJsonModules()) {
            return 2;
        }
        return 1;
    }

    private static boolean isModuleType(int moduleType, int expectedType) {
        return (moduleType & expectedType) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSModuleRecord loadModule(Source source, JSModuleData moduleData) {
        KingScriptChanges.fixed("\u62e6\u622a\u6a21\u5757\u52a0\u8f7d: loadModule");
        LibFileSystem libFileSystem = this.getLibFileSystem();
        libFileSystem.enterLoadModule(source, moduleData);
        try {
            JSModuleRecord jSModuleRecord = this.loadModule0(source, moduleData);
            return jSModuleRecord;
        }
        finally {
            libFileSystem.leaveLoadModule(source, moduleData);
        }
    }

    public JSModuleRecord loadModule0(Source source, JSModuleData moduleData) {
        KingScriptChanges.fixed("source\u6309\u7248\u672c\u7f13\u5b58");
        Map<String, JSModuleRecord> moduleMap = GlobalCache.get().getESModuleMap();
        return VersionedModuleLoader.loadModule(source, moduleMap, moduleData, this);
    }
}

