/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ContextLocal;
import com.oracle.truffle.api.ContextThreadLocal;
import com.oracle.truffle.api.InstrumentInfo;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.TruffleLocator;
import com.oracle.truffle.api.instrumentation.ContextsListener;
import com.oracle.truffle.api.instrumentation.ThreadsListener;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.polyglot.DefaultLanguageView;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.InstrumentCache;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.OtherContextGuestObject;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInstrument;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotLocals;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.ProcessHandlers;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kd.sdk.kingscript.exception.ScriptException;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.io.FileSystem;
import org.graalvm.polyglot.io.ProcessHandler;

final class EngineAccessor
extends Accessor {
    static final EngineAccessor ACCESSOR = new EngineAccessor();
    static final Accessor.NodeSupport NODES = ACCESSOR.nodeSupport();
    static final Accessor.SourceSupport SOURCE = ACCESSOR.sourceSupport();
    static final Accessor.InstrumentSupport INSTRUMENT = ACCESSOR.instrumentSupport();
    static final Accessor.LanguageSupport LANGUAGE = ACCESSOR.languageSupport();
    static final Accessor.JDKSupport JDKSERVICES = ACCESSOR.jdkSupport();
    static final Accessor.InteropSupport INTEROP = ACCESSOR.interopSupport();
    static final Accessor.ExceptionSupport EXCEPTION = ACCESSOR.exceptionSupport();
    static final Accessor.RuntimeSupport RUNTIME = ACCESSOR.runtimeSupport();
    static final Accessor.HostSupport HOST = ACCESSOR.hostSupport();

    private static List<AbstractClassLoaderSupplier> locatorLoaders() {
        if (ImageInfo.inImageRuntimeCode()) {
            return Collections.emptyList();
        }
        List loaders = TruffleLocator.loaders();
        if (loaders == null) {
            return null;
        }
        ArrayList<AbstractClassLoaderSupplier> suppliers = new ArrayList<AbstractClassLoaderSupplier>(loaders.size());
        for (ClassLoader loader : loaders) {
            suppliers.add(new StrongClassLoaderSupplier(loader));
        }
        return suppliers;
    }

    private static List<AbstractClassLoaderSupplier> defaultLoaders() {
        return Arrays.asList(new StrongClassLoaderSupplier(EngineAccessor.class.getClassLoader()), new StrongClassLoaderSupplier(ClassLoader.getSystemClassLoader()), new WeakClassLoaderSupplier(Thread.currentThread().getContextClassLoader()));
    }

    static List<AbstractClassLoaderSupplier> locatorOrDefaultLoaders() {
        List<AbstractClassLoaderSupplier> loaders = EngineAccessor.locatorLoaders();
        if (loaders == null) {
            loaders = EngineAccessor.defaultLoaders();
        }
        return loaders;
    }

    private EngineAccessor() {
    }

    protected void initializeNativeImageTruffleLocator() {
        super.initializeNativeImageTruffleLocator();
    }

    private static final class WeakClassLoaderSupplier
    extends AbstractClassLoaderSupplier {
        private final Reference<ClassLoader> classLoaderRef;

        WeakClassLoaderSupplier(ClassLoader classLoader) {
            super(classLoader);
            this.classLoaderRef = new WeakReference<ClassLoader>(classLoader);
        }

        @Override
        public ClassLoader get() {
            return this.classLoaderRef.get();
        }
    }

    static final class StrongClassLoaderSupplier
    extends AbstractClassLoaderSupplier {
        private final ClassLoader classLoader;

        StrongClassLoaderSupplier(ClassLoader classLoader) {
            super(classLoader);
            this.classLoader = classLoader;
        }

        @Override
        public ClassLoader get() {
            return this.classLoader;
        }
    }

    static abstract class AbstractClassLoaderSupplier
    implements Supplier<ClassLoader> {
        private final int hashCode;

        AbstractClassLoaderSupplier(ClassLoader loader) {
            this.hashCode = loader == null ? 0 : loader.hashCode();
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AbstractClassLoaderSupplier)) {
                return false;
            }
            AbstractClassLoaderSupplier supplier = (AbstractClassLoaderSupplier)obj;
            return Objects.equals(this.get(), supplier.get());
        }
    }

    static final class EngineImpl
    extends Accessor.EngineSupport {
        private EngineImpl() {
        }

        public boolean isDisposed(Object polyglotLanguageContext) {
            return EngineImpl.getEngine((Object)polyglotLanguageContext).closed;
        }

        public boolean hasCurrentContext() {
            return PolyglotFastThreadLocals.getContext(null) != null;
        }

        public boolean isPolyglotEvalAllowed(Object polyglotLanguageContext) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)polyglotLanguageContext;
            return languageContext.isPolyglotEvalAllowed(null);
        }

        public boolean isPolyglotBindingsAccessAllowed(Object polyglotLanguageContext) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)polyglotLanguageContext;
            return languageContext.isPolyglotBindingsAccessAllowed();
        }

        public ZoneId getTimeZone(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).context.config.getTimeZone();
        }

        public Object getPolyglotEngine(Object polyglotLanguageInstance) {
            return ((PolyglotLanguageInstance)polyglotLanguageInstance).language.engine;
        }

        public Object getDefaultLanguageView(TruffleLanguage<?> truffleLanguage, Object value) {
            return new DefaultLanguageView(truffleLanguage, value);
        }

        public Object getLanguageView(LanguageInfo viewLanguage, Object value) {
            PolyglotLanguage language = (PolyglotLanguage)NODES.getPolyglotLanguage(viewLanguage);
            PolyglotLanguageContext context = PolyglotContextImpl.requireContext().getContextInitialized(language, null);
            return context.getLanguageView(value);
        }

        public Object getScopedView(LanguageInfo viewLanguage, Node location, Frame frame, Object value) {
            PolyglotLanguage language = (PolyglotLanguage)NODES.getPolyglotLanguage(viewLanguage);
            PolyglotLanguageContext context = PolyglotContextImpl.requireContext().getContextInitialized(language, null);
            return context.getScopedView(location, frame, value);
        }

        public LanguageInfo getLanguageInfo(Object polyglotInstrument, Class<? extends TruffleLanguage<?>> languageClass) {
            return ((PolyglotInstrument)polyglotInstrument).engine.getLanguage(languageClass, (boolean)true).info;
        }

        public CallTarget parseForLanguage(Object sourceLanguageContext, com.oracle.truffle.api.source.Source source, String[] argumentNames, boolean allowInternal) {
            PolyglotLanguageContext sourceContext = (PolyglotLanguageContext)sourceLanguageContext;
            if (PolyglotFastThreadLocals.getContext(null) != sourceContext.context) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PolyglotEngineException.illegalState((String)"The context is not entered.");
            }
            PolyglotLanguage targetLanguage = sourceContext.context.engine.findLanguage(sourceContext, source.getLanguage(), source.getMimeType(), true, allowInternal);
            PolyglotLanguageContext targetContext = sourceContext.context.getContextInitialized(targetLanguage, sourceContext.language);
            targetContext.checkAccess(sourceContext.getLanguageInstance().language);
            return targetContext.parseCached(sourceContext.language, source, argumentNames);
        }

        public TruffleLanguage.Env getEnvForInstrument(String languageId, String mimeType) {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            PolyglotLanguage foundLanguage = context.engine.findLanguage(null, languageId, mimeType, true, true);
            return context.getContextInitialized((PolyglotLanguage)foundLanguage, null).env;
        }

        public org.graalvm.polyglot.SourceSection createSourceSection(Object polyglotObject, Source source, SourceSection sectionImpl) {
            return PolyglotImpl.getPolyglotSourceSection((PolyglotImpl)((PolyglotImpl.VMObject)polyglotObject).getImpl(), (SourceSection)sectionImpl);
        }

        public TruffleFile getTruffleFile(String path) {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            return LANGUAGE.getTruffleFile(context.getHostContext().getPublicFileSystemContext(), path);
        }

        public TruffleFile getTruffleFile(URI uri) {
            PolyglotContextImpl context = PolyglotContextImpl.requireContext();
            return LANGUAGE.getTruffleFile(context.getHostContext().getPublicFileSystemContext(), uri);
        }

        public <T> Iterable<T> loadServices(Class<T> type) {
            LinkedHashMap found = new LinkedHashMap();
            if (type.getClassLoader() == Truffle.class.getClassLoader()) {
                for (AbstractClassLoaderSupplier service : ServiceLoader.load(type, type.getClassLoader())) {
                    found.putIfAbsent(service.getClass(), service);
                }
            }
            for (AbstractClassLoaderSupplier loaderSupplier : EngineAccessor.locatorOrDefaultLoaders()) {
                ClassLoader loader = (ClassLoader)loaderSupplier.get();
                if (!EngineImpl.seesTheSameClass(loader, type)) continue;
                JDKSERVICES.exportTo(loader, null);
                for (T service : ServiceLoader.load(type, loader)) {
                    found.putIfAbsent(service.getClass(), (AbstractClassLoaderSupplier)service);
                }
            }
            return found.values();
        }

        private static boolean seesTheSameClass(ClassLoader loader, Class<?> type) {
            try {
                return loader != null && loader.loadClass(type.getName()) == type;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }

        public <T> T lookup(InstrumentInfo info, Class<T> serviceClass) {
            PolyglotInstrument instrument = (PolyglotInstrument)LANGUAGE.getPolyglotInstrument(info);
            return (T)instrument.lookupInternal(serviceClass);
        }

        public <S> S lookup(LanguageInfo info, Class<S> serviceClass) {
            PolyglotLanguage language = (PolyglotLanguage)NODES.getPolyglotLanguage(info);
            if (!language.cache.supportsService(serviceClass)) {
                return null;
            }
            PolyglotLanguageContext languageContext = PolyglotContextImpl.requireContext().getContext(language);
            languageContext.ensureCreated(language);
            return (S)languageContext.lookupService(serviceClass);
        }

        public <C, T extends TruffleLanguage<C>> C getCurrentContext(Class<T> languageClass) {
            CompilerAsserts.partialEvaluationConstant(languageClass);
            int index = PolyglotFastThreadLocals.computePELanguageIndex(languageClass, (int)0);
            CompilerAsserts.partialEvaluationConstant((int)index);
            Object contextImpl = PolyglotFastThreadLocals.getLanguageContext(null, (int)index);
            if (contextImpl == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PolyglotEngineException.illegalState((String)"There is no current context available.");
            }
            return (C)contextImpl;
        }

        public TruffleContext getTruffleContext(Object polyglotLanguageContext) {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)polyglotLanguageContext;
            return languageContext.context.currentTruffleContext;
        }

        public Object getHostContext(Object polyglotContext) {
            return ((PolyglotContextImpl)polyglotContext).getHostContextImpl();
        }

        public Object enterLanguageFromRuntime(TruffleLanguage<?> language) {
            PolyglotLanguageInstance instance = (PolyglotLanguageInstance)LANGUAGE.getPolyglotLanguageInstance(language);
            return PolyglotFastThreadLocals.enterLanguage((PolyglotLanguageInstance)instance);
        }

        public void leaveLanguageFromRuntime(TruffleLanguage<?> language, Object prev) {
            PolyglotLanguageInstance instance = (PolyglotLanguageInstance)LANGUAGE.getPolyglotLanguageInstance(language);
            PolyglotFastThreadLocals.leaveLanguage((PolyglotLanguageInstance)instance, (Object)prev);
        }

        public TruffleContext getCurrentCreatorTruffleContext() {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            return context != null ? context.creatorTruffleContext : null;
        }

        public <T extends TruffleLanguage<?>> T getCurrentLanguage(Class<T> languageClass) {
            CompilerAsserts.partialEvaluationConstant(languageClass);
            int index = PolyglotFastThreadLocals.computePELanguageIndex(languageClass, (int)1);
            CompilerAsserts.partialEvaluationConstant((int)index);
            TruffleLanguage language = PolyglotFastThreadLocals.getLanguage(null, (int)index, languageClass);
            if (language == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PolyglotEngineException.illegalState((String)"There is no current context available.");
            }
            return (T)language;
        }

        public Map<String, LanguageInfo> getInternalLanguages(Object polyglotObject) {
            if (polyglotObject instanceof PolyglotLanguageContext) {
                return ((PolyglotLanguageContext)polyglotObject).getAccessibleLanguages(true);
            }
            return EngineImpl.getEngine((Object)polyglotObject).idToInternalLanguageInfo;
        }

        public Map<String, LanguageInfo> getPublicLanguages(Object polyglotObject) {
            return ((PolyglotLanguageContext)polyglotObject).getAccessibleLanguages(false);
        }

        public Map<String, InstrumentInfo> getInstruments(Object polyglotObject) {
            return EngineImpl.getEngine((Object)polyglotObject).idToInternalInstrumentInfo;
        }

        private static PolyglotEngineImpl getEngine(Object polyglotObject) throws AssertionError {
            if (!(polyglotObject instanceof PolyglotImpl.VMObject)) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return ((PolyglotImpl.VMObject)polyglotObject).getEngine();
        }

        public TruffleLanguage.Env getEnvForInstrument(LanguageInfo info) {
            PolyglotLanguage language = (PolyglotLanguage)NODES.getPolyglotLanguage(info);
            return PolyglotContextImpl.requireContext().getContextInitialized((PolyglotLanguage)language, null).env;
        }

        static PolyglotLanguage findObjectLanguage(PolyglotEngineImpl engine, Object value) {
            InteropLibrary lib = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
            if (lib.hasLanguage(value)) {
                try {
                    return engine.getLanguage(lib.getLanguage(value), false);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return null;
        }

        static PolyglotLanguage getLanguageView(PolyglotEngineImpl engine, Object value) {
            InteropLibrary lib = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
            if (lib.hasLanguage(value)) {
                try {
                    return engine.getLanguage(lib.getLanguage(value), false);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return null;
        }

        static boolean isPrimitive(Object value) {
            Class<?> valueClass = value.getClass();
            return valueClass == Boolean.class || valueClass == Byte.class || valueClass == Short.class || valueClass == Integer.class || valueClass == Long.class || valueClass == Float.class || valueClass == Double.class || valueClass == Character.class || valueClass == String.class;
        }

        public Object getCurrentSharingLayer() {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            if (context == null) {
                return null;
            }
            return context.layer;
        }

        public Object getCurrentPolyglotEngine() {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            if (context == null) {
                return null;
            }
            return context.engine;
        }

        public boolean isMultiThreaded(Object guestObject) {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            if (context == null) {
                return true;
            }
            if (EngineImpl.isPrimitive(guestObject)) {
                return false;
            }
            if (context.engine.host.isHostValue(guestObject) || guestObject instanceof PolyglotBindings) {
                return true;
            }
            PolyglotLanguage language = EngineImpl.findObjectLanguage(context.engine, guestObject);
            if (language == null) {
                return true;
            }
            return !context.singleThreaded;
        }

        public boolean isEvalRoot(RootNode target) {
            return false;
        }

        public RuntimeException engineToLanguageException(Throwable t) {
            KingScriptChanges.fixed("\u65e0\u9700\u8f6c\u6362(\u8fd8\u539f\u539f\u59cb\u5f02\u5e38)");
            if (t instanceof ScriptException) {
                return (ScriptException)t;
            }
            return PolyglotImpl.engineToLanguageException((Throwable)t);
        }

        public RuntimeException engineToInstrumentException(Throwable t) {
            return PolyglotImpl.engineToInstrumentException((Throwable)t);
        }

        public Object getCurrentFileSystemContext() {
            return PolyglotContextImpl.requireContext().getHostContext().getPublicFileSystemContext();
        }

        public Object getPublicFileSystemContext(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).getPublicFileSystemContext();
        }

        public Object getInternalFileSystemContext(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).getInternalFileSystemContext();
        }

        public Map<String, Collection<? extends TruffleFile.FileTypeDetector>> getEngineFileTypeDetectors(Object engineFileSystemObject) {
            if (engineFileSystemObject instanceof PolyglotLanguageContext) {
                return ((PolyglotLanguageContext)engineFileSystemObject).context.engine.getFileTypeDetectorsSupplier().get();
            }
            if (engineFileSystemObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
                return (Map)((PolyglotImpl.EmbedderFileSystemContext)engineFileSystemObject).fileTypeDetectors.get();
            }
            throw new AssertionError();
        }

        public Set<String> getValidMimeTypes(Object engineObject, String language) {
            LanguageCache lang = EngineImpl.getLanguageCache(engineObject, language);
            if (lang != null) {
                return lang.getMimeTypes();
            }
            return Collections.emptySet();
        }

        private static LanguageCache getLanguageCache(Object engineObject, String language) throws AssertionError {
            if (engineObject instanceof PolyglotLanguageContext) {
                PolyglotLanguage polyglotLanguage = ((PolyglotLanguageContext)engineObject).context.engine.idToLanguage.get(language);
                if (polyglotLanguage != null) {
                    return polyglotLanguage.cache;
                }
                return null;
            }
            if (engineObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
                return (LanguageCache)((PolyglotImpl.EmbedderFileSystemContext)engineObject).cachedLanguages.get(language);
            }
            throw new AssertionError();
        }

        public boolean isCharacterBasedSource(Object fsEngineObject, String language, String mimeType) {
            LanguageCache cache = EngineImpl.getLanguageCache(fsEngineObject, language);
            if (cache == null) {
                return true;
            }
            String useMimeType = mimeType;
            if (useMimeType == null) {
                useMimeType = cache.getDefaultMimeType();
            }
            if (useMimeType == null || !cache.getMimeTypes().contains(useMimeType)) {
                return true;
            }
            return cache.isCharacterMimeType(useMimeType);
        }

        public boolean isMimeTypeSupported(Object polyglotLanguageContext, String mimeType) {
            PolyglotEngineImpl engine = EngineImpl.getEngine(polyglotLanguageContext);
            for (PolyglotLanguage language : engine.idToLanguage.values()) {
                if (!language.cache.getMimeTypes().contains(mimeType)) continue;
                return true;
            }
            return false;
        }

        public Object getInstrumentationHandler(Object polyglotObject) {
            return EngineImpl.getEngine((Object)polyglotObject).instrumentationHandler;
        }

        public Object getInstrumentationHandler(RootNode rootNode) {
            PolyglotSharingLayer sharing = (PolyglotSharingLayer)NODES.getSharingLayer(rootNode);
            if (sharing == null) {
                return null;
            }
            return this.getInstrumentationHandler(sharing.engine);
        }

        @CompilerDirectives.TruffleBoundary
        public Object importSymbol(Object polyglotLanguageContext, TruffleLanguage.Env env, String symbolName) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)polyglotLanguageContext;
            Value value = context.context.polyglotBindings.get(symbolName);
            if (value != null) {
                return context.getAPIAccess().getReceiver(value);
            }
            return null;
        }

        public Object lookupHostSymbol(Object polyglotLanguageContext, TruffleLanguage.Env env, String symbolName) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)polyglotLanguageContext).context;
            return context.engine.host.findStaticClass(context.getHostContextImpl(), symbolName);
        }

        public Object asHostSymbol(Object polyglotLanguageContext, Class<?> symbolClass) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)polyglotLanguageContext).context;
            return context.engine.host.asHostStaticClass(context.getHostContextImpl(), symbolClass);
        }

        public boolean isHostAccessAllowed(Object polyglotLanguageContext, TruffleLanguage.Env env) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)polyglotLanguageContext;
            return context.context.config.hostLookupAllowed;
        }

        public boolean isNativeAccessAllowed(Object polyglotLanguageContext, TruffleLanguage.Env env) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)polyglotLanguageContext;
            return context.context.config.nativeAccessAllowed;
        }

        public boolean inContextPreInitialization(Object polyglotObject) {
            PolyglotContextImpl polyglotContext;
            if (polyglotObject instanceof PolyglotContextImpl) {
                polyglotContext = (PolyglotContextImpl)polyglotObject;
            } else if (polyglotObject instanceof PolyglotLanguageContext) {
                polyglotContext = ((PolyglotLanguageContext)polyglotObject).context;
            } else {
                if (polyglotObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
                    return false;
                }
                throw CompilerDirectives.shouldNotReachHere();
            }
            return polyglotContext.inContextPreInitialization;
        }

        @CompilerDirectives.TruffleBoundary
        public void exportSymbol(Object polyglotLanguageContext, String symbolName, Object value) {
            PolyglotLanguageContext context = (PolyglotLanguageContext)polyglotLanguageContext;
            if (value == null) {
                context.context.getPolyglotGuestBindings().remove(symbolName);
                return;
            }
            if (!PolyglotImpl.isGuestPrimitive((Object)value) && !(value instanceof TruffleObject)) {
                throw new IllegalArgumentException("Invalid exported value. Must be an interop value.");
            }
            context.context.getPolyglotGuestBindings().put(symbolName, context.asValue(value));
        }

        public Map<String, ? extends Object> getExportedSymbols() {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            return (Map)currentContext.getPolyglotBindings().as(Map.class);
        }

        public Object getPolyglotBindingsObject() {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            return currentContext.getPolyglotBindingsObject();
        }

        public Object toGuestValue(Node node, Object obj, Object languageContext) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.toGuestValue(node, obj, false);
        }

        public Object asBoxedGuestValue(Object guestObject, Object polyglotLanguageContext) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)polyglotLanguageContext).context;
            if (PolyglotImpl.isGuestPrimitive((Object)guestObject)) {
                return context.engine.host.toHostObject(context.getHostContextImpl(), guestObject);
            }
            if (guestObject instanceof TruffleObject) {
                return guestObject;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Provided value not an interop value.");
        }

        public void reportAllLanguageContexts(Object polyglotEngine, Object contextsListener) {
            ((PolyglotEngineImpl)polyglotEngine).reportAllLanguageContexts((ContextsListener)contextsListener);
        }

        public void reportAllContextThreads(Object polyglotEngine, Object threadsListener) {
            ((PolyglotEngineImpl)polyglotEngine).reportAllContextThreads((ThreadsListener)threadsListener);
        }

        public TruffleContext getParentContext(Object polyglotContext) {
            PolyglotContextImpl parent = ((PolyglotContextImpl)polyglotContext).parent;
            if (parent != null) {
                return parent.currentTruffleContext;
            }
            return null;
        }

        public Object enterInternalContext(Node location, Object polyglotLanguageContext) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotLanguageContext;
            PolyglotEngineImpl engine = EngineImpl.resolveEngine(location, context);
            return engine.enter(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evalInternalContext(Node location, Object polyglotContext, com.oracle.truffle.api.source.Source source, boolean allowInternal) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            if (context.parent == null) {
                throw PolyglotEngineException.illegalState((String)"Only created inner contexts can be used to evaluate sources. Use TruffleLanguage.Env.parseInternal(Source) or TruffleInstrument.Env.parse(Source) instead.");
            }
            PolyglotEngineImpl engine = EngineImpl.resolveEngine(location, context);
            Object[] prev = engine.enter(context);
            try {
                Object object = EngineImpl.evalBoundary(source, prev, context, allowInternal);
                return object;
            }
            finally {
                engine.leave(prev, context);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object evalBoundary(com.oracle.truffle.api.source.Source source, Object[] prev, PolyglotContextImpl context, boolean allowInternal) {
            Object result;
            PolyglotContextImpl parentEnteredContext = (PolyglotContextImpl)prev[1];
            if (parentEnteredContext != null && parentEnteredContext != context.parent && parentEnteredContext.engine == context.engine) {
                throw PolyglotEngineException.illegalState((String)"Invalid parent context entered. The parent creator context or no context must be entered to evaluate code in an inner context.");
            }
            PolyglotLanguageContext targetContext = context.getContext(context.engine.requireLanguage(source.getLanguage(), allowInternal));
            PolyglotLanguage accessingLanguage = context.creator;
            targetContext.checkAccess(accessingLanguage);
            try {
                CallTarget target = targetContext.parseCached(accessingLanguage, source, null);
                result = target.call(PolyglotImpl.EMPTY_ARGS);
            }
            catch (RuntimeException e) {
                throw OtherContextGuestObject.migrateException((PolyglotContextImpl)context.parent, (Exception)e, (PolyglotContextImpl)context);
            }
            assert (InteropLibrary.isValidValue((Object)result)) : "invalid call target return value";
            return context.parent.migrateValue(result, context);
        }

        public void leaveInternalContext(Node node, Object impl, Object prev) {
            CompilerAsserts.partialEvaluationConstant((Object)node);
            PolyglotContextImpl context = (PolyglotContextImpl)impl;
            PolyglotEngineImpl engine = EngineImpl.resolveEngine(node, context);
            if (CompilerDirectives.isPartialEvaluationConstant((Object)engine)) {
                engine.leave((Object[])prev, context);
            } else {
                EngineImpl.leaveInternalContextBoundary(prev, context, engine);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static void leaveInternalContextBoundary(Object prev, PolyglotContextImpl context, PolyglotEngineImpl engine) {
            engine.leave((Object[])prev, context);
        }

        private static PolyglotEngineImpl resolveEngine(Node node, PolyglotContextImpl context) {
            PolyglotEngineImpl engine;
            if (CompilerDirectives.inCompiledCode() && node != null) {
                RootNode root = node.getRootNode();
                if (root == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new IllegalStateException("Passed node is not yet adopted. Adopt it first.");
                }
                CompilerAsserts.partialEvaluationConstant((Object)root);
                PolyglotSharingLayer sharing = (PolyglotSharingLayer)NODES.getSharingLayer(root);
                engine = sharing.engine;
                CompilerAsserts.partialEvaluationConstant((Object)engine);
                assert (engine != null) : "root node engine must not be null";
            } else {
                engine = context.engine;
            }
            return engine;
        }

        public boolean isContextEntered(Object impl) {
            return PolyglotFastThreadLocals.getContext(null) == impl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TruffleContext createInternalContext(Object sourcePolyglotLanguageContext, Map<String, Object> config, boolean initializeCreatorContext) {
            PolyglotContextImpl impl;
            PolyglotLanguageContext creator = (PolyglotLanguageContext)sourcePolyglotLanguageContext;
            PolyglotContextImpl polyglotContextImpl = creator.context;
            synchronized (polyglotContextImpl) {
                impl = new PolyglotContextImpl(creator, config);
                creator.context.engine.noInnerContexts.invalidate();
                creator.context.addChildContext(impl);
                impl.api = creator.getImpl().getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextDispatch)creator.getImpl().contextDispatch, (Object)impl, creator.context.engine.api);
            }
            polyglotContextImpl = impl;
            synchronized (polyglotContextImpl) {
                impl.initializeContextLocals();
                impl.notifyContextCreated();
                if (initializeCreatorContext) {
                    impl.initializeInnerContextLanguage(creator.language.getId());
                }
            }
            return impl.creatorTruffleContext;
        }

        public boolean isCreateThreadAllowed(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).context.config.createThreadAllowed;
        }

        public Thread createThread(Object polyglotLanguageContext, Runnable runnable, Object innerContextImpl, ThreadGroup group, long stackSize) {
            if (!this.isCreateThreadAllowed(polyglotLanguageContext)) {
                throw PolyglotEngineException.illegalState((String)"Creating threads is not allowed.");
            }
            PolyglotLanguageContext threadContext = (PolyglotLanguageContext)polyglotLanguageContext;
            if (innerContextImpl != null) {
                PolyglotContextImpl innerContext = (PolyglotContextImpl)innerContextImpl;
                threadContext = innerContext.getContext(threadContext.language);
            }
            PolyglotThread newThread = new PolyglotThread(threadContext, runnable, group, stackSize);
            threadContext.context.checkMultiThreadedAccess(newThread);
            return newThread;
        }

        public RuntimeException wrapHostException(Node location, Object languageContext, Throwable exception) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.engine.host.toHostException(context.getHostContextImpl(), exception);
        }

        public boolean isHostException(Object languageContext, Throwable exception) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.engine.host.isHostException((Object)exception);
        }

        public Throwable asHostException(Object languageContext, Throwable exception) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            Throwable host = context.engine.host.unboxHostException(exception);
            if (host == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalArgumentException("Provided value not a host exception.");
            }
            return host;
        }

        public Object getCurrentHostContext() {
            PolyglotContextImpl polyglotContext = PolyglotFastThreadLocals.getContext(null);
            return polyglotContext == null ? null : polyglotContext.getHostContext();
        }

        public Object getPolyglotBindingsForLanguage(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).getPolyglotGuestBindings();
        }

        public Object findMetaObjectForLanguage(Object polyglotLanguageContext, Object value) {
            InteropLibrary lib = (InteropLibrary)InteropLibrary.getFactory().getUncached(value);
            if (lib.hasMetaObject(value)) {
                try {
                    return lib.getMetaObject(value);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((String)"Unexpected unsupported message.", (Throwable)e);
                }
            }
            return null;
        }

        public PolyglotException wrapGuestException(String languageId, Throwable e) {
            PolyglotContextImpl pc = PolyglotFastThreadLocals.getContext(null);
            if (pc == null) {
                return null;
            }
            PolyglotLanguage language = pc.engine.findLanguage(null, languageId, null, true, true);
            PolyglotLanguageContext languageContext = pc.getContextInitialized(language, null);
            return PolyglotImpl.guestToHostException((PolyglotLanguageContext)languageContext, (Throwable)e, (boolean)true);
        }

        public PolyglotException wrapGuestException(Object polyglotObject, Throwable e) {
            if (polyglotObject instanceof PolyglotContextImpl) {
                PolyglotContextImpl polyglotContext = (PolyglotContextImpl)polyglotObject;
                PolyglotLanguage language = polyglotContext.getHostContext().language;
                PolyglotLanguageContext languageContext = polyglotContext.getContextInitialized(language, null);
                return PolyglotImpl.guestToHostException((PolyglotLanguageContext)languageContext, (Throwable)e, (boolean)true);
            }
            if (polyglotObject instanceof PolyglotEngineImpl) {
                return PolyglotImpl.guestToHostException((PolyglotEngineImpl)((PolyglotEngineImpl)polyglotObject), (Throwable)e);
            }
            return PolyglotImpl.guestToHostException((PolyglotImpl)((PolyglotImpl)polyglotObject), (Throwable)e);
        }

        public Set<? extends Class<?>> getProvidedTags(LanguageInfo language) {
            return ((PolyglotLanguage)EngineAccessor.NODES.getPolyglotLanguage((LanguageInfo)language)).cache.getProvidedTags();
        }

        public <T> T getOrCreateRuntimeData(Object layer) {
            PolyglotEngineImpl engine;
            PolyglotSharingLayer useLayer = (PolyglotSharingLayer)layer;
            PolyglotEngineImpl polyglotEngineImpl = engine = useLayer != null ? useLayer.engine : null;
            if (engine == null) {
                engine = PolyglotEngineImpl.getFallbackEngine();
            }
            return (T)engine.runtimeData;
        }

        public OptionValues getEngineOptionValues(Object polyglotEngine) {
            return ((PolyglotEngineImpl)polyglotEngine).engineOptionValues;
        }

        public Collection<CallTarget> findCallTargets(Object polyglotEngine) {
            return INSTRUMENT.getLoadedCallTargets(((PolyglotEngineImpl)polyglotEngine).instrumentationHandler);
        }

        public void preinitializeContext(Object polyglotEngine) {
            ((PolyglotEngineImpl)polyglotEngine).preInitialize();
        }

        public void finalizeStore(Object polyglotEngine) {
            ((PolyglotEngineImpl)polyglotEngine).finalizeStore();
        }

        public Object getEngineLock(Object polyglotEngine) {
            return ((PolyglotEngineImpl)polyglotEngine).lock;
        }

        public boolean isInternal(FileSystem fs) {
            return FileSystems.isInternal((FileSystem)fs);
        }

        public boolean hasAllAccess(FileSystem fs) {
            return FileSystems.hasAllAccess((FileSystem)fs);
        }

        public boolean hasNoAccess(FileSystem fs) {
            return FileSystems.hasNoAccess((FileSystem)fs);
        }

        public boolean isInternal(TruffleFile file) {
            Object fsContext = LANGUAGE.getFileSystemContext(file);
            Object engineObject = LANGUAGE.getFileSystemEngineObject(fsContext);
            if (engineObject instanceof PolyglotLanguageContext) {
                return fsContext == ((PolyglotLanguageContext)engineObject).getInternalFileSystemContext();
            }
            return false;
        }

        public void addToHostClassPath(Object polyglotLanguageContext, TruffleFile entry) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)polyglotLanguageContext).context;
            context.engine.host.addToHostClassPath(context.getHostContextImpl(), (Object)entry);
        }

        public String getLanguageHome(Object engineObject) {
            return ((PolyglotLanguage)engineObject).cache.getLanguageHome();
        }

        public boolean isInstrumentExceptionsAreThrown(Object polyglotInstrument) {
            OptionValuesImpl engineOptionValues = EngineImpl.getEngine((Object)polyglotInstrument).engineOptionValues;
            return EngineImpl.areAssertionsEnabled() && !engineOptionValues.hasBeenSet(PolyglotEngineOptions.InstrumentExceptionsAreThrown) || (Boolean)engineOptionValues.get(PolyglotEngineOptions.InstrumentExceptionsAreThrown) != false;
        }

        private static boolean areAssertionsEnabled() {
            boolean assertsEnabled = false;
            if (!$assertionsDisabled) {
                assertsEnabled = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return assertsEnabled;
        }

        public Object createDefaultLoggerCache() {
            return PolyglotLoggers.LoggerCache.DEFAULT;
        }

        public Object getContextLoggerCache(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).context.getOrCreateContextLoggers();
        }

        public Handler getLogHandler(Object loggerCache) {
            return ((PolyglotLoggers.LoggerCache)loggerCache).getLogHandler();
        }

        public LogRecord createLogRecord(Object loggerCache, Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown) {
            return ((PolyglotLoggers.LoggerCache)loggerCache).createLogRecord(level, loggerName, message, className, methodName, parameters, thrown);
        }

        public Object getOuterContext(Object polyglotContext) {
            return EngineImpl.getOuterContext((PolyglotContextImpl)polyglotContext);
        }

        static PolyglotContextImpl getOuterContext(PolyglotContextImpl context) {
            PolyglotContextImpl res = context;
            if (res != null) {
                while (res.parent != null) {
                    res = res.parent;
                }
            }
            return res;
        }

        public Map<String, Level> getLogLevels(Object loggerCache) {
            return ((PolyglotLoggers.LoggerCache)loggerCache).getLogLevels();
        }

        public Object getLoggerOwner(Object loggerCache) {
            return ((PolyglotLoggers.LoggerCache)loggerCache).getOwner();
        }

        public Set<String> getLanguageIds() {
            return LanguageCache.languages().keySet();
        }

        public Set<String> getInstrumentIds() {
            HashSet<String> ids = new HashSet<String>();
            for (InstrumentCache cache : InstrumentCache.load()) {
                ids.add(cache.getId());
            }
            return ids;
        }

        public Set<String> getInternalIds() {
            return PolyglotLoggers.getInternalIds();
        }

        public Object asHostObject(Object languageContext, Object obj) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            assert (this.isHostObject(languageContext, obj));
            return context.engine.host.unboxHostObject(obj);
        }

        public boolean isHostFunction(Object languageContext, Object obj) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.engine.host.isHostFunction(obj);
        }

        public boolean isHostObject(Object languageContext, Object obj) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.engine.host.isHostObject(obj);
        }

        public boolean isHostSymbol(Object languageContext, Object obj) {
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.engine.host.isHostSymbol(obj);
        }

        public <S> S lookupService(Object polyglotLanguageContext, LanguageInfo language, LanguageInfo accessingLanguage, Class<S> type) {
            PolyglotLanguage lang = (PolyglotLanguage)NODES.getPolyglotLanguage(language);
            if (!lang.cache.supportsService(type)) {
                return null;
            }
            PolyglotLanguageContext context = ((PolyglotLanguageContext)polyglotLanguageContext).context.getContext(lang);
            context.ensureCreated((PolyglotLanguage)NODES.getPolyglotLanguage(accessingLanguage));
            return (S)context.lookupService(type);
        }

        public TruffleLogger getLogger(Object polyglotInstrument, String loggerName) {
            PolyglotInstrument instrument = (PolyglotInstrument)polyglotInstrument;
            String id = instrument.getId();
            PolyglotEngineImpl engine = EngineImpl.getEngine(polyglotInstrument);
            Object loggerCache = engine.getOrCreateEngineLoggers();
            return LANGUAGE.getLogger(id, loggerName, loggerCache);
        }

        public <T extends TruffleLanguage<C>, C> TruffleLanguage.ContextReference<C> createContextReference(Node node, Class<T> languageClass) {
            return PolyglotFastThreadLocals.createContextReference((Node)node, languageClass);
        }

        public <T extends TruffleLanguage<?>> TruffleLanguage.LanguageReference<T> createLanguageReference(Node node, Class<T> targetLanguageClass) {
            return PolyglotFastThreadLocals.createLanguageReference((Node)node, targetLanguageClass);
        }

        public FileSystem getFileSystem(Object polyglotContext) {
            return ((PolyglotContextImpl)polyglotContext).config.fileSystem;
        }

        public int getAsynchronousStackDepth(Object polylgotLanguage) {
            return ((PolyglotLanguage)polylgotLanguage).engine.getAsynchronousStackDepth();
        }

        public void setAsynchronousStackDepth(Object polyglotInstrument, int depth) {
            EngineImpl.getEngine(polyglotInstrument).setAsynchronousStackDepth((PolyglotInstrument)polyglotInstrument, depth);
        }

        public boolean isCreateProcessAllowed(Object polylgotLanguageContext) {
            return ((PolyglotLanguageContext)polylgotLanguageContext).context.config.createProcessAllowed;
        }

        public Map<String, String> getProcessEnvironment(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).context.config.getEnvironment();
        }

        public Process createSubProcess(Object polyglotLanguageContext, List<String> cmd, String cwd, Map<String, String> environment, boolean redirectErrorStream, ProcessHandler.Redirect inputRedirect, ProcessHandler.Redirect outputRedirect, ProcessHandler.Redirect errorRedirect) throws IOException {
            PolyglotLanguageContext languageContext = (PolyglotLanguageContext)polyglotLanguageContext;
            OutputStream stdOut = languageContext.getImpl().getIO().getOutputStream(outputRedirect);
            OutputStream stdErr = languageContext.getImpl().getIO().getOutputStream(errorRedirect);
            ProcessHandler.Redirect useOutputRedirect = stdOut == null ? outputRedirect : ProcessHandler.Redirect.PIPE;
            ProcessHandler.Redirect useErrorRedirect = stdErr == null ? errorRedirect : ProcessHandler.Redirect.PIPE;
            ProcessHandler.ProcessCommand command = languageContext.getImpl().getIO().newProcessCommand(cmd, cwd, environment, redirectErrorStream, inputRedirect, useOutputRedirect, useErrorRedirect);
            Process process = languageContext.context.config.processHandler.start(command);
            return ProcessHandlers.decorate((PolyglotLanguageContext)languageContext, cmd, (Process)process, (OutputStream)stdOut, (OutputStream)stdErr);
        }

        public boolean hasDefaultProcessHandler(Object polyglotLanguageContext) {
            return ProcessHandlers.isDefault((ProcessHandler)((PolyglotLanguageContext)polyglotLanguageContext).context.config.processHandler);
        }

        public ProcessHandler.Redirect createRedirectToOutputStream(Object polyglotLanguageContext, OutputStream stream) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).getImpl().getIO().createRedirectToStream(stream);
        }

        public boolean isIOAllowed() {
            return PolyglotEngineImpl.ALLOW_IO;
        }

        public String getUnparsedOptionValue(OptionValues optionValues, OptionKey<?> optionKey) {
            if (!(optionValues instanceof OptionValuesImpl)) {
                throw new IllegalArgumentException(String.format("Only %s is supported.", OptionValuesImpl.class.getName()));
            }
            return ((OptionValuesImpl)optionValues).getUnparsedOptionValue(optionKey);
        }

        public String getRelativePathInLanguageHome(TruffleFile truffleFile) {
            return FileSystems.getRelativePathInLanguageHome((TruffleFile)truffleFile);
        }

        public void onSourceCreated(com.oracle.truffle.api.source.Source source) {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            if (currentContext != null && currentContext.sourcesToInvalidate != null) {
                currentContext.sourcesToInvalidate.add(source);
            }
        }

        public void registerOnDispose(Object engineObject, Closeable closeable) {
            if (!(engineObject instanceof PolyglotLanguageContext)) {
                throw CompilerDirectives.shouldNotReachHere((String)"EngineObject must be PolyglotLanguageContext.");
            }
            ((PolyglotLanguageContext)engineObject).context.registerOnDispose(closeable);
        }

        public String getReinitializedPath(TruffleFile truffleFile) {
            FileSystem fs = LANGUAGE.getFileSystem(truffleFile);
            Path path = LANGUAGE.getPath(truffleFile);
            return ((FileSystems.PreInitializeContextFileSystem)fs).pathToString(path);
        }

        public URI getReinitializedURI(TruffleFile truffleFile) {
            FileSystem fs = LANGUAGE.getFileSystem(truffleFile);
            Path path = LANGUAGE.getPath(truffleFile);
            return ((FileSystems.PreInitializeContextFileSystem)fs).absolutePathtoURI(path);
        }

        public boolean initializeLanguage(Object polyglotLanguageContext, LanguageInfo targetLanguage) {
            PolyglotLanguage targetPolyglotLanguage = (PolyglotLanguage)NODES.getPolyglotLanguage(targetLanguage);
            PolyglotLanguageContext targetLanguageContext = ((PolyglotLanguageContext)polyglotLanguageContext).context.getContext(targetPolyglotLanguage);
            PolyglotLanguage accessingPolyglotLanguage = ((PolyglotLanguageContext)polyglotLanguageContext).language;
            try {
                targetLanguageContext.checkAccess(accessingPolyglotLanguage);
            }
            catch (PolyglotEngineException notAccessible) {
                if (notAccessible.e instanceof IllegalArgumentException) {
                    throw new SecurityException(notAccessible.e.getMessage());
                }
                throw notAccessible;
            }
            return targetLanguageContext.ensureInitialized(accessingPolyglotLanguage);
        }

        public boolean skipEngineValidation(RootNode rootNode) {
            return rootNode instanceof HostToGuestRootNode || rootNode instanceof PolyglotThread.ThreadSpawnRootNode;
        }

        public AssertionError invalidSharingError(Node node, Object previousSharingLayer, Object newSharingLayer) throws AssertionError {
            return PolyglotSharingLayer.invalidSharingError((Node)node, (PolyglotSharingLayer)((PolyglotSharingLayer)previousSharingLayer), (PolyglotSharingLayer)((PolyglotSharingLayer)newSharingLayer));
        }

        public <T> ContextLocal<T> createInstrumentContextLocal(Object factory) {
            return PolyglotLocals.createInstrumentContextLocal((Object)factory);
        }

        public <T> ContextThreadLocal<T> createInstrumentContextThreadLocal(Object factory) {
            return PolyglotLocals.createInstrumentContextThreadLocal((Object)factory);
        }

        public <T> ContextLocal<T> createLanguageContextLocal(Object factory) {
            return PolyglotLocals.createLanguageContextLocal((Object)factory);
        }

        public <T> ContextThreadLocal<T> createLanguageContextThreadLocal(Object factory) {
            return PolyglotLocals.createLanguageContextThreadLocal((Object)factory);
        }

        public void initializeInstrumentContextLocal(List<? extends ContextLocal<?>> locals, Object polyglotInstrument) {
            PolyglotLocals.initializeInstrumentContextLocals(locals, (PolyglotInstrument)((PolyglotInstrument)polyglotInstrument));
        }

        public void initializeInstrumentContextThreadLocal(List<? extends ContextThreadLocal<?>> local, Object polyglotInstrument) {
            PolyglotLocals.initializeInstrumentContextThreadLocals(local, (PolyglotInstrument)((PolyglotInstrument)polyglotInstrument));
        }

        public boolean isPolyglotObject(Object polyglotObject) {
            return PolyglotImpl.getInstance() == polyglotObject;
        }

        public void initializeLanguageContextLocal(List<? extends ContextLocal<?>> locals, Object polyglotLanguageInstance) {
            PolyglotLocals.initializeLanguageContextLocals(locals, (PolyglotLanguageInstance)((PolyglotLanguageInstance)polyglotLanguageInstance));
        }

        public void initializeLanguageContextThreadLocal(List<? extends ContextThreadLocal<?>> local, Object polyglotLanguageInstance) {
            PolyglotLocals.initializeLanguageContextThreadLocals(local, (PolyglotLanguageInstance)((PolyglotLanguageInstance)polyglotLanguageInstance));
        }

        public OptionValues getInstrumentContextOptions(Object polyglotInstrument, Object polyglotContext) {
            PolyglotInstrument instrument = (PolyglotInstrument)polyglotInstrument;
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            return context.getInstrumentContextOptions(instrument);
        }

        public boolean isContextClosed(Object polyglotContext) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            PolyglotContextImpl.State localContextState = context.state;
            return localContextState.isInvalidOrClosed();
        }

        public boolean isContextCancelling(Object polyglotContext) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            PolyglotContextImpl.State localContextState = context.state;
            return localContextState.isCancelling();
        }

        public boolean isContextExiting(Object polyglotContext) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            PolyglotContextImpl.State contextState = context.state;
            return contextState.isExiting();
        }

        public Future<Void> pause(Object polyglotContext) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            return context.pause();
        }

        public void resume(Object polyglotContext, Future<Void> pauseFuture) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            context.resume(pauseFuture);
        }

        public boolean isContextActive(Object polyglotContext) {
            PolyglotContextImpl context = (PolyglotContextImpl)polyglotContext;
            return context.isActive(Thread.currentThread());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        public void closeContext(Object impl, boolean force, Node closeLocation, boolean resourceExhaused, String resourceExhausedReason) {
            PolyglotContextImpl context = (PolyglotContextImpl)impl;
            if (force) {
                boolean isActive = this.isContextActive(context);
                boolean entered = this.isContextEntered(context);
                if (isActive && !entered) {
                    throw PolyglotEngineException.illegalState((String)String.format("The context is currently active on the current thread but another different context is entered as top-most context. Leave or close the top-most context first or close the context on a separate thread to resolve this problem.", new Object[0]));
                }
                context.cancel(resourceExhaused, resourceExhausedReason);
                if (entered) {
                    TruffleSafepoint.pollHere((Node)(closeLocation != null ? closeLocation : context.uncachedLocation));
                }
            } else {
                PolyglotContextImpl polyglotContextImpl = context;
                synchronized (polyglotContextImpl) {
                    PolyglotContextImpl.State localContextState = context.state;
                    if (context.isActiveNotCancelled(false) && !localContextState.isCancelling() && !localContextState.isExiting()) {
                        throw new IllegalStateException("The context is currently active and cannot be closed. Make sure no thread is running or call closeCancelled on the context to resolve this.");
                    }
                }
                context.closeImpl(true);
                context.finishCleanup();
            }
        }

        public <T, G> Iterator<T> mergeHostGuestFrames(Object instrumentEnv, StackTraceElement[] hostStack, Iterator<G> guestFrames, boolean inHostLanguage, Function<StackTraceElement, T> hostFrameConvertor, Function<G, T> guestFrameConvertor) {
            PolyglotInstrument instrument = (PolyglotInstrument)INSTRUMENT.getPolyglotInstrument(instrumentEnv);
            return new PolyglotExceptionImpl.MergedHostGuestIterator(instrument.engine, hostStack, guestFrames, inHostLanguage, hostFrameConvertor, guestFrameConvertor);
        }

        public Object createHostAdapterClass(Object languageContext, Class<?>[] types, Object classOverrides) {
            CompilerAsserts.neverPartOfCompilation();
            PolyglotContextImpl context = ((PolyglotLanguageContext)languageContext).context;
            return context.engine.host.createHostAdapter(context.getHostContextImpl(), (Class[])types, classOverrides);
        }

        public long calculateContextHeapSize(Object polyglotContext, long stopAtBytes, AtomicBoolean cancelled) {
            return ((PolyglotContextImpl)polyglotContext).calculateHeapSize(stopAtBytes, cancelled);
        }

        public Future<Void> submitThreadLocal(Object polyglotContext, Object sourcePolyglotObject, Thread[] threads, ThreadLocalAction action, boolean needsEnter) {
            String componentId;
            if (sourcePolyglotObject instanceof PolyglotInstrument) {
                componentId = ((PolyglotInstrument)sourcePolyglotObject).getId();
            } else if (sourcePolyglotObject instanceof PolyglotLanguageContext) {
                componentId = ((PolyglotLanguageContext)sourcePolyglotObject).language.getId();
            } else {
                throw CompilerDirectives.shouldNotReachHere((String)"Invalid source component");
            }
            return ((PolyglotContextImpl)polyglotContext).threadLocalActions.submit(threads, componentId, action, needsEnter);
        }

        public Object getContext(Object polyglotLanguageContext) {
            return ((PolyglotLanguageContext)polyglotLanguageContext).context;
        }

        public ClassLoader getStaticObjectClassLoader(Object polyglotLanguageInstance, Class<?> referenceClass) {
            return (ClassLoader)((PolyglotLanguageInstance)polyglotLanguageInstance).staticObjectClassLoaders.get(referenceClass);
        }

        public void setStaticObjectClassLoader(Object polyglotLanguageInstance, Class<?> referenceClass, ClassLoader cl) {
            ((PolyglotLanguageInstance)polyglotLanguageInstance).staticObjectClassLoaders.put(referenceClass, cl);
        }

        public ConcurrentHashMap<Pair<Class<?>, Class<?>>, Object> getGeneratorCache(Object polyglotLanguageInstance) {
            return ((PolyglotLanguageInstance)polyglotLanguageInstance).generatorCache;
        }

        public boolean areStaticObjectSafetyChecksRelaxed(Object polyglotLanguageInstance) {
            return (Boolean)((PolyglotLanguageInstance)polyglotLanguageInstance).getEngine().getEngineOptionValues().get(PolyglotEngineOptions.RelaxStaticObjectSafetyChecks);
        }

        public String getStaticObjectStorageStrategy(Object polyglotLanguageInstance) {
            return ((PolyglotEngineOptions.StaticObjectStorageStrategies)((PolyglotLanguageInstance)polyglotLanguageInstance).getEngine().getEngineOptionValues().get(PolyglotEngineOptions.StaticObjectStorageStrategy)).name();
        }

        public void exitContext(Object impl, Node exitLocation, int exitCode) {
            PolyglotContextImpl context = (PolyglotContextImpl)impl;
            context.closeExited(exitLocation, exitCode);
        }

        public Throwable getPolyglotExceptionCause(Object polyglotExceptionImpl) {
            return ((PolyglotExceptionImpl)polyglotExceptionImpl).exception;
        }

        public Object getPolyglotExceptionContext(Object polyglotExceptionImpl) {
            return ((PolyglotExceptionImpl)polyglotExceptionImpl).context;
        }

        public Object getPolyglotExceptionEngine(Object polyglotExceptionImpl) {
            return ((PolyglotExceptionImpl)polyglotExceptionImpl).engine;
        }

        public boolean isCancelExecution(Throwable throwable) {
            return throwable instanceof PolyglotEngineImpl.CancelExecution;
        }

        public boolean isExitException(Throwable throwable) {
            return throwable instanceof PolyglotContextImpl.ExitException;
        }

        public boolean isInterruptExecution(Throwable throwable) {
            return throwable instanceof PolyglotEngineImpl.InterruptExecution;
        }

        public boolean isResourceLimitCancelExecution(Throwable cancelExecution) {
            return ((PolyglotEngineImpl.CancelExecution)cancelExecution).isResourceLimit();
        }

        public boolean isPolyglotEngineException(Throwable throwable) {
            return throwable instanceof PolyglotEngineException;
        }

        public RuntimeException getPolyglotEngineExceptionCause(Throwable polyglotEngineException) {
            return ((PolyglotEngineException)polyglotEngineException).e;
        }

        public RuntimeException createPolyglotEngineException(RuntimeException cause) {
            return new PolyglotEngineException(cause);
        }

        public int getExitExceptionExitCode(Throwable exitException) {
            return ((PolyglotContextImpl.ExitException)exitException).getExitCode();
        }

        public SourceSection getCancelExecutionSourceLocation(Throwable cancelExecution) {
            return ((PolyglotEngineImpl.CancelExecution)cancelExecution).getSourceLocation();
        }

        public ThreadDeath createCancelExecution(SourceSection sourceSection, String message, boolean resourceLimit) {
            return new PolyglotEngineImpl.CancelExecution(sourceSection, message, resourceLimit);
        }

        public SourceSection getExitExceptionSourceLocation(Throwable exitException) {
            return ((PolyglotContextImpl.ExitException)exitException).getSourceLocation();
        }

        public ThreadDeath createExitException(SourceSection sourceSection, String message, int exitCode) {
            return new PolyglotContextImpl.ExitException(sourceSection, exitCode, message);
        }

        public Throwable createInterruptExecution(SourceSection sourceSection) {
            return new PolyglotEngineImpl.InterruptExecution(sourceSection);
        }

        public Map<String, String> readOptionsFromSystemProperties(Map<String, String> options) {
            return PolyglotEngineImpl.readOptionsFromSystemProperties(options);
        }

        public AbstractPolyglotImpl.AbstractHostService getHostService(Object polyglotEngineImpl) {
            assert (polyglotEngineImpl instanceof PolyglotEngineImpl);
            return ((PolyglotEngineImpl)polyglotEngineImpl).host;
        }

        public Handler getEngineLogHandler(Object polyglotEngineImpl) {
            return ((PolyglotEngineImpl)polyglotEngineImpl).logHandler;
        }

        public Handler getContextLogHandler(Object polyglotContextImpl) {
            return ((PolyglotContextImpl)polyglotContextImpl).config.logHandler;
        }

        public LogRecord createLogRecord(Level level, String loggerName, String message, String className, String methodName, Object[] parameters, Throwable thrown, String formatKind) {
            return PolyglotLoggers.createLogRecord((Level)level, (String)loggerName, (String)message, (String)className, (String)methodName, (Object[])parameters, (Throwable)thrown, (String)formatKind);
        }

        public String getFormatKind(LogRecord logRecord) {
            return PolyglotLoggers.getFormatKind((LogRecord)logRecord);
        }

        public boolean isPolyglotThread(Thread thread) {
            return thread instanceof PolyglotThread;
        }

        public Object getHostNull() {
            return HOST.getHostNull();
        }

        public Object getPolyglotSharingLayer(Object polyglotLanguageInstance) {
            return ((PolyglotLanguageInstance)polyglotLanguageInstance).sharing;
        }

        public Object getGuestToHostCodeCache(Object polyglotContextImpl) {
            return ((PolyglotContextImpl)polyglotContextImpl).getHostContext().getLanguageInstance().getGuestToHostCodeCache();
        }

        public Object installGuestToHostCodeCache(Object polyglotContextImpl, Object cache) {
            return ((PolyglotContextImpl)polyglotContextImpl).getHostContext().getLanguageInstance().installGuestToHostCodeCache(cache);
        }
    }
}

