/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import java.util.Objects;
import kd.sdk.kingscript.exception.ScriptException;

abstract class HostToGuestRootNode
extends RootNode {
    protected static final int ARGUMENT_OFFSET = 2;
    @CompilerDirectives.CompilationFinal
    private boolean seenEnter;
    @CompilerDirectives.CompilationFinal
    private boolean seenNonEnter;
    private final PolyglotLanguage language;
    private final PolyglotSharingLayer layer;
    @CompilerDirectives.CompilationFinal
    private boolean seenError;

    HostToGuestRootNode(PolyglotSharingLayer layer) {
        super(null);
        assert (layer != null);
        this.layer = layer;
        this.language = null;
        EngineAccessor.NODES.setSharingLayer((RootNode)this, (Object)layer);
    }

    HostToGuestRootNode(PolyglotLanguageInstance language) {
        super(null);
        EngineAccessor.NODES.setSharingLayer((RootNode)this, (Object)language.sharing);
        this.layer = language.sharing;
        this.language = language.language;
    }

    protected abstract Class<?> getReceiverType();

    public final Object execute(VirtualFrame frame) {
        Object[] prev;
        boolean needsEnter;
        PolyglotContextImpl constantContext;
        Object[] args = frame.getArguments();
        PolyglotLanguageContext languageContext = this.layer.getSingleConstantLanguageContext(this.language);
        if (languageContext == null) {
            languageContext = (PolyglotLanguageContext)args[0];
        }
        if ((constantContext = this.layer.getSingleConstantContext()) == null) {
            constantContext = languageContext.context;
        } else assert (languageContext.context == constantContext);
        PolyglotContextImpl context = constantContext;
        assert (Objects.equals(this.layer, languageContext.context.layer)) : PolyglotSharingLayer.invalidSharingError((Node)this, (PolyglotSharingLayer)this.layer, (PolyglotSharingLayer)languageContext.context.layer);
        try {
            needsEnter = this.layer.engine.needsEnter(context);
            if (needsEnter) {
                if (!this.seenEnter) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenEnter = true;
                }
                prev = this.layer.engine.enterCached(context, true);
            } else {
                if (!this.seenNonEnter) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenNonEnter = true;
                }
                prev = null;
            }
        }
        catch (Throwable e) {
            throw this.handleException(languageContext, e, false, RuntimeException.class);
        }
        try {
            Object[] arguments = frame.getArguments();
            Object receiver = this.getReceiverType().cast(arguments[1]);
            Object result = this.executeImpl(languageContext, receiver, arguments);
            assert (!(result instanceof TruffleObject));
            Object object = result;
            return object;
        }
        catch (Throwable e) {
            KingScriptChanges.fixed("\u63d2\u4ef6\u8fd0\u884c\u5f02\u5e38: java\u76d1\u542c\u5e76\u8c03\u7528js\u51fd\u6570 (\u540e\u7eed\u51e1\u662fJava \u8c03\u7528 JS \u51fd\u6570\u90fd\u4f1a\u5728\u6b64\u5904\u7406\u5f02\u5e38)");
            RuntimeException exception = this.handleException(languageContext, e, true, RuntimeException.class);
            throw ScriptException.wrap(exception);
        }
        finally {
            if (needsEnter) {
                try {
                    this.layer.engine.leaveCached(prev, context);
                }
                catch (Throwable e) {
                    throw this.handleException(languageContext, e, false, RuntimeException.class);
                }
            }
        }
    }

    private <E extends Throwable> E handleException(PolyglotLanguageContext languageContext, Throwable e, boolean entered, Class<E> exceptionType) {
        if (!this.seenError) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.seenError = true;
        }
        KingScriptChanges.fixed("\u8fd4\u56de\u5f02\u5e38\u5bf9\u8c61\u4f9b\u4e0a\u5c42\u5305\u88c5, \u539f\u65b9\u6cd5\u4e3a\u76f4\u63a5 throw \u5f02\u5e38");
        return (E)((Object)PolyglotImpl.guestToHostException((PolyglotLanguageContext)languageContext, (Throwable)e, (boolean)entered));
    }

    protected abstract Object executeImpl(PolyglotLanguageContext var1, Object var2, Object[] var3);

    static <T> T installHostCodeCache(PolyglotLanguageContext languageContext, Object key, T value, Class<T> expectedType) {
        T result = expectedType.cast(languageContext.getLanguageInstance().hostToGuestCodeCache.putIfAbsent(key, value));
        if (result != null) {
            return result;
        }
        return value;
    }

    static <T> T lookupHostCodeCache(PolyglotLanguageContext languageContext, Object key, Class<T> expectedType) {
        return expectedType.cast(languageContext.getLanguageInstance().hostToGuestCodeCache.get(key));
    }
}

