/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.debug.Breakpoint;
import com.oracle.truffle.api.debug.DebugValue;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.debug.SourceElement;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.tools.chromeinspector.ScriptsHandler;
import com.oracle.truffle.tools.chromeinspector.commands.Params;
import com.oracle.truffle.tools.chromeinspector.events.Event;
import com.oracle.truffle.tools.chromeinspector.events.EventHandler;
import com.oracle.truffle.tools.chromeinspector.server.CommandProcessException;
import com.oracle.truffle.tools.chromeinspector.types.Location;
import com.oracle.truffle.tools.chromeinspector.types.Script;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;

final class BreakpointsHandler {
    private long lastID = 0L;
    private final DebuggerSession ds;
    private final ScriptsHandler slh;
    private final ResolvedHandler resolvedHandler;
    private final Map<Breakpoint, Long> bpIDs = new HashMap<Breakpoint, Long>();
    private final Map<Breakpoint, SourceSection> resolvedBreakpoints = new HashMap<Breakpoint, SourceSection>();
    private final Map<Long, ScriptsHandler.LoadScriptListener> scriptListeners = new HashMap<Long, ScriptsHandler.LoadScriptListener>();
    private final AtomicReference<Breakpoint> exceptionBreakpoint = new AtomicReference();

    BreakpointsHandler(DebuggerSession ds, ScriptsHandler slh, Supplier<EventHandler> eventHandler) {
        this.ds = ds;
        this.slh = slh;
        this.resolvedHandler = new ResolvedHandler(eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getId(Breakpoint bp) {
        Map<Breakpoint, Long> map = this.bpIDs;
        synchronized (map) {
            Long id = this.bpIDs.get(bp);
            if (id != null) {
                return id.toString();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Params createURLBreakpoint(Object url0, int line, int column, String condition) {
        ScriptsHandler.LoadScriptListener scriptListener;
        long id;
        KingScriptChanges.fixed("\u6807\u51c6\u5316\u8c03\u8bd5scriptPath");
        if (url0 instanceof String) {
            url0 = DebuggerSetBreakpointByUrl.formatScriptPath((String)url0);
        }
        Object url = url0;
        JSONArray locations = new JSONArray();
        Map<Breakpoint, Long> map = this.bpIDs;
        synchronized (map) {
            id = ++this.lastID;
            scriptListener = script -> {
                if (url instanceof Pattern ? ((Pattern)url).matcher(script.getUrl()).matches() : ScriptsHandler.compareURLs((String)url, script.getUrl())) {
                    Breakpoint bp = BreakpointsHandler.createBuilder(script.getSourceLoaded(), line, column).resolveListener(this.resolvedHandler).build();
                    if (condition != null && !condition.isEmpty()) {
                        bp.setCondition(condition);
                    }
                    bp = this.ds.install(bp);
                    Map<Breakpoint, Long> map = this.bpIDs;
                    synchronized (map) {
                        this.bpIDs.put(bp, id);
                        SourceSection section = this.resolvedBreakpoints.remove(bp);
                        if (section != null) {
                            Location resolvedLocation = new Location(script.getId(), section.getStartLine(), section.getStartColumn());
                            locations.put((Object)resolvedLocation.toJSON());
                        }
                    }
                }
            };
            this.scriptListeners.put(id, scriptListener);
        }
        this.slh.addLoadScriptListener(scriptListener, true);
        JSONObject json = new JSONObject();
        json.put("breakpointId", (Object)Long.toString(id));
        json.put("locations", (Object)locations);
        return new Params(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Params createBreakpoint(Location location, String condition) throws CommandProcessException {
        long id;
        Script script = this.slh.getScript(location.getScriptId());
        if (script == null) {
            throw new CommandProcessException("No script with id '" + location.getScriptId() + "'");
        }
        Breakpoint bp = BreakpointsHandler.createBuilder(script.getSourceLoaded(), location.getLine(), location.getColumn()).resolveListener(this.resolvedHandler).build();
        if (condition != null && !condition.isEmpty()) {
            bp.setCondition(condition);
        }
        bp = this.ds.install(bp);
        Location resolvedLocation = location;
        Map<Breakpoint, Long> map = this.bpIDs;
        synchronized (map) {
            id = ++this.lastID;
            this.bpIDs.put(bp, id);
            SourceSection section = this.resolvedBreakpoints.remove(bp);
            if (section != null) {
                resolvedLocation = new Location(location.getScriptId(), section.getStartLine(), section.getStartColumn());
            }
        }
        JSONObject json = new JSONObject();
        json.put("breakpointId", (Object)Long.toString(id));
        json.put("actualLocation", (Object)resolvedLocation.toJSON());
        return new Params(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeBreakpoint(String idStr) {
        boolean bpRemoved = false;
        try {
            long id = Long.parseLong(idStr);
            Map<Breakpoint, Long> map = this.bpIDs;
            synchronized (map) {
                Iterator<Map.Entry<Breakpoint, Long>> bpEntryIt = this.bpIDs.entrySet().iterator();
                while (bpEntryIt.hasNext()) {
                    Map.Entry<Breakpoint, Long> bpEntry = bpEntryIt.next();
                    if (id != bpEntry.getValue()) continue;
                    Breakpoint bp = bpEntry.getKey();
                    if (bp != null) {
                        bp.dispose();
                    }
                    bpEntryIt.remove();
                    bpRemoved = true;
                }
                ScriptsHandler.LoadScriptListener scriptListener = this.scriptListeners.remove(id);
                if (scriptListener != null) {
                    this.slh.removeLoadScriptListener(scriptListener);
                    bpRemoved = true;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bpRemoved;
    }

    void createOneShotBreakpoint(Location location) throws CommandProcessException {
        Script script = this.slh.getScript(location.getScriptId());
        if (script == null) {
            throw new CommandProcessException("No script with id '" + location.getScriptId() + "'");
        }
        Breakpoint bp = BreakpointsHandler.createBuilder(script.getSourceLoaded(), location.getLine(), location.getColumn()).oneShot().build();
        this.ds.install(bp);
    }

    void setExceptionBreakpoint(boolean caught, boolean uncaught) {
        Breakpoint oldBp;
        Breakpoint newBp = null;
        if (caught || uncaught) {
            newBp = Breakpoint.newExceptionBuilder(caught, uncaught).build();
            this.ds.install(newBp);
        }
        if ((oldBp = this.exceptionBreakpoint.getAndSet(newBp)) != null) {
            oldBp.dispose();
        }
    }

    private static Breakpoint.Builder createBuilder(Source source, int line, int column) {
        Breakpoint.Builder builder = Breakpoint.newBuilder(source).lineIs(line);
        if (column > 0) {
            builder.columnIs(column);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Params createFunctionBreakpoint(DebugValue functionValue, String condition) {
        long id;
        SourceSection functionLocation = functionValue.getSourceLocation();
        Breakpoint.Builder builder = functionLocation != null ? Breakpoint.newBuilder(functionLocation) : Breakpoint.newBuilder((URI)null);
        builder.rootInstance(functionValue);
        builder.sourceElements(SourceElement.ROOT);
        Breakpoint bp = builder.build();
        if (condition != null && !condition.isEmpty()) {
            bp.setCondition(condition);
        }
        this.ds.install(bp);
        Map<Breakpoint, Long> map = this.bpIDs;
        synchronized (map) {
            id = ++this.lastID;
            this.bpIDs.put(bp, id);
        }
        JSONObject json = new JSONObject();
        json.put("breakpointId", (Object)Long.toString(id));
        return new Params(json);
    }

    void removeFunctionBreakpoint(DebugValue functionValue) {
        List<Breakpoint> breakpoints = functionValue.getRootInstanceBreakpoints();
        for (Breakpoint breakpoint : breakpoints) {
            String id = this.getId(breakpoint);
            if (id == null) continue;
            this.removeBreakpoint(id);
        }
    }

    private final class ResolvedHandler
    implements Breakpoint.ResolveListener {
        private final Supplier<EventHandler> eventHandler;

        private ResolvedHandler(Supplier<EventHandler> eventHandler) {
            this.eventHandler = eventHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void breakpointResolved(Breakpoint breakpoint, SourceSection section) {
            Long breakpointId;
            Map map = BreakpointsHandler.this.bpIDs;
            synchronized (map) {
                breakpointId = (Long)BreakpointsHandler.this.bpIDs.get(breakpoint);
                if (breakpointId == null) {
                    BreakpointsHandler.this.resolvedBreakpoints.put(breakpoint, section);
                    return;
                }
            }
            int scriptId = BreakpointsHandler.this.slh.getScriptId(section.getSource());
            KingScriptChanges.fixed("\u6807\u6ce8\u65e0\u6548\u65ad\u70b9");
            Location location = section.getCharIndex() == 0 && section.getSource().getLength() == section.getCharEndIndex() && section.getStartLine() == 1 && section.getStartColumn() == 1 ? new Location(scriptId, 0, 0) : new Location(scriptId, section.getStartLine(), section.getStartColumn());
            JSONObject jsonParams = new JSONObject();
            jsonParams.put("breakpointId", (Object)Long.toString(breakpointId));
            jsonParams.put("location", (Object)location.toJSON());
            Params params = new Params(jsonParams);
            Event event = new Event("Debugger.breakpointResolved", params);
            this.eventHandler.get().event(event);
        }
    }
}

