/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.api.debug.BreakpointTestConditionContext;
import com.oracle.truffle.api.debug.DebuggerSession;
import com.oracle.truffle.api.instrumentation.LoadSourceEvent;
import com.oracle.truffle.api.instrumentation.LoadSourceListener;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.tools.chromeinspector.types.Script;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGo;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.engine.EvalContext;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.exception.ScriptException;

public final class ScriptsHandler
implements LoadSourceListener {
    private static final AtomicInteger globalId = new AtomicInteger();
    private final Map<Source, Integer> sourceIDs = new HashMap<Source, Integer>(100);
    private final List<Script> scripts = new ArrayList<Script>(100);
    private final Map<String, Integer> uniqueSourceNames = new HashMap<String, Integer>();
    private final List<LoadScriptListener> listeners = new ArrayList<LoadScriptListener>();
    private final boolean reportInternal;
    private final TruffleInstrument.Env env;
    private volatile DebuggerSession debuggerSession;
    private Map<Integer, Script> engineInstanceIdScriptCache = new ConcurrentHashMap<Integer, Script>();

    ScriptsHandler(TruffleInstrument.Env env, boolean reportInternal) {
        this.env = env;
        this.reportInternal = reportInternal;
    }

    void setDebuggerSession(DebuggerSession debuggerSession) {
        this.debuggerSession = debuggerSession;
    }

    DebuggerSession getDebuggerSession() {
        return this.debuggerSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getScriptId(Source source) {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            Integer id = this.sourceIDs.get(source);
            if (id != null) {
                return id;
            }
        }
        return -1;
    }

    public Script getScript(int id) {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            KingScriptChanges.fixed("JVM\u5168\u5c40\u552f\u4e00script id");
            Script ret = this.engineInstanceIdScriptCache.get(id);
            if (ret != null) {
                return ret;
            }
            for (Script script : this.scripts) {
                if (script.getId() != id) continue;
                this.engineInstanceIdScriptCache.put(id, script);
                return script;
            }
            throw new ScriptException("Can not found script by id: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Script> getScripts() {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            return Collections.unmodifiableList(this.scripts);
        }
    }

    void addLoadScriptListener(LoadScriptListener listener) {
        this.addLoadScriptListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLoadScriptListener(LoadScriptListener listener, boolean installBreakpoint) {
        ArrayList<Script> scriptsToNotify;
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            this.listeners.add(listener);
            scriptsToNotify = new ArrayList<Script>(this.scripts);
        }
        KingScriptChanges.fixed("\u4e0d\u8981\u63a8\u9001\u5df2\u7ecf\u52a0\u8f7d\u7684source: Debugger.scriptParsed");
        if (installBreakpoint) {
            for (Script scr : scriptsToNotify) {
                listener.loadedScript(scr);
            }
        }
    }

    private boolean isPushParsed(KingScriptEngineImpl engine, Script script) {
        String debugId;
        String sessionId = AccountProvider.get().getSessionId();
        String name = engine.getPool().getName();
        int p = name.lastIndexOf("(");
        if (p != -1) {
            name = name.substring(0, p);
        }
        return (debugId = DebugInfoRegistry.get().findDebugId(script.getUrl(), name, sessionId)) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLoadScriptListener(LoadScriptListener listener) {
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Script assureLoaded(Source sourceLoaded) {
        LoadScriptListener[] listenersToNotify;
        Script scr;
        DebuggerSession ds = this.debuggerSession;
        Source sourceResolved = sourceLoaded;
        if (ds != null) {
            sourceResolved = ds.resolveSource(sourceLoaded);
        }
        Source source = sourceResolved != null ? sourceResolved : sourceLoaded;
        Map<Source, Integer> map = this.sourceIDs;
        synchronized (map) {
            Integer eid = this.sourceIDs.get(source);
            if (eid != null) {
                Script scr2 = this.getScript(eid);
                assert (scr2 != null) : sourceLoaded;
                return scr2;
            }
            KingScriptChanges.fixed("\u4e1a\u52a1\u8c03\u8bd5\u5468\u671f\u8de8\u811a\u672c\u5f15\u64ce\uff0c\u9700\u8981JVM\u5168\u5c40\u552f\u4e00id\u6807\u8bc6\u6e90\u7801\u3002");
            int id = globalId.incrementAndGet();
            String sourceUrl = this.getSourceURL(source);
            scr = new Script(id, sourceUrl, source, sourceLoaded);
            this.sourceIDs.put(source, id);
            this.sourceIDs.put(sourceLoaded, id);
            LoadScriptListener[] loadScriptListenerArray = this.sourceIDs;
            synchronized (this.sourceIDs) {
                int i = 0;
                for (Script script : new ArrayList<Script>(this.scripts)) {
                    if (sourceUrl.equals(this.getSourceURL(script.getSource()))) {
                        this.scripts.remove(i);
                        int removedId = script.getId();
                        for (Map.Entry<Source, Integer> item : new HashMap<Source, Integer>(this.sourceIDs).entrySet()) {
                            if (item.getValue() != removedId) continue;
                            this.sourceIDs.remove(item.getKey());
                        }
                        break;
                    }
                    ++i;
                }
                // ** MonitorExit[var11_13] (shouldn't be in output)
                this.scripts.add(scr);
                listenersToNotify = this.listeners.toArray(new LoadScriptListener[this.listeners.size()]);
            }
        }
        {
            EvalContext evalContext = EvalContext.get();
            if (evalContext != null) {
                String debugId = evalContext.getDebugId();
                KingScriptEngineImpl engine = evalContext.getEngine();
                boolean scriptParsed = false;
                for (LoadScriptListener l : listenersToNotify) {
                    if (!this.isPushParsed(engine, scr)) continue;
                    l.loadedScript(scr);
                    scriptParsed = true;
                }
                if (scriptParsed && BreakpointTestConditionContext.get() == null) {
                    DebuggerGo.wait(debugId);
                }
            }
            return scr;
        }
    }

    public String getSourceURL(Source source) {
        KingScriptChanges.fixed("\u6807\u51c6\u5316\u8c03\u8bd5scriptPath");
        return DebuggerSetBreakpointByUrl.formatScriptPath(source.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceURL0(Source source) {
        URL url = source.getURL();
        if (url != null) {
            return url.toExternalForm();
        }
        String path = source.getPath();
        if (path != null) {
            if (source.getURI().isAbsolute()) {
                return source.getURI().toString();
            }
            try {
                return this.env.getTruffleFile(path).getAbsoluteFile().toUri().toString();
            }
            catch (SecurityException ex) {
                if (File.separatorChar == '/') {
                    return path;
                }
                return path.replace(File.separatorChar, '/');
            }
        }
        String name = source.getName();
        if (name != null) {
            String uniqueName;
            Map<String, Integer> map = this.uniqueSourceNames;
            synchronized (map) {
                int count = this.uniqueSourceNames.getOrDefault(name, 0);
                if (++count == 1) {
                    uniqueName = name;
                } else {
                    while (this.uniqueSourceNames.containsKey(uniqueName = count + "/" + name) && count++ > 0) {
                    }
                }
                this.uniqueSourceNames.put(name, count);
            }
            return uniqueName;
        }
        return source.getURI().toString();
    }

    public void onLoad(LoadSourceEvent event) {
        Source source = event.getSource();
        if (this.reportInternal || !source.isInternal()) {
            this.assureLoaded(source);
        }
    }

    static boolean compareURLs(String url1, String url2) {
        String surl2;
        String surl1 = ScriptsHandler.stripScheme(url1);
        return surl1.equals(surl2 = ScriptsHandler.stripScheme(url2)) || surl1.startsWith("/") && surl1.substring(1).equals(surl2);
    }

    private static String stripScheme(String url) {
        if (url.startsWith("file://")) {
            return url.substring("file://".length());
        }
        return url;
    }

    static interface LoadScriptListener {
        public void loadedScript(Script var1);
    }
}

