/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.commands;

import com.oracle.truffle.KingScriptChanges;
import com.oracle.truffle.tools.chromeinspector.commands.Params;
import com.oracle.truffle.tools.utils.json.JSONException;
import com.oracle.truffle.tools.utils.json.JSONObject;

public final class Command {
    public static final String DEBUGID = "debugId";
    public static final String SID = "sid";
    public static final String CID = "cid";
    public static final String ID = "id";
    public static final String METHOD = "method";
    public static final String PARAMS = "params";
    private final long id;
    private final String method;
    private final Params params;
    private String _sid;
    private String _cid;
    private String _debugId;

    public Command(String jsonStr) throws JSONException {
        JSONObject json = new JSONObject(jsonStr);
        KingScriptChanges.fixed("\u589e\u52a0debugId\uff0cInspectServerSession\u9700\u8981\u7528\u5230\u3002");
        this._debugId = json.getString(DEBUGID);
        this._sid = json.getString(SID);
        if (json.has(CID)) {
            this._cid = json.getString(CID);
        }
        this.id = json.has(ID) ? json.getLong(ID) : 0L;
        this.method = json.getString(METHOD);
        if (json.has(PARAMS)) {
            JSONObject paramsJson = json.getJSONObject(PARAMS);
            this.params = new Params(paramsJson);
        } else {
            this.params = null;
        }
    }

    public Command(long id, String method, Params params) {
        this.id = id;
        this.method = method;
        this.params = params;
    }

    public long getId() {
        return this.id;
    }

    public String getMethod() {
        return this.method;
    }

    public Params getParams() {
        return this.params;
    }

    public String getDebugId() {
        return this._debugId;
    }

    public String getSid() {
        return this._sid;
    }

    public String getCid() {
        return this._cid;
    }
}

