/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.config;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.config.LazySetHolder;
import kd.sdk.kingscript.debug.client.SteppedTiming;
import kd.sdk.kingscript.debug.dlock.DLocker;
import kd.sdk.kingscript.exception.ScriptException;

final class AccountProviderHolder {
    private static AccountProvider DEFAULT = new AccountProvider(){
        private Map<String, DLocker> lockerMap = new ConcurrentHashMap<String, DLocker>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DLocker tryLock(String key, long timeout) {
            Map<String, DLocker> map = this.lockerMap;
            synchronized (map) {
                DLocker locker = this.lockerMap.get(key);
                if (locker != null) {
                    try {
                        SteppedTiming.waitWithTimeoutException(timeout, 200L, this.lockerMap, () -> !this.lockerMap.containsKey(key), "Waiting lock timeout: " + key);
                    }
                    catch (InterruptedException e) {
                        throw ScriptException.asRuntime(e);
                    }
                }
                AtomicBoolean closed = new AtomicBoolean();
                locker = () -> {
                    Map<String, DLocker> map = this.lockerMap;
                    synchronized (map) {
                        if (closed.compareAndSet(false, true)) {
                            this.lockerMap.remove(key);
                            this.lockerMap.notifyAll();
                        }
                    }
                };
                this.lockerMap.put(key, locker);
                return locker;
            }
        }

        @Override
        public String getTenantCode() {
            return "";
        }

        @Override
        public String getAccountId() {
            return "ACCOUNT_SHARED";
        }

        @Override
        public String getSessionId() {
            return "NO_SESSION";
        }

        @Override
        public String getUserName() {
            return "NO_USER";
        }
    };
    static final LazySetHolder<AccountProvider> HOLDER = new LazySetHolder<AccountProvider>("kingscript.accountProvider", DEFAULT);

    AccountProviderHolder() {
    }
}

