/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.config;

import java.lang.reflect.Method;
import java.util.function.Supplier;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.lib.store.ScriptStoreType;
import kd.sdk.kingscript.monitor.cost.Collector;
import org.apache.commons.lang3.StringUtils;

public final class Env {
    @ConfigurableItem(desc="\u5f53\u524d\u662f\u5426\u672a\u65e7\u82cd\u7a79\u7248\u672c(\u652f\u63012023-10-28\u4e4b\u524d\u7684\u7248\u672c\uff0c\u7528\u4e8e\u5f00\u53d1\u73af\u5883)")
    private static final String KINGSCRIPT_OLD_COSMIC = "kingscript.cosmic.oldVersion";
    private static boolean oldCosmic = Boolean.parseBoolean(System.getProperty("kingscript.cosmic.oldVersion", "false"));
    @ConfigurableItem(desc="\u82cd\u7a79\u73af\u5883\u4e0b\u662f\u5426\u542f\u7528(\u521d\u59cb\u5316)\u811a\u672c\u5f15\u64ce\u7684\u5f00\u5173")
    public static final String KINGSCRIPT_ENABLE = "kingscript.service.enable";

    public static boolean isProdMode() {
        String key = AccountProvider.get().getTenantCode() + "_env.type";
        return "prod".equals(System.getProperty(key));
    }

    public static void autoSetupEnv() {
        oldCosmic = Boolean.parseBoolean(System.getProperty(KINGSCRIPT_OLD_COSMIC, "false"));
        if (oldCosmic) {
            Env.setupOldCosmicEnv();
        } else {
            Env.setupCosmicEnv();
        }
    }

    public static void setupCosmicEnv() {
        oldCosmic = false;
        System.setProperty(KINGSCRIPT_ENABLE, "true");
        if (System.getProperty("kingscript.store.type", "").isEmpty()) {
            System.setProperty("kingscript.store.type", ScriptStoreType.DB.name());
            System.setProperty("kingscript.store.type.db.class", "kd.bos.form.plugin.KingScriptStore");
        }
        if (System.getProperty("kingscript.script.version.store", "").isEmpty()) {
            System.setProperty("kingscript.script.version.store", "kd.sdk.bos.config.ScriptVersionStoreOfRedis");
        }
        if (System.getProperty("kingscript.accountProvider", "").isEmpty()) {
            System.setProperty("kingscript.accountProvider", "kd.sdk.bos.config.AccountProviderImpl");
        }
        if (System.getProperty("kingscript.debug.WsMessagePusher", "").isEmpty()) {
            System.setProperty("kingscript.debug.WsMessagePusher", "kd.bos.devportal.script.npm.ScriptPushMessageHandle");
        }
        if (System.getProperty("kingscript.debug.WsMessagePusher.vscode", "").isEmpty()) {
            System.setProperty("kingscript.debug.WsMessagePusher.vscode", "kd.bos.kingscript.openapi.debug.VSCodePushMessageHandle");
        }
        if (System.getProperty("kingscript.debug.ThreadLocalRestorer", "").isEmpty()) {
            System.setProperty("kingscript.debug.ThreadLocalRestorer", "kd.sdk.bos.config.DebugThreadLocalRestorerImpl");
        }
        if (System.getProperty("kingscript.debug.DebugInfoRegistry", "").isEmpty()) {
            System.setProperty("kingscript.debug.DebugInfoRegistry", "kd.sdk.kingscript.debug.client.registry.RedisDebugInfoRegistryImpl");
        }
        if (System.getProperty("kingscript.debug.WsClientRegistryStore", "").isEmpty()) {
            System.setProperty("kingscript.debug.WsClientRegistryStore", "kd.sdk.kingscript.debug.ws.registry.RedisWsClientRegistryStoreImpl");
        }
        if (System.getProperty("kingscript.validator.generic", "").isEmpty()) {
            System.setProperty("kingscript.validator.generic", "kd.sdk.bos.config.TypeScriptISVValidator");
        }
    }

    public static void setupOldCosmicEnv() {
        Collector.setEnabled(true);
        oldCosmic = true;
        System.setProperty(KINGSCRIPT_ENABLE, "true");
        System.setProperty("kingscript.store.type", ScriptStoreType.FILE.name());
        try {
            Class<?> cls = Class.forName("kd.sdk.bos.launch.ProjectInitializer");
            Method setEnvInitialize = cls.getMethod("setEnvInitialize", String.class);
            setEnvInitialize.invoke(null, "@env/initialize");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.setProperty("kingscript.preheat.editor.modules", "@cosmic/bos-script");
    }

    public static boolean isOldCosmic() {
        return oldCosmic;
    }

    public static boolean isKingScriptEnable() {
        return Env.getPropertyOrReturnTrue(() -> System.getProperty(KINGSCRIPT_ENABLE));
    }

    private static boolean getPropertyOrReturnTrue(Supplier<String> supplier) {
        String value = supplier.get();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return true;
    }
}

