/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kd.sdk.kingscript.debug.DebugThreadLocalRestorers;
import kd.sdk.kingscript.debug.cache.DebugCache;
import kd.sdk.kingscript.debug.callchain.DebugCallChain;
import kd.sdk.kingscript.debug.callchain.DebugCallSpan;
import kd.sdk.kingscript.debug.client.DebugClient;
import kd.sdk.kingscript.debug.client.PushController;
import kd.sdk.kingscript.debug.client.RequestMethods;
import kd.sdk.kingscript.debug.client.SteppedTiming;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.ErrorResponse;
import kd.sdk.kingscript.debug.client.inspect.command.JsonRpcErrorCode;
import kd.sdk.kingscript.debug.client.inspect.command.MessageType;
import kd.sdk.kingscript.debug.client.inspect.command.Result;
import kd.sdk.kingscript.debug.client.inspect.domain.Debugger;
import kd.sdk.kingscript.debug.client.inspect.domain.Runtime;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.inspect.interceptor.MessageProcessor;
import kd.sdk.kingscript.debug.client.inspect.interceptor.RequestSequence;
import kd.sdk.kingscript.debug.client.messagepusher.WsMessageLogOuter;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.debug.client.remote.RemoteDebugClient;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.debug.ws.WsClient;
import kd.sdk.kingscript.debug.ws.WsClientImpl;
import kd.sdk.kingscript.debug.ws.protocol.PushMessageHandler;
import kd.sdk.kingscript.debug.ws.registry.WsClientRegistry;
import kd.sdk.kingscript.exception.ScriptException;
import kd.sdk.kingscript.exception.ScriptTimeoutException;
import kd.sdk.kingscript.log.Loggable;
import kd.sdk.kingscript.util.Call;
import kd.sdk.kingscript.util.JsonUtil;
import kd.sdk.kingscript.util.Tuple;

public final class LocalDebugClient
implements DebugClient,
Loggable {
    private final String debugId;
    final PushMessageHandler originalPushMessageHandler;
    private final PushMessageHandler pushMessageHandler;
    private final MessageProcessor processor;
    private AtomicReference<Tuple<Command, Object>> request = new AtomicReference();
    private Map<String, Object> requestingEnv = new HashMap<String, Object>();
    private volatile boolean waitingComplete = false;
    private Debugger debugger;
    private Runtime runtime;

    public static void removeCache(String debugId) {
        DebugCache.remove(debugId + "#LocalDebugClient");
    }

    static LocalDebugClient getOrCreate(String debugId, PushMessageHandler pushMessageHandler) {
        LocalDebugClient client = (LocalDebugClient)DebugCache.get(debugId + "#LocalDebugClient");
        if (client == null) {
            client = new LocalDebugClient(debugId, pushMessageHandler);
            DebugCache.set(debugId + "#LocalDebugClient", client);
        }
        return client;
    }

    private LocalDebugClient(String debugId, PushMessageHandler pushMessageHandler) {
        this.debugId = debugId;
        this.processor = new MessageProcessor(debugId);
        if (pushMessageHandler == null) {
            logger.warn("[" + debugId + "] PushMessageHandler is null, use " + WsMessageLogOuter.outer.getClass().getName() + " to output the messages.");
            pushMessageHandler = WsMessageLogOuter.outer;
        }
        this.originalPushMessageHandler = pushMessageHandler;
        this.pushMessageHandler = msg -> DebugThreadLocalRestorers.callInRestored(debugId, () -> {
            JSONObject json = JsonUtil.parseObject(msg);
            if (RequestSequence.isEvent(json)) {
                this.push_event(msg, json);
            } else {
                this.response_method(msg, json);
            }
        });
    }

    private void push_event(String msg, JSONObject json) {
        try {
            String sid = RequestSequence.nextSID(this.debugId);
            try (DebugCallSpan span = DebugCallChain.create(this.debugId, json.getString("cid"), sid, json.getString("method"), MessageType.EVENT, "push_event");){
                this.processor.processEvent(sid, msg, json, ret -> {
                    if (ret != null) {
                        JSONObject retJson = JsonUtil.parseObject(ret);
                        if (logger.isInfoEnabled()) {
                            if (DebugConfig.isKdpLogDetail()) {
                                LocalDebugClient.logKDP("Push " + ret);
                            } else {
                                LocalDebugClient.logKDP("Push SID " + sid + " - " + retJson.getString("method") + " - " + this.debugId);
                            }
                        }
                        PushController.push(this, ret);
                        if (DebugConfig.isKdpEchoCommand(this.debugId)) {
                            this.echoCommand(ret, false);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            String error = "Push event error: " + e.getMessage() + " , the message is: " + msg;
            logger.error(error, e);
            throw new ScriptException(error, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void response_method(String msg, JSONObject json) {
        Object span;
        Tuple<Command, Object> response = this.request.get();
        if (response == null) {
            return;
        }
        AtomicReference<ScriptException> retRef = new AtomicReference<ScriptException>();
        Command command = response.getKey();
        try {
            span = DebugCallChain.create(this.debugId, command.getCid(), command.getSid(), command.getMethod(), MessageType.RESPONSE_METHOD, "response_method");
            Throwable throwable = null;
            try {
                this.processor.processResponse(msg, command, ret -> {
                    retRef.set((ScriptException)((Object)ret));
                    if (ret != null) {
                        if (logger.isInfoEnabled()) {
                            if (DebugConfig.isKdpLogDetail()) {
                                LocalDebugClient.logKDP("Response " + ret);
                            } else {
                                String resp = command.getSid() + " - " + command.getMethod() + " - " + this.debugId;
                                String cid = command.getCid();
                                if (cid != null) {
                                    resp = cid + '-' + resp;
                                }
                                LocalDebugClient.logKDP("Response " + resp);
                            }
                        }
                        if ("Debugger.disable".equals(command.getMethod())) {
                            if (DebugConfig.isKdpEchoCommand(this.debugId)) {
                                this.echoCommand(ret, false);
                            }
                            PushController.push(this, ret);
                        } else {
                            PushController.push(this, ret);
                            if (DebugConfig.isKdpEchoCommand(this.debugId)) {
                                this.echoCommand(ret, false);
                            }
                        }
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (span != null) {
                    if (throwable != null) {
                        try {
                            ((DebugCallSpan)span).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((DebugCallSpan)span).close();
                    }
                }
            }
        }
        catch (Throwable e) {
            String error = "Response method error: " + e.getMessage() + " , the message is: " + msg;
            logger.error(error, e);
            ScriptException ex = new ScriptException(error, e);
            retRef.set(ex);
            throw ex;
        }
        finally {
            span = this.request;
            synchronized (span) {
                response.setValue(retRef.get());
                this.request.notifyAll();
            }
        }
    }

    public void connect() {
        this.connect(WsClientRegistry.get().getWsUrl(this.debugId));
    }

    public void connect(String wsUrl) {
        WsClientImpl wsClient = new WsClientImpl(this.debugId, wsUrl, msg -> this.sendBack(msg));
        wsClient.connect();
        WsClient.setCache(this.debugId, wsClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            WsClientRegistry.get().unRegister(this.debugId);
        }
        finally {
            WsClient wsClient = WsClient.getCache(this.debugId);
            if (wsClient != null) {
                try {
                    WsClient.removeCache(this.debugId);
                }
                finally {
                    wsClient.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitComplete() {
        AtomicReference<Tuple<Command, Object>> atomicReference = this.request;
        synchronized (atomicReference) {
            this.waitingComplete = true;
            try {
                if (this.request.get() != null) {
                    String msg = "[" + this.debugId + "] waitComplete (@" + Thread.currentThread().getName() + "): " + this.requestingEnv;
                    logger.info(msg);
                    SteppedTiming.wait(DebugConfig.getRequestCommandTimeout(), 1000L, this.request, () -> this.request.get() == null);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.waitingComplete = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String waitAndGetResponse() {
        try {
            SteppedTiming.waitWithTimeoutException(DebugConfig.getRequestCommandTimeout(), 200L, this.request, () -> this.request.get().getValue() != null, "waitAndGetResponse timeout: " + this.request.get().getKey().toJSONString());
            Object obj = this.request.get().getValue();
            if (obj instanceof Throwable) {
                throw ScriptException.asRuntime((Throwable)obj);
            }
            return (String)obj;
        }
        catch (ScriptTimeoutException e) {
            AtomicReference<Tuple<Command, Object>> atomicReference = this.request;
            synchronized (atomicReference) {
                this.request.set(null);
                this.request.notifyAll();
            }
            throw e;
        }
        catch (InterruptedException e) {
            throw ScriptException.asRuntime(e);
        }
    }

    @Override
    public void inspect(String msg) {
        this.requestSync(msg);
    }

    /*
     * Exception decompiling
     */
    public String requestSync(String msg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long requestAsync(String msg) {
        WsClient wsClient = WsClient.getCache(this.debugId);
        if (wsClient == null && !DebugInfoRegistry.get().hasRegistered(this.debugId)) {
            return this.request_prepare(msg);
        }
        if (wsClient != null) {
            return this.request_normal(wsClient, msg);
        }
        String wsUrl = WsClientRegistry.get().getWsUrl(this.debugId);
        if (wsUrl == null) {
            return this.request_snoop(msg);
        }
        return this.request_remote(msg);
    }

    private Command parseRequestCommand(String msg, boolean genSID) {
        return this.parseRequestCommand(msg, genSID, true);
    }

    private Command parseRequestCommand(String msg, boolean genSID, boolean useRequest) {
        Command command = Command.parse(msg);
        if (genSID) {
            String sid = "Debugger.prepare".equals(command.getMethod()) ? RequestSequence.resetSID(this.debugId) : RequestSequence.nextSID(this.debugId);
            command.setSid(sid);
        }
        command.setDebugId(this.debugId);
        if (useRequest) {
            this.request.set(new Tuple<Command, Object>(command, null));
        }
        return command;
    }

    private long request_prepare(String msg) {
        Command command = this.parseRequestCommand(msg, true);
        Throwable throwable = null;
        try (DebugCallSpan span = DebugCallChain.create(this.debugId, command.getCid(), command.getSid(), command.getMethod(), MessageType.REQUEST_METHOD, "request_prepare");){
            String method = command.getMethod();
            if (RequestMethods.allowRequestBeforePrepare(method)) {
                this.processor.processRequest(command, ret -> {
                    if (logger.isInfoEnabled()) {
                        if (DebugConfig.isKdpLogDetail()) {
                            LocalDebugClient.logKDP("Request " + command.toJSONString());
                        } else {
                            LocalDebugClient.logKDP("Request " + command.getSid() + " - " + method + " - " + this.debugId);
                        }
                    }
                    this.callWithEchoCommand(() -> this.sendBackEmptyResult(command), command);
                });
                long l = Long.parseLong(command.getSid());
                return l;
            }
            try {
                this.processor.onSkipProcessRequest(command);
                String error = "Debugger not prepare, or the session has been lost, or script engine is not in running(debugId=" + this.debugId + ")--please dot it before startup or during breakpoint paused.";
                throw new ScriptException(error);
            }
            catch (Throwable t) {
                long l = this.onRequestError_process_command(command, t);
                return l;
            }
        }
    }

    private long request_normal(WsClient wsClient, String msg) {
        Command command = this.parseRequestCommand(msg, true);
        Throwable throwable = null;
        try (DebugCallSpan span = DebugCallChain.create(this.debugId, command.getCid(), command.getSid(), command.getMethod(), MessageType.REQUEST_METHOD, "request_normal");){
            this.processor.processRequest(command, ret -> {
                if (ret == null) {
                    if (logger.isInfoEnabled()) {
                        if (DebugConfig.isKdpLogDetail()) {
                            LocalDebugClient.logKDP("Request " + command.toJSONString());
                        } else {
                            LocalDebugClient.logKDP("Request " + command.getSid() + " - " + command.getMethod() + " - " + this.debugId);
                        }
                    }
                    this.callWithEchoCommand(() -> this.sendBackEmptyResult(command), command);
                } else {
                    if (logger.isInfoEnabled()) {
                        if (DebugConfig.isKdpLogDetail()) {
                            LocalDebugClient.logKDP("Request " + ret);
                        } else {
                            LocalDebugClient.logKDP("Request " + command.getSid() + " - " + command.getMethod() + " - " + this.debugId);
                        }
                    }
                    this.callWithEchoCommand(() -> wsClient.send(ret), command);
                }
            });
            long l = Long.parseLong(command.getSid());
            return l;
        }
        catch (Throwable t) {
            long l = this.onRequestError_process_command(command, t);
            return l;
        }
    }

    /*
     * Loose catch block
     */
    private long request_snoop(String msg) {
        Command command;
        block22: {
            command = this.parseRequestCommand(msg, true);
            Throwable throwable = null;
            try (DebugCallSpan span = DebugCallChain.create(this.debugId, command.getCid(), command.getSid(), command.getMethod(), MessageType.REQUEST_METHOD, "request_snoop");){
                block23: {
                    String method = command.getMethod();
                    if (!RequestMethods.allowRequestWhileSnoop(method)) break block23;
                    try {
                        this.processor.processRequest(command, ret -> {
                            if (logger.isInfoEnabled()) {
                                if (DebugConfig.isKdpLogDetail()) {
                                    LocalDebugClient.logKDP("Request " + command.toJSONString());
                                } else {
                                    LocalDebugClient.logKDP("Request " + command.getSid() + " - " + method + " - " + this.debugId);
                                }
                            }
                            this.callWithEchoCommand(() -> this.sendBackEmptyResult(command), command);
                        });
                        long l = Long.parseLong(command.getSid());
                        return l;
                    }
                    catch (Throwable t) {
                        long l;
                        block20: {
                            block21: {
                                l = this.onRequestError_process_command(command, t);
                                if (span == null) break block20;
                                if (throwable == null) break block21;
                                try {
                                    span.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block20;
                            }
                            span.close();
                        }
                        return l;
                    }
                }
                this.processor.onSkipProcessRequest(command);
                break block22;
                {
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                }
            }
        }
        String error = "The session has been lost, or script engine is not in running, please dot it before startup or during breakpoint paused. (debugId:" + this.debugId + ")";
        return this.onRequestError_executing_engine_not_found(command, error);
    }

    private long request_remote(String msg) {
        RemoteDebugClient remoteDebugClient = new RemoteDebugClient(this.debugId);
        Command command = this.parseRequestCommand(msg, false);
        try (DebugCallSpan span = DebugCallChain.create(this.debugId, command.getCid(), "-1", command.getMethod(), MessageType.REQUEST_METHOD, "request_remote");){
            span.setRemoteCall(true);
            String finalRet = remoteDebugClient.requestSync(msg);
            long sid = JsonUtil.parseObject(finalRet).getLong("sid");
            command.setSid(String.valueOf(sid));
            this.request.get().setValue(finalRet);
            span.setSid(sid);
            long l = sid;
            return l;
        }
    }

    private long onRequestError_process_command(Command command, Throwable t) {
        String msg = "ProcessRequest " + command.getMethod() + " error: " + t.getMessage() + ", command: " + command.toJSONString();
        logger.error(msg, t);
        if (!DebuggerDisable.isDisabled(this.debugId)) {
            ErrorResponse errorResponse = new ErrorResponse(command.getId(), JsonRpcErrorCode.PROCESS_COMMAND_ERROR.getCode(), msg);
            this.sendBack(errorResponse.toString());
        }
        return Long.parseLong(command.getSid());
    }

    private long onRequestError_executing_engine_not_found(Command command, String error) {
        if (!DebuggerDisable.isDisabled(this.debugId)) {
            String msg = "ProcessRequest " + command.getMethod() + " error: " + error;
            ErrorResponse errorResponse = new ErrorResponse(command.getId(), JsonRpcErrorCode.EXECUTING_ENGINE_NOT_FOUND.getCode(), msg);
            this.sendBack(errorResponse.toString());
        }
        return Long.parseLong(command.getSid());
    }

    private void sendBackEmptyResult(Command command) {
        String result = new Result().toJSONString(command.getId(), command.getDebugId(), command.getMethod(), command.getSid(), command.getCid());
        this.sendBack(result);
    }

    public void sendBack(String msg) {
        this.pushMessageHandler.pushMessage(msg);
    }

    public void sendBackWithoutProcess(String msg) {
        PushController.push(this, msg);
    }

    @Override
    public PushMessageHandler getPushMessageHandler() {
        return this.pushMessageHandler;
    }

    public String getDebugId() {
        return this.debugId;
    }

    @Override
    public Debugger getDebugger() {
        if (this.debugger == null) {
            this.debugger = new Debugger(this);
        }
        return this.debugger;
    }

    @Override
    public Runtime getRuntime() {
        if (this.runtime == null) {
            this.runtime = new Runtime(this);
        }
        return this.runtime;
    }

    private void callWithEchoCommand(Call call, Command command) {
        boolean echoCommand = DebugConfig.isKdpEchoCommand(this.debugId);
        if (echoCommand && "Debugger.disable".equals(command.getMethod())) {
            this.echoCommand(command.toJSONString(), true);
        }
        call.call();
        if (echoCommand && !"Debugger.disable".equals(command.getMethod())) {
            this.echoCommand(command.toJSONString(), true);
        }
    }

    private void echoCommand(String ret, boolean request) {
        JSONObject json = JsonUtil.parseObject(ret);
        String method = json.getString("method");
        if (method != null && !"Runtime.consoleAPICalled".equals(method)) {
            String cid = json.getString("cid");
            if (cid == null) {
                cid = "-";
            }
            String sid = json.getString("sid");
            String consoleMessage = (request ? "-->" : "<--") + cid + '-' + sid + ' ' + method;
            this.getRuntime().runAsync(() -> this.getRuntime().notifyConsoleLog(consoleMessage));
        }
    }

    public static void logKDP(String msg) {
        logger.info(msg);
    }

    private /* synthetic */ Boolean lambda$requestSync$7() {
        return this.request.get() == null;
    }
}

