/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.sdk.kingscript.debug.DebugEngineHub;
import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.config.DebugConfig;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.exception.WsDisconnectException;
import kd.sdk.kingscript.pool.KingScriptEngineProxy;

class PushController {
    PushController() {
    }

    static void push(LocalDebugClient client, String msg) {
        try {
            client.originalPushMessageHandler.pushMessage(msg);
        }
        catch (Throwable e) {
            PushController.closeEngineOnDisconnect(client.getDebugId());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static void checkWebSocketAlive(LocalDebugClient client) {
        String debugId = client.getDebugId();
        if (DebugEngineHub.getEngine(debugId) != null && !client.originalPushMessageHandler.isConnectionAlive(debugId) && PushController.closeEngineOnDisconnect(debugId)) {
            throw new WsDisconnectException("websocket disconnected, the debugId is:" + debugId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean closeEngineOnDisconnect(String debugId) {
        KingScriptEngine engine = DebugEngineHub.getEngine(debugId);
        if (engine != null) {
            AtomicBoolean closed = new AtomicBoolean();
            CountDownLatch done = PushController.interruptDebugThread(debugId, closed);
            try {
                Thread.State state;
                Thread webSocketThread = DebugEngineHub.getWebSocketThread(debugId);
                if (webSocketThread != null && webSocketThread != Thread.currentThread() && webSocketThread.isAlive() && ((state = webSocketThread.getState()) == Thread.State.WAITING || state == Thread.State.TIMED_WAITING)) {
                    webSocketThread.interrupt();
                }
                if (engine instanceof KingScriptEngineProxy) {
                    ((KingScriptEngineProxy)engine).forceClose();
                } else {
                    engine.close();
                }
            }
            finally {
                DebugEngineHub.removeWebSocketThread(debugId);
                closed.set(true);
            }
            try {
                done.await(DebugConfig.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LocalDebugClient.removeCache(debugId);
        return engine != null;
    }

    private static CountDownLatch interruptDebugThread(String debugId, final AtomicBoolean closed) {
        final CountDownLatch done = new CountDownLatch(1);
        final Thread debugThread = Thread.currentThread();
        Thread cth = new Thread("interrupt-debug-" + debugId){

            @Override
            public void run() {
                try {
                    do {
                        Thread.sleep(200L);
                        if (closed.get()) continue;
                        debugThread.interrupt();
                    } while (!closed.get());
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    done.countDown();
                }
            }
        };
        cth.setDaemon(true);
        cth.start();
        return done;
    }
}

