/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.command;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.interceptor.RequestSequence;
import kd.sdk.kingscript.exception.ScriptException;

public final class Command {
    public static final long ID_METHOD_HOLDER = 0L;
    public static final long ID_EVENT_HOLDER = -1L;
    public static final String DEBUGID = "debugId";
    private static final JSONObject emptyParams = new JSONObject();
    public static final String CID = "cid";
    public static final String SID = "sid";
    public static final String ID = "id";
    public static final String METHOD = "method";
    public static final String PARAMS = "params";
    private String _debugId;
    private String _cid;
    private String _sid;
    private long id;
    private final String method;
    private final Params params;

    public static Command createEvent(String method, Params params) {
        return new Command(-1L, method, params);
    }

    public static Command createMethod(String method, Params params) {
        return new Command(0L, method, params);
    }

    public static Command createAPI(long cid, String method, Params params) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CID, (Object)cid);
        jsonObject.put(METHOD, (Object)method);
        jsonObject.put(PARAMS, (Object)(params == null ? null : params.getJSONObject()));
        return Command.parse(jsonObject);
    }

    public static Command parse(JSONObject json) {
        return new Command(json);
    }

    public static Command parse(String message) {
        try {
            return new Command(message);
        }
        catch (JSONException ex) {
            throw new ScriptException("Illegal message: '" + message + "' " + ex.getLocalizedMessage());
        }
    }

    private Command(String jsonStr) throws JSONException {
        this(JSONObject.parseObject((String)jsonStr));
    }

    private Command(JSONObject json) throws JSONException {
        this._debugId = json.getString(DEBUGID);
        this._cid = json.getString(CID);
        this._sid = json.getString(SID);
        Long id = json.getLong(ID);
        this.id = id == null ? 0L : id;
        this.method = json.getString(METHOD);
        if (json.get((Object)PARAMS) != null) {
            JSONObject paramsJson = json.getJSONObject(PARAMS);
            this.params = new Params(paramsJson);
        } else {
            this.params = null;
        }
    }

    private Command(long id, String method, Params params) {
        this.id = id;
        this.method = method;
        this.params = params;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getMethod() {
        return this.method;
    }

    public Params getParams() {
        return this.params;
    }

    public String getDebugId() {
        return this._debugId;
    }

    public String getCid() {
        return this._cid;
    }

    public String getSid() {
        return this._sid;
    }

    public void setSid(String sid) {
        this._sid = sid;
    }

    public void setDebugId(String debugId) {
        this._debugId = debugId;
    }

    public String toJSONString() {
        JSONObject json = new JSONObject();
        if (this._debugId != null) {
            json.put(DEBUGID, (Object)this._debugId);
        }
        if (this._cid != null) {
            json.put(CID, (Object)this._cid);
        }
        if (this._sid != null) {
            json.put(SID, (Object)this._sid);
        }
        RequestSequence.setId(json, this.id);
        json.put(METHOD, (Object)this.method);
        json.put(PARAMS, (Object)(this.params == null ? emptyParams : this.params.getJSONObject()));
        return json.toString();
    }

    public String toString() {
        return this.toJSONString();
    }
}

