/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.event;

import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.debug.client.inspect.domain.event.AbstractEventInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CustomCommandInterceptor;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;

public class DebuggerBreakpointResolved
extends AbstractEventInterceptor
implements CustomCommandInterceptor {
    public static final String METHOD = "Debugger.breakpointResolved";

    @Override
    public String interceptPush(String debugId, String msg, JSONObject jsonObject) {
        SourceMap.Location sourceLocation;
        JSONObject locationObject = jsonObject.getJSONObject("params").getJSONObject("location");
        String scriptId = locationObject.getString("scriptId");
        String url = DebugInfoRegistry.get().getScriptPath(debugId, scriptId);
        int lineNumber = locationObject.getInteger("lineNumber");
        Integer columnNumber = locationObject.getInteger("columnNumber");
        if (lineNumber >= 0 && columnNumber != null && columnNumber >= 0 && (sourceLocation = DebuggerSetBreakpointByUrl.mappingSourceLocation(debugId, url, new SourceMap.Location(lineNumber, columnNumber))) != null) {
            locationObject.put("lineNumber", (Object)sourceLocation.getLineNumber());
            locationObject.put("columnNumber", (Object)sourceLocation.getColumnNumber());
            return jsonObject.toJSONString();
        }
        return msg;
    }
}

