/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.domain.event.AbstractEventInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;

public class DebuggerPaused
extends AbstractEventInterceptor {
    public static final String METHOD = "Debugger.paused";
    public static final String REQUEST_MESSAGE = Command.createEvent("Debugger.paused", null).toJSONString();

    @Override
    public String interceptPush(String debugId, String msg, JSONObject msgJsonObject) {
        JSONArray callFrames = msgJsonObject.getJSONObject("params").getJSONArray("callFrames");
        int n = callFrames.size();
        for (int i = 0; i < n; ++i) {
            int columnNumber;
            int lineNumber;
            SourceMap.Location sourceLocation;
            JSONObject callFrame = callFrames.getJSONObject(i);
            String url = callFrame.getString("url");
            JSONObject location = callFrame.getJSONObject("location");
            if (location != null && (sourceLocation = DebuggerSetBreakpointByUrl.mappingSourceLocation(debugId, url, new SourceMap.Location(lineNumber = location.getInteger("lineNumber").intValue(), columnNumber = location.getInteger("columnNumber").intValue()))) != null) {
                location.put("lineNumber", (Object)sourceLocation.getLineNumber());
                location.put("columnNumber", (Object)sourceLocation.getColumnNumber());
            }
            if ((location = callFrame.getJSONObject("functionLocation")) == null || (sourceLocation = DebuggerSetBreakpointByUrl.mappingSourceLocation(debugId, url, new SourceMap.Location(lineNumber = location.getInteger("lineNumber").intValue(), columnNumber = location.getInteger("columnNumber").intValue()))) == null) continue;
            location.put("lineNumber", (Object)sourceLocation.getLineNumber());
            location.put("columnNumber", (Object)sourceLocation.getColumnNumber());
        }
        return msgJsonObject.toJSONString();
    }
}

