/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.event;

import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.domain.event.AbstractEventInterceptor;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.util.JsonUtil;

public class RuntimeConsoleAPICalled
extends AbstractEventInterceptor {
    public static final String METHOD = "Runtime.consoleAPICalled";

    public static String create(ConsoleAPICalledEventType type, String debugId, Object text) {
        long contextId = DebugInfoRegistry.get().getRuntimeExecutionContextId(debugId);
        Params params = Params.createConsoleAPICalled(type.type(), text, contextId);
        Command cmd = Command.createEvent(METHOD, params);
        return cmd.toJSONString();
    }

    public static Object getArgs(String msg) {
        return JsonUtil.parseObject(msg).getJSONObject("params").getJSONArray("args");
    }

    public static enum ConsoleAPICalledEventType {
        log("log"),
        debug("debug"),
        info("info"),
        error("error"),
        warning("warning"),
        dir("dir"),
        dirxml("dirxml"),
        table("table"),
        trace("trace"),
        clear("clear"),
        startGroup("startGroup"),
        startGroupCollapsed("startGroupCollapsed"),
        endGroup("endGroup"),
        assert_("assert"),
        profile("profile"),
        profileEnd("profileEnd"),
        count("count"),
        timeEnd("timeEnd");

        private final String type;

        private ConsoleAPICalledEventType(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

