/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import kd.sdk.kingscript.debug.DebugEngineHub;
import kd.sdk.kingscript.debug.callchain.DebugCallChain;
import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGo;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerReady;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.debug.keepalive.KeepAliveService;
import kd.sdk.kingscript.debug.ws.WsClient;
import kd.sdk.kingscript.exception.ScriptException;

public class DebuggerDisable
extends AbstractMethodInterceptor {
    public static final String METHOD = "Debugger.disable";
    public static final String REQUEST_MESSAGE = Command.createMethod("Debugger.disable", null).toJSONString();

    @Override
    public void afterResponse(String debugId, String responseMessage, Command requestCommand) {
        DebuggerDisable.disable(debugId);
    }

    public static void checkUnDisabled(String debugId) {
        if (DebuggerDisable.isDisabled(debugId)) {
            throw new ScriptException("Debugger is disabled, debugId: " + debugId);
        }
    }

    public static boolean isDisabled(String debugId) {
        return DebugInfoRegistry.get().isDisabled(debugId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void disable(String debugId) {
        try {
            DebugCallChain.logCallChain(debugId);
            KeepAliveService.remove(debugId);
            LocalDebugClient.removeCache(debugId);
            DebugEngineHub.removeCache(debugId);
            DebugInfoRegistry dir = DebugInfoRegistry.get();
            dir.setDisable(debugId);
            dir.unRegister(debugId);
        }
        catch (Throwable throwable) {
            try {
                WsClient wsClient = WsClient.getCache(debugId);
                if (wsClient == null) throw throwable;
                wsClient.disconnect();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw throwable;
            }
            finally {
                DebuggerReady.notifyIfStillWait(debugId);
                DebuggerGo.notifyIfStillWait(debugId);
            }
        }
        try {
            WsClient wsClient = WsClient.getCache(debugId);
            if (wsClient == null) return;
            wsClient.disconnect();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            DebuggerReady.notifyIfStillWait(debugId);
            DebuggerGo.notifyIfStillWait(debugId);
        }
    }

    public static String createForApi(long cid) {
        return Command.createAPI(cid, METHOD, null).toJSONString();
    }
}

