/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.debug.client.DebugClient;
import kd.sdk.kingscript.debug.client.LocalDebugClient;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.ErrorResponse;
import kd.sdk.kingscript.debug.client.inspect.command.JsonRpcErrorCode;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.command.Result;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.keepalive.KeepAliveService;

public class DebuggerKeepAlive
extends AbstractMethodInterceptor {
    public static final String METHOD = "Debugger.keepAlive";
    private static final String REQUEST_MESSAGE = Command.createMethod("Debugger.keepAlive", null).toJSONString();

    public static String create() {
        return REQUEST_MESSAGE;
    }

    public static String create(long timeout) {
        JSONObject json = new JSONObject();
        json.put("timeout", (Object)timeout);
        return Command.createMethod(METHOD, new Params(json)).toJSONString();
    }

    @Override
    public boolean isPseudoMethod() {
        return true;
    }

    @Override
    public String interceptRequest(String debugId, String msg, Command cmd) {
        throw new UnsupportedOperationException("Debugger.keepAlive can't be go here.");
    }

    public static String requestKeepAlive(String debugId, String msg, Command cmd) {
        Long timeout;
        LocalDebugClient localDebugClient = (LocalDebugClient)DebugClient.getOrCreate(debugId);
        if (DebuggerDisable.isDisabled(debugId)) {
            ErrorResponse errorResponse = new ErrorResponse(cmd.getId(), JsonRpcErrorCode.DEBUGGER_DISABLED.getCode(), "Debug has disabled: " + debugId);
            return errorResponse.toString();
        }
        long aliveTimeout = KeepAliveService.getDefaultAliveTimeout();
        Params params = cmd.getParams();
        if (params != null && (timeout = params.getJSONObject().getLong("timeout")) != null) {
            aliveTimeout = timeout;
        }
        KeepAliveService.setKeepAlive(debugId, aliveTimeout);
        JSONObject json = new JSONObject();
        json.put("timeout", (Object)String.valueOf(aliveTimeout));
        String result = new Result(new Params(json)).toJSONString(cmd.getId(), cmd.getDebugId(), cmd.getMethod(), cmd.getSid(), cmd.getCid());
        localDebugClient.sendBackWithoutProcess(result);
        return result;
    }

    public static void touchKeepAlive(String debugId) {
        if (DebuggerDisable.isDisabled(debugId)) {
            return;
        }
        KeepAliveService.touchKeepAlive(debugId);
    }
}

