/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CustomCommandInterceptor;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.exception.ScriptException;

public class DebuggerPrepare
extends AbstractMethodInterceptor
implements CustomCommandInterceptor {
    public static final String METHOD = "Debugger.prepare";

    @Override
    public boolean isPseudoMethod() {
        return true;
    }

    @Override
    public String interceptRequest(String debugId, String msg, Command cmd) {
        Params params = cmd.getParams();
        JSONObject json = params.getJSONObject();
        String enginePoolName = json.getString("enginePoolName");
        JSONArray array = json.getJSONArray("scriptPaths");
        if (array == null || array.isEmpty()) {
            throw new ScriptException("[" + debugId + "] scriptPaths can't be empty");
        }
        String[] scriptPaths = (String[])array.toArray((Object[])new String[array.size()]);
        DebugInfoRegistry.get().register(debugId, scriptPaths, enginePoolName, AccountProvider.get().getSessionId(), AccountProvider.get().getUserName());
        return null;
    }

    public static String create(String enginePoolName, String ... scriptPaths) {
        JSONObject json = new JSONObject();
        json.put("enginePoolName", (Object)enginePoolName);
        JSONArray array = new JSONArray();
        array.addAll(Arrays.asList(scriptPaths));
        json.put("scriptPaths", (Object)array);
        return Command.createMethod(METHOD, new Params(json)).toJSONString();
    }

    public static String createForApi(long cid, String enginePoolName, String ... scriptPaths) {
        JSONObject json = new JSONObject();
        json.put("enginePoolName", (Object)enginePoolName);
        JSONArray array = new JSONArray();
        array.addAll(Arrays.asList(scriptPaths));
        json.put("scriptPaths", (Object)array);
        return Command.createAPI(cid, METHOD, new Params(json)).toJSONString();
    }
}

