/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.config.AccountProvider;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.transpiler.sourcemap.SourceMap;

public class DebuggerSetBreakpoint
extends AbstractMethodInterceptor {
    public static final String METHOD = "Debugger.setBreakpoint";

    @Override
    public String interceptRequest(String debugId, String msg, Command cmd) {
        DebugInfoRegistry dir = DebugInfoRegistry.get();
        String enginePoolName = dir.findEnginePoolName(debugId);
        if (enginePoolName == null) {
            return msg;
        }
        JSONObject params = cmd.getParams().getJSONObject();
        JSONObject location = params.getJSONObject("location");
        String url = DebugInfoRegistry.get().getScriptPath(cmd.getDebugId(), location.getString("scriptId"));
        dir.register(debugId, new String[]{url}, enginePoolName, AccountProvider.get().getSessionId(), AccountProvider.get().getUserName());
        int lineNumber = location.getInteger("lineNumber");
        int columnNumber = location.getInteger("columnNumber");
        SourceMap.Location targetLocation = DebuggerSetBreakpointByUrl.mappingTargetLocation(cmd.getDebugId(), url, new SourceMap.Location(lineNumber, columnNumber));
        if (targetLocation == null) {
            return null;
        }
        if (targetLocation.getLineNumber() != lineNumber || targetLocation.getColumnNumber() != columnNumber) {
            location.put("lineNumber", (Object)lineNumber);
            location.put("columnNumber", (Object)columnNumber);
            return cmd.toJSONString();
        }
        return msg;
    }
}

