/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.domain.request;

import com.alibaba.fastjson.JSONArray;
import com.oracle.truffle.tools.chromeinspector.commands.Command;
import com.oracle.truffle.tools.chromeinspector.server.InspectServerSession;
import com.oracle.truffle.tools.utils.json.JSONObject;
import java.util.List;
import kd.sdk.kingscript.debug.client.inspect.command.Params;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CustomCommandInterceptor;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.exception.ScriptException;

public class DebuggerSwitchEngine
extends AbstractMethodInterceptor
implements CustomCommandInterceptor {
    public static final String METHOD = "Debugger.switchEngine";
    public static final String REQUEST_MESSAGE = kd.sdk.kingscript.debug.client.inspect.command.Command.createMethod("Debugger.switchEngine", null).toJSONString();
    public static final String PARAMS_REPLAY_REQUEST = "replayMessageList";
    public static final String PARAMS_REPLAY_RESPONSE = "replayResultList";

    @Override
    public String interceptRequest(String debugId, String requestMessage, kd.sdk.kingscript.debug.client.inspect.command.Command requestCommand) {
        DebugInfoRegistry diRegistry = DebugInfoRegistry.get();
        JSONArray replayList = new JSONArray();
        List<String> savedReplayMessageList = diRegistry.getReplayMessageList(debugId);
        replayList.addAll(savedReplayMessageList);
        Params params = requestCommand.getParams();
        params.getJSONObject().put(PARAMS_REPLAY_REQUEST, (Object)replayList);
        return requestCommand.toJSONString();
    }

    public static void saveForReplay(String debugId, String method, String msg) {
        DebugInfoRegistry.get().removeThenAddReplayMessage(debugId, method, msg);
    }

    public static com.oracle.truffle.tools.chromeinspector.commands.Params replay(Command cmd, InspectServerSession.CommandPostProcessor postProcessor, ProcessCommandCall call) {
        com.oracle.truffle.tools.utils.json.JSONArray replayResultList = new com.oracle.truffle.tools.utils.json.JSONArray();
        for (Object replayMsg : cmd.getParams().getJSONObject().getJSONArray(PARAMS_REPLAY_REQUEST)) {
            Command replayCmd = new Command((String)replayMsg);
            JSONObject replayRet = call.processCommand(replayCmd, postProcessor);
            if (replayRet.has("error")) {
                JSONObject errorJson = replayRet.getJSONObject("error");
                String error = "[" + cmd.getDebugId() + "] " + METHOD + " error, replay " + replayCmd.getMethod() + " return: " + errorJson.getString("message") + "(error code: " + errorJson.getLong("code") + ").";
                throw new ScriptException(error);
            }
            replayResultList.put((Object)replayRet.toString());
        }
        JSONObject params = new JSONObject();
        params.put(PARAMS_REPLAY_RESPONSE, (Object)replayResultList);
        return new com.oracle.truffle.tools.chromeinspector.commands.Params(params);
    }

    public static interface ProcessCommandCall {
        public JSONObject processCommand(Command var1, InspectServerSession.CommandPostProcessor var2);
    }

    public static interface Replayable {
    }
}

