/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.interceptor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerBreakpointResolved;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerEvalBegan;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerEvalEnded;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerPaused;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerPrepared;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerResumed;
import kd.sdk.kingscript.debug.client.inspect.domain.event.DebuggerScriptParsed;
import kd.sdk.kingscript.debug.client.inspect.domain.event.RuntimeConsoleAPICalled;
import kd.sdk.kingscript.debug.client.inspect.domain.event.RuntimeExecutionContextCreated;
import kd.sdk.kingscript.debug.client.inspect.domain.event.RuntimeExecutionContextDestroyed;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerDisable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEchoCommand;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEnable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerEvaluateOnCallFrame;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGetPossibleBreakpoints;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGetProperties;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGetScriptSource;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerGo;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerPause;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerPrepare;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerReady;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerRemoveBreakpoint;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerResume;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetAsyncCallStackDepth;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBlackboxPatterns;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpoint;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointByUrl;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetBreakpointsActive;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetPauseOnExceptions;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetSkipAllPauses;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSetVariableValue;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepInto;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepOut;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerStepOver;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSwitchEngine;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeDisable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeEnable;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeEvaluate;
import kd.sdk.kingscript.debug.client.inspect.domain.request.RuntimeRunIfWaitingForDebugger;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CommandInterceptor;

public final class CommandInterceptors {
    private static final Map<String, CommandInterceptor> map = new ConcurrentHashMap<String, CommandInterceptor>();

    public static void addCommandInterceptor(CommandInterceptor commandInterceptor) {
        map.put(commandInterceptor.getMethod(), commandInterceptor);
    }

    public static CommandInterceptor get(String method) {
        if (method == null) {
            return null;
        }
        return map.get(method);
    }

    static {
        CommandInterceptors.addCommandInterceptor(new DebuggerBreakpointResolved());
        CommandInterceptors.addCommandInterceptor(new DebuggerEvalBegan());
        CommandInterceptors.addCommandInterceptor(new DebuggerEvalEnded());
        CommandInterceptors.addCommandInterceptor(new DebuggerPaused());
        CommandInterceptors.addCommandInterceptor(new DebuggerPrepared());
        CommandInterceptors.addCommandInterceptor(new DebuggerResumed());
        CommandInterceptors.addCommandInterceptor(new DebuggerScriptParsed());
        CommandInterceptors.addCommandInterceptor(new RuntimeConsoleAPICalled());
        CommandInterceptors.addCommandInterceptor(new RuntimeExecutionContextCreated());
        CommandInterceptors.addCommandInterceptor(new RuntimeExecutionContextDestroyed());
        CommandInterceptors.addCommandInterceptor(new DebuggerDisable());
        CommandInterceptors.addCommandInterceptor(new DebuggerEchoCommand());
        CommandInterceptors.addCommandInterceptor(new DebuggerEnable());
        CommandInterceptors.addCommandInterceptor(new DebuggerEvaluateOnCallFrame());
        CommandInterceptors.addCommandInterceptor(new DebuggerGetPossibleBreakpoints());
        CommandInterceptors.addCommandInterceptor(new DebuggerGetProperties());
        CommandInterceptors.addCommandInterceptor(new DebuggerGetScriptSource());
        CommandInterceptors.addCommandInterceptor(new DebuggerGo());
        CommandInterceptors.addCommandInterceptor(new DebuggerPause());
        CommandInterceptors.addCommandInterceptor(new DebuggerPrepare());
        CommandInterceptors.addCommandInterceptor(new DebuggerReady());
        CommandInterceptors.addCommandInterceptor(new DebuggerRemoveBreakpoint());
        CommandInterceptors.addCommandInterceptor(new DebuggerResume());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetAsyncCallStackDepth());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetBlackboxPatterns());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetBreakpoint());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetBreakpointByUrl());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetBreakpointsActive());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetPauseOnExceptions());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetSkipAllPauses());
        CommandInterceptors.addCommandInterceptor(new DebuggerSetVariableValue());
        CommandInterceptors.addCommandInterceptor(new DebuggerStepInto());
        CommandInterceptors.addCommandInterceptor(new DebuggerStepOut());
        CommandInterceptors.addCommandInterceptor(new DebuggerStepOver());
        CommandInterceptors.addCommandInterceptor(new DebuggerSwitchEngine());
        CommandInterceptors.addCommandInterceptor(new RuntimeDisable());
        CommandInterceptors.addCommandInterceptor(new RuntimeEnable());
        CommandInterceptors.addCommandInterceptor(new RuntimeEvaluate());
        CommandInterceptors.addCommandInterceptor(new RuntimeRunIfWaitingForDebugger());
    }
}

