/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.kingscript.debug.client.inspect.interceptor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.sdk.kingscript.debug.client.inspect.command.Command;
import kd.sdk.kingscript.debug.client.inspect.command.ErrorResponse;
import kd.sdk.kingscript.debug.client.inspect.domain.event.AbstractEventInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.AbstractMethodInterceptor;
import kd.sdk.kingscript.debug.client.inspect.domain.request.DebuggerSwitchEngine;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CommandInterceptor;
import kd.sdk.kingscript.debug.client.inspect.interceptor.CommandInterceptors;
import kd.sdk.kingscript.debug.client.inspect.interceptor.OriginalCall;
import kd.sdk.kingscript.debug.client.registry.DebugInfoRegistry;
import kd.sdk.kingscript.log.Loggable;

public final class MessageProcessor
implements Loggable {
    private final String debugId;

    public MessageProcessor(String debugId) {
        this.debugId = debugId;
    }

    private String wrapMessage(JSONObject json, String sid) {
        json.put("sid", (Object)sid);
        json.put("debugId", (Object)this.debugId);
        Long id = json.getLong("id");
        if (id != null && id < 0L) {
            json.remove((Object)"id");
        }
        return json.toJSONString();
    }

    public void processEvent(String sid, String msg, JSONObject msgJsonObject, OriginalCall cb) {
        this.doProcess(msg, msgJsonObject, null, cb, json -> this.wrapMessage(json, sid), false);
    }

    public void processResponse(String response, Command requestCommand, OriginalCall cb) {
        this.doProcess(response, null, requestCommand, cb, json -> {
            String cid = requestCommand.getCid();
            if (cid != null) {
                json.put("cid", (Object)cid);
            }
            json.put("method", (Object)requestCommand.getMethod());
            String ret = this.wrapMessage(json, requestCommand.getSid());
            if (ErrorResponse.isErrorResponse(json)) {
                logger.error(ret);
            }
            return ret;
        }, false);
    }

    public void onSkipProcessRequest(Command requestCommand) {
    }

    public void processRequest(Command requestCommand, OriginalCall cb) {
        this.doProcess(requestCommand.toJSONString(), null, requestCommand, cb, json -> this.wrapMessage(json, requestCommand.getSid()), true);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doProcess(String msg, JSONObject msgJsonObject, Command requestCommand, OriginalCall cb, Wrapper wrapper, boolean request) {
        String method = msgJsonObject == null ? requestCommand.getMethod() : msgJsonObject.getString("method");
        CommandInterceptor interceptor = CommandInterceptors.get(method);
        if (interceptor != null) {
            if (interceptor instanceof AbstractMethodInterceptor) {
                AbstractMethodInterceptor methodInterceptor = (AbstractMethodInterceptor)interceptor;
                if (request) {
                    void var10_14;
                    String string = methodInterceptor.interceptRequest(this.debugId, msg, requestCommand);
                    if (string == null || methodInterceptor.isPseudoMethod()) {
                        Object var10_12 = null;
                    } else {
                        String string2 = wrapper.wrap(JSON.parseObject((String)string));
                        if (methodInterceptor instanceof DebuggerSwitchEngine.Replayable && DebugInfoRegistry.get().getRequestEngineRound(this.debugId) == 1) {
                            DebuggerSwitchEngine.saveForReplay(this.debugId, method, msg);
                        }
                    }
                    cb.call((String)var10_14);
                    methodInterceptor.afterRequest(this.debugId, (String)var10_14, requestCommand);
                    return;
                } else {
                    void var10_18;
                    String string = methodInterceptor.interceptResponse(this.debugId, msg, requestCommand);
                    if (string == null) {
                        Object var10_16 = null;
                    } else {
                        String string3 = wrapper.wrap(JSON.parseObject((String)string));
                    }
                    cb.call((String)var10_18);
                    methodInterceptor.afterResponse(this.debugId, (String)var10_18, requestCommand);
                }
                return;
            } else {
                if (!(interceptor instanceof AbstractEventInterceptor)) throw new UnsupportedOperationException("Unsupported CommandInterceptor: " + interceptor);
                AbstractEventInterceptor eventInterceptor = (AbstractEventInterceptor)interceptor;
                String string4 = eventInterceptor.interceptPush(this.debugId, msg, msgJsonObject);
                string4 = wrapper.wrap(JSON.parseObject((String)string4));
                cb.call(string4);
                eventInterceptor.afterPush(this.debugId, string4);
            }
            return;
        } else {
            msg = wrapper.wrap(JSON.parseObject((String)msg));
            cb.call(msg);
        }
    }

    @FunctionalInterface
    private static interface Wrapper {
        public String wrap(JSONObject var1);
    }
}

